/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc;

import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.soc.video.VideoEngineInfo;
import com.ami.kvm.jviewer.soc.video.VideoHeader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SOCFrameHdr
implements ISOCFrameHdr {
    public static final int FRAME_TYPE_UNKNOWN = -1;
    public static short width;
    public static short height;
    public short resX;
    public short resY;
    public byte[] m_compressedBuf;
    private VideoHeader videoHdr = new VideoHeader();
    private VideoEngineInfo videoEngInfo = new VideoEngineInfo();
    public int frameSize;

    @Override
    public void setHeader(ByteBuffer byteBuffer) {
        this.m_compressedBuf = this.videoHdr.set(byteBuffer);
        int n = byteBuffer.limit();
        if (n == 86) {
            this.setFrameSize(byteBuffer);
        }
    }

    public byte[] getCompressedBuf() {
        return this.m_compressedBuf;
    }

    @Override
    public int getFrameType() {
        return -1;
    }

    public VideoEngineInfo getFrameVariables() {
        this.videoEngInfo.SourceModeInfo.X = this.videoHdr.SourceMode_X;
        this.videoEngInfo.SourceModeInfo.Y = this.videoHdr.SourceMode_Y;
        this.videoEngInfo.DestinationModeInfo.X = this.videoHdr.DestinationMode_X;
        this.videoEngInfo.DestinationModeInfo.Y = this.videoHdr.DestinationMode_Y;
        this.videoEngInfo.CompressData.CompressSize = this.videoHdr.CompressData_CompressSize;
        this.videoEngInfo.FrameHeader.RC4Enable = this.videoHdr.FrameHdr_RC4Enable;
        this.videoEngInfo.FrameHeader.RC4Reset = this.videoHdr.FrameHdr_RC4Reset;
        this.videoEngInfo.FrameHeader.Mode420 = this.videoHdr.Mode420;
        this.videoEngInfo.FrameHeader.JPEGScaleFactor = this.videoHdr.FrameHdr_JPEGScaleFactor;
        this.videoEngInfo.FrameHeader.NumberOfMB = this.videoHdr.FrameHdr_NumberOfMB;
        this.videoEngInfo.FrameHeader.AdvanceScaleFactor = this.videoHdr.FrameHdr_AdvanceScaleFactor;
        this.videoEngInfo.FrameHeader.JPEGTableSelector = this.videoHdr.FrameHdr_JPEGTableSelector;
        this.videoEngInfo.FrameHeader.AdvanceTableSelector = this.videoHdr.FrameHdr_AdvanceTableSelector;
        this.videoEngInfo.FrameHeader.JPEGYUVTableMapping = this.videoHdr.FrameHdr_JPEGYUVTableMapping;
        this.videoEngInfo.FrameHeader.SharpModeSelection = this.videoHdr.FrameHdr_SharpModeSelection;
        this.videoEngInfo.FrameHeader.CompressionMode = this.videoHdr.FrameHdr_CompressionMode;
        this.videoEngInfo.INFData.DownScalingMethod = this.videoHdr.InfData_DownScalingMethod;
        this.videoEngInfo.INFData.DifferentialSetting = this.videoHdr.InfData_DifferentialSetting;
        this.videoEngInfo.INFData.AnalogDifferentialThreshold = this.videoHdr.InfData_AnalogDifferentialThreshold;
        this.videoEngInfo.INFData.DigitalDifferentialThreshold = this.videoHdr.InfData_DigitalDifferentialThreshold;
        this.videoEngInfo.INFData.AutoMode = this.videoHdr.InfData_AutoMode;
        this.videoEngInfo.INFData.VQMode = this.videoHdr.InfData_VQMode;
        this.resX = this.videoEngInfo.DestinationModeInfo.X;
        this.resY = this.videoEngInfo.DestinationModeInfo.Y;
        width = this.videoEngInfo.DestinationModeInfo.X;
        height = this.videoEngInfo.DestinationModeInfo.Y;
        return this.videoEngInfo;
    }

    @Override
    public short getresX() {
        return this.resX;
    }

    @Override
    public short getresY() {
        return this.resY;
    }

    @Override
    public short getwidth() {
        return width;
    }

    @Override
    public short getheight() {
        return height;
    }

    @Override
    public short getcurwidth() {
        return width;
    }

    @Override
    public short getcurheight() {
        return height;
    }

    @Override
    public int getFrameHeadersize() {
        return 86;
    }

    @Override
    public int getFrameSize() {
        return this.frameSize;
    }

    private void setFrameSize(ByteBuffer byteBuffer) {
        int[] nArray = new int[2];
        byteBuffer.rewind();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        short s4 = byteBuffer.getShort();
        short s5 = byteBuffer.getShort();
        short s6 = byteBuffer.getShort();
        byte by = byteBuffer.get();
        short s7 = byteBuffer.getShort();
        short s8 = byteBuffer.getShort();
        short s9 = byteBuffer.getShort();
        short s10 = byteBuffer.getShort();
        byte by2 = byteBuffer.get();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        short s11 = byteBuffer.getShort();
        short s12 = byteBuffer.getShort();
        nArray[0] = byteBuffer.getInt();
        nArray[1] = byteBuffer.getInt();
        byte by3 = byteBuffer.get();
        byte by4 = byteBuffer.get();
        byte by5 = byteBuffer.get();
        byte by6 = byteBuffer.get();
        byte by7 = byteBuffer.get();
        byte by8 = byteBuffer.get();
        byte by9 = byteBuffer.get();
        int n3 = byteBuffer.getInt();
        byte by10 = byteBuffer.get();
        byte by11 = byteBuffer.get();
        byte by12 = byteBuffer.get();
        byte by13 = byteBuffer.get();
        byte by14 = byteBuffer.get();
        short s13 = byteBuffer.getShort();
        short s14 = byteBuffer.getShort();
        byte by15 = byteBuffer.get();
        byte by16 = byteBuffer.get();
        byte by17 = byteBuffer.get();
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        int n6 = byteBuffer.getInt();
        int n7 = byteBuffer.getInt();
        byte by18 = byteBuffer.get();
        short s15 = byteBuffer.getShort();
        short s16 = byteBuffer.getShort();
        this.frameSize = n5;
    }
}

