/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc.video;

import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.soc.SOCIVTPPktHdr;
import com.ami.kvm.jviewer.soc.SOCJVVideo;
import com.ami.kvm.jviewer.soc.video.HuffmanTable;
import com.ami.kvm.jviewer.soc.video.JTables;
import com.ami.kvm.jviewer.soc.video.VideoEngineInfo;
import java.util.Arrays;

public class Decoder {
    public static final int MAX_X_RESOLUTION = 1500;
    public static final int MAX_Y_RESOLUTION = 1500;
    private SOCJVVideo m_socvidClnt;
    private JViewerView m_view;
    private byte[] m_decodeBuf;
    private int[] previousYUVData;
    short signed_wordvalue;
    long uprdbuf_readbuf;
    int nZeroACTerms = 0;
    int[] rc4Tmp = new int[256];
    final int POWEROFTOW = 17;
    final int LENGTH_256 = 256;
    byte YQ_nr;
    byte CbQ_nr;
    byte CrQ_nr;
    byte m_YDC_nr;
    byte m_CbDC_nr;
    byte m_CrDC_nr;
    byte m_YAC_nr;
    byte m_CbAC_nr;
    byte m_CrAC_nr;
    static short[] m_DCY = new short[1];
    static short[] DCCb = new short[1];
    static short[] DCCr = new short[1];
    int[] YUVTile = new int[768];
    int[] m_DCT_coeff = new int[384];
    byte[] Y = new byte[64];
    byte[] Cb = new byte[64];
    byte[] Cr = new byte[64];
    final int RANGE_LIMIT_TABLE_SIZE = 1408;
    byte[] rangeLimitTable = new byte[1408];
    short[] rangeLimitTableShort = new short[1408];
    int[] calculatedRGBofY = new int[256];
    int[] calculatedRGBofCrToR = new int[256];
    int[] calculatedRGBofCbToB = new int[256];
    int[] calculatedRGBofCrToG = new int[256];
    int[] calculatedRGBofCbToG = new int[256];
    int position;
    int SCALEFACTOR;
    int SCALEFACTORUV;
    int ADVANCESCALEFACTOR;
    int ADVANCESCALEFACTORUV;
    int selector;
    int advance_selector;
    int Mapping;
    rc4_state s;
    boolean DecodeRC4State;
    byte m_Mode420 = 1;
    int txb;
    int tyb;
    int oldxb;
    int oldyb;
    long pixels;
    int readbuf;
    int m_codebuf;
    int m_newbuf;
    int codesize;
    static int m_newbits;
    COMPRESSHEADER yheader;
    COMPRESSHEADER uvheader;
    int[] m_RecvBuffer;
    int _index;
    int WIDTH;
    int HEIGHT;
    int tmp_HEIGHTBy16;
    int tmp_WIDTHBy16;
    int RealWIDTH;
    int RealHEIGHT;
    byte[] DecodeKeys = "fedcba9876543210".getBytes();
    byte[] buf;
    byte bp;
    int byte_pos;
    byte YH;
    byte YV;
    byte CbH;
    byte CbV;
    byte CrH;
    byte CrV;
    long[][] m_QT;
    HuffmanTable[] m_HTDC = new HuffmanTable[4];
    HuffmanTable[] m_HTAC = new HuffmanTable[4];
    byte[] tab_1 = new byte[64];
    byte[] tab_2 = new byte[64];
    byte[] tab_3 = new byte[64];
    byte[] tab_4 = new byte[64];
    short[] m_Cr_tab = new short[256];
    short[] m_Cb_tab = new short[256];
    short[] m_Cr_Cb_green_tab = new short[65536];
    byte d_k;
    short w1;
    short w2;
    int wordval;
    int[] m_mask = new int[17];
    short[] neg_pow2 = new short[17];
    public final int NO_LEAF = 0;
    public final int LEFT_LEAF = 1;
    public final int RIGHT_LEAF = 2;
    public final int VQ_BLOCK_START_CODE = 0;
    public final int JPEG_BLOCK_START_CODE = 1;
    public final int VQ_BLOCK_SKIP_CODE = 2;
    public final int JPEG_BLOCK_SKIP_CODE = 3;
    public final int BLOCK_START_LENGTH = 2;
    public final int BLOCK_START_MASK = 3;
    public final int BLOCK_HEADER_S_MASK = 1;
    public final int BLOCK_HEADER_MASK = 15;
    public final int VQ_HEADER_MASK = 1;
    public final int VQ_NO_UPDATE_HEADER = 0;
    public final int VQ_UPDATE_HEADER = 1;
    public final int VQ_NO_UPDATE_LENGTH = 3;
    public final int VQ_UPDATE_LENGTH = 27;
    public final int VQ_INDEX_MASK = 3;
    public final int VQ_COLOR_MASK = 0xFFFFFF;
    public final int JPEG_NO_SKIP_CODE = 0;
    public final int JPEG_NO_SKIP_PASS2_CODE = 2;
    public final int JPEG_SKIP_PASS2_CODE = 10;
    public final int LOW_JPEG_NO_SKIP_CODE = 4;
    public final int LOW_JPEG_SKIP_CODE = 12;
    public final int JPEG_SKIP_CODE = 8;
    public final int FRAME_END_CODE = 9;
    public final int VQ_NO_SKIP_1_COLOR_CODE = 5;
    public final int VQ_NO_SKIP_2_COLOR_CODE = 6;
    public final int VQ_NO_SKIP_4_COLOR_CODE = 7;
    public final int VQ_SKIP_1_COLOR_CODE = 13;
    public final int VQ_SKIP_2_COLOR_CODE = 14;
    public final int VQ_SKIP_4_COLOR_CODE = 15;
    public final int BLOCK_AST2100_START_LENGTH = 4;
    public final int BLOCK_AST2100_SKIP_LENGTH = 20;
    int[] workspace = new int[64];
    short lookBitResult;
    short[] DCT_tcoeff = new short[64];
    short[] min_code;
    short[] maj_code;
    short[] huff_values;
    final int FIX_1_082392200 = 277;
    final int FIX_1_414213562 = 362;
    final int FIX_1_847759065 = 473;
    final int FIX_2_613125930 = 669;
    final int DCTSIZE = 8;
    final int DCTSIZE_0 = 0;
    final int DCTSIZE_1 = 8;
    final int DCTSIZE_2 = 16;
    final int DCTSIZE_3 = 24;
    final int DCTSIZE_4 = 32;
    final int DCTSIZE_5 = 40;
    final int DCTSIZE_6 = 48;
    final int DCTSIZE_7 = 56;
    int[] YValueInTile = new int[768];
    int[][] YValueInTile420 = new int[4][64];
    int[] CbValueInTile = new int[64];
    int[] CrValueInTile = new int[64];
    COLOR_CACHE m_VQ = new COLOR_CACHE();

    final short WORD_hi_lo(byte by, byte by2) {
        return (short)(this.getShort(by) << 8 | this.getShort(by2));
    }

    final long getLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    final int getInt(int n) {
        return n & 0xFFFF;
    }

    final short getShort(byte by) {
        return (short)(by & 0xFF);
    }

    public Decoder(JViewerView jViewerView, byte[] byArray, SOCJVVideo sOCJVVideo) {
        int n;
        this.m_view = jViewerView;
        this.m_decodeBuf = byArray;
        this.m_socvidClnt = sOCJVVideo;
        this.position = 0;
        this.DecodeRC4State = false;
        this.m_YDC_nr = 0;
        this.m_CbDC_nr = 1;
        this.m_CrDC_nr = 1;
        this.m_YAC_nr = 0;
        this.m_CbAC_nr = 1;
        this.m_CrAC_nr = 1;
        this.d_k = 0;
        for (n = 1; n < 17; ++n) {
            int n2 = (int)(1.0 - Math.pow(2.0, n));
            this.neg_pow2[n] = (short)n2;
        }
        for (n = 0; n < 4; ++n) {
            this.m_HTDC[n] = new HuffmanTable();
            this.m_HTAC[n] = new HuffmanTable();
        }
        this.uvheader = new COMPRESSHEADER();
        this.yheader = new COMPRESSHEADER();
        this.w1 = 0;
        this.w2 = 0;
        this.bp = 0;
        this.wordval = 0;
        this.m_QT = new long[4][64];
        this.initColorTable();
        this.initRangeLimitTable();
        this.initHuffmanTable();
        this.previousYUVData = new int[7680000];
    }

    public final void setBuf(byte[] byArray) {
        this.m_decodeBuf = byArray;
    }

    final void initRangeLimitTable() {
        int n;
        Arrays.fill(this.rangeLimitTable, 0, 255, (byte)0);
        for (n = 0; n < 256; n = (int)((short)(n + 1))) {
            this.rangeLimitTable[256 + n] = (byte)n;
            this.rangeLimitTableShort[256 + n] = n;
        }
        Arrays.fill(this.rangeLimitTable, 512, 895, (byte)-1);
        Arrays.fill(this.rangeLimitTableShort, 512, 895, (short)255);
        Arrays.fill(this.rangeLimitTable, 896, 1279, (byte)0);
        Arrays.fill(this.rangeLimitTableShort, 896, 1279, (short)0);
        for (n = 1280; n < 1408; n = (int)((short)(n + 1))) {
            this.rangeLimitTable[n] = (byte)n;
            this.rangeLimitTableShort[n] = (short)(n & 0xFF);
        }
    }

    final short lookKbits(byte by) {
        return (short)(this.getLong(this.m_RecvBuffer[0]) >> 32 - by);
    }

    final void skipKbits(byte by) {
        if (m_newbits - by <= 0) {
            if (SOCIVTPPktHdr.VIRTADD + this._index > this.m_RecvBuffer.length - 1) {
                this._index = this.m_RecvBuffer.length - 1 - SOCIVTPPktHdr.VIRTADD;
            }
            this.m_RecvBuffer[0] = (int)(this.getLong(this.m_RecvBuffer[0]) << by) | (int)((this.getLong(this.m_RecvBuffer[1]) | this.getLong(this.m_RecvBuffer[SOCIVTPPktHdr.VIRTADD + this._index]) >> m_newbits) >> 32 - by);
            this.m_RecvBuffer[1] = (int)(this.getLong(this.m_RecvBuffer[SOCIVTPPktHdr.VIRTADD + this._index]) << by - m_newbits);
            m_newbits = 32 + m_newbits - by;
            ++this._index;
        } else {
            this.m_RecvBuffer[0] = this.m_RecvBuffer[0] << by | (int)(this.getLong(this.m_RecvBuffer[1]) >> 32 - by);
            this.m_RecvBuffer[1] = this.m_RecvBuffer[1] << by;
            m_newbits -= by;
        }
    }

    final short getKbits(byte by) {
        this.signed_wordvalue = this.lookKbits(by);
        if ((1L << by - 1 & (long)this.signed_wordvalue) == 0L) {
            this.signed_wordvalue = (short)(this.signed_wordvalue + this.neg_pow2[by]);
        }
        this.skipKbits(by);
        return this.signed_wordvalue;
    }

    final void calculate_mask() {
        for (int n = 0; n <= 16; n = (int)((byte)(n + 1))) {
            this.m_mask[n] = (int)((this.getLong(65536) >> n) - 1L);
        }
    }

    byte[] setQuantizationTable(byte[] byArray, byte by, byte[] byArray2) {
        for (int n = 0; n < 64; n = (int)((byte)(n + 1))) {
            int n2 = byArray[n] * 16 / by;
            if (n2 <= 0) {
                n2 = 1;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            byArray2[JTables.zigzag[n]] = (byte)n2;
        }
        return byArray2;
    }

    void loadLuminanceQuantizationTable(long[] lArray) {
        int n;
        float[] fArray = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
        byte[] byArray = new byte[64];
        switch (this.selector) {
            case 0: {
                JTables.std_luminance_qt = JTables.Tbl_000Y;
                break;
            }
            case 1: {
                JTables.std_luminance_qt = JTables.Tbl_014Y;
                break;
            }
            case 2: {
                JTables.std_luminance_qt = JTables.Tbl_029Y;
                break;
            }
            case 3: {
                JTables.std_luminance_qt = JTables.Tbl_043Y;
                break;
            }
            case 4: {
                JTables.std_luminance_qt = JTables.Tbl_057Y;
                break;
            }
            case 5: {
                JTables.std_luminance_qt = JTables.Tbl_071Y;
                break;
            }
            case 6: {
                JTables.std_luminance_qt = JTables.Tbl_086Y;
                break;
            }
            case 7: {
                JTables.std_luminance_qt = JTables.Tbl_100Y;
            }
        }
        byArray = this.setQuantizationTable(JTables.std_luminance_qt, (byte)this.SCALEFACTOR, byArray);
        for (n = 0; n <= 63; n = (int)((byte)(n + 1))) {
            lArray[n] = this.getShort(byArray[JTables.zigzag[n]]);
        }
        n = 0;
        for (int n2 = 0; n2 <= 7; n2 = (int)((byte)(n2 + 1))) {
            for (int n3 = 0; n3 <= 7; n3 = (int)((byte)(n3 + 1))) {
                int n4 = (int)((float)lArray[n] * (fArray[n2] * fArray[n3]));
                lArray[n] = n4 * 65536;
                n = (byte)(n + 1);
            }
        }
        this.byte_pos += 64;
    }

    void loadChrominanceQuantizationTable(long[] lArray) {
        int n;
        float[] fArray = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
        byte[] byArray = new byte[64];
        if (this.Mapping == 1) {
            switch (this.selector) {
                case 0: {
                    JTables.std_chrominance_qt = JTables.Tbl_000Y;
                    break;
                }
                case 1: {
                    JTables.std_chrominance_qt = JTables.Tbl_014Y;
                    break;
                }
                case 2: {
                    JTables.std_chrominance_qt = JTables.Tbl_029Y;
                    break;
                }
                case 3: {
                    JTables.std_chrominance_qt = JTables.Tbl_043Y;
                    break;
                }
                case 4: {
                    JTables.std_chrominance_qt = JTables.Tbl_057Y;
                    break;
                }
                case 5: {
                    JTables.std_chrominance_qt = JTables.Tbl_071Y;
                    break;
                }
                case 6: {
                    JTables.std_chrominance_qt = JTables.Tbl_086Y;
                    break;
                }
                case 7: {
                    JTables.std_chrominance_qt = JTables.Tbl_100Y;
                }
            }
        } else {
            switch (this.selector) {
                case 0: {
                    JTables.std_chrominance_qt = JTables.Tbl_000UV;
                    break;
                }
                case 1: {
                    JTables.std_chrominance_qt = JTables.Tbl_014UV;
                    break;
                }
                case 2: {
                    JTables.std_chrominance_qt = JTables.Tbl_029UV;
                    break;
                }
                case 3: {
                    JTables.std_chrominance_qt = JTables.Tbl_043UV;
                    break;
                }
                case 4: {
                    JTables.std_chrominance_qt = JTables.Tbl_057UV;
                    break;
                }
                case 5: {
                    JTables.std_chrominance_qt = JTables.Tbl_071UV;
                    break;
                }
                case 6: {
                    JTables.std_chrominance_qt = JTables.Tbl_086UV;
                    break;
                }
                case 7: {
                    JTables.std_chrominance_qt = JTables.Tbl_100UV;
                }
            }
        }
        byArray = this.setQuantizationTable(JTables.std_chrominance_qt, (byte)this.SCALEFACTORUV, byArray);
        for (n = 0; n <= 63; n = (int)((byte)(n + 1))) {
            lArray[n] = this.getShort(byArray[JTables.zigzag[n]]);
        }
        n = 0;
        for (int n2 = 0; n2 <= 7; n2 = (int)((byte)(n2 + 1))) {
            for (int n3 = 0; n3 <= 7; n3 = (int)((byte)(n3 + 1))) {
                int n4 = (int)((float)lArray[n] * (fArray[n2] * fArray[n3]));
                lArray[n] = n4 * 65536;
                n = (byte)(n + 1);
            }
        }
        this.byte_pos += 64;
    }

    void loadPass2LuminanceQuantizationTable(long[] lArray) {
        int n;
        float[] fArray = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
        byte[] byArray = new byte[64];
        switch (this.advance_selector) {
            case 0: {
                JTables.std_luminance_qt = JTables.Tbl_000Y;
                break;
            }
            case 1: {
                JTables.std_luminance_qt = JTables.Tbl_014Y;
                break;
            }
            case 2: {
                JTables.std_luminance_qt = JTables.Tbl_029Y;
                break;
            }
            case 3: {
                JTables.std_luminance_qt = JTables.Tbl_043Y;
                break;
            }
            case 4: {
                JTables.std_luminance_qt = JTables.Tbl_057Y;
                break;
            }
            case 5: {
                JTables.std_luminance_qt = JTables.Tbl_071Y;
                break;
            }
            case 6: {
                JTables.std_luminance_qt = JTables.Tbl_086Y;
                break;
            }
            case 7: {
                JTables.std_luminance_qt = JTables.Tbl_100Y;
            }
        }
        byArray = this.setQuantizationTable(JTables.std_luminance_qt, (byte)this.ADVANCESCALEFACTOR, byArray);
        for (n = 0; n <= 63; n = (int)((byte)(n + 1))) {
            lArray[n] = this.getShort(byArray[JTables.zigzag[n]]);
        }
        n = 0;
        for (int n2 = 0; n2 <= 7; n2 = (int)((byte)(n2 + 1))) {
            for (int n3 = 0; n3 <= 7; n3 = (int)((byte)(n3 + 1))) {
                int n4 = (int)((float)lArray[n] * (fArray[n2] * fArray[n3]));
                lArray[n] = n4 * 65536;
                n = (byte)(n + 1);
            }
        }
        this.byte_pos += 64;
    }

    void loadPass2ChrominanceQuantizationTable(long[] lArray) {
        int n;
        float[] fArray = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
        byte[] byArray = new byte[64];
        if (this.Mapping == 1) {
            switch (this.advance_selector) {
                case 0: {
                    JTables.std_chrominance_qt = JTables.Tbl_000Y;
                    break;
                }
                case 1: {
                    JTables.std_chrominance_qt = JTables.Tbl_014Y;
                    break;
                }
                case 2: {
                    JTables.std_chrominance_qt = JTables.Tbl_029Y;
                    break;
                }
                case 3: {
                    JTables.std_chrominance_qt = JTables.Tbl_043Y;
                    break;
                }
                case 4: {
                    JTables.std_chrominance_qt = JTables.Tbl_057Y;
                    break;
                }
                case 5: {
                    JTables.std_chrominance_qt = JTables.Tbl_071Y;
                    break;
                }
                case 6: {
                    JTables.std_chrominance_qt = JTables.Tbl_086Y;
                    break;
                }
                case 7: {
                    JTables.std_chrominance_qt = JTables.Tbl_100Y;
                }
            }
        } else {
            switch (this.advance_selector) {
                case 0: {
                    JTables.std_chrominance_qt = JTables.Tbl_000UV;
                    break;
                }
                case 1: {
                    JTables.std_chrominance_qt = JTables.Tbl_014UV;
                    break;
                }
                case 2: {
                    JTables.std_chrominance_qt = JTables.Tbl_029UV;
                    break;
                }
                case 3: {
                    JTables.std_chrominance_qt = JTables.Tbl_043UV;
                    break;
                }
                case 4: {
                    JTables.std_chrominance_qt = JTables.Tbl_057UV;
                    break;
                }
                case 5: {
                    JTables.std_chrominance_qt = JTables.Tbl_071UV;
                    break;
                }
                case 6: {
                    JTables.std_chrominance_qt = JTables.Tbl_086UV;
                    break;
                }
                case 7: {
                    JTables.std_chrominance_qt = JTables.Tbl_100UV;
                }
            }
        }
        this.setQuantizationTable(JTables.std_chrominance_qt, (byte)this.ADVANCESCALEFACTORUV, byArray);
        for (n = 0; n <= 63; n = (int)((byte)(n + 1))) {
            lArray[n] = this.getShort(byArray[JTables.zigzag[n]]);
        }
        n = 0;
        for (int n2 = 0; n2 <= 7; n2 = (int)((byte)(n2 + 1))) {
            for (int n3 = 0; n3 <= 7; n3 = (int)((byte)(n3 + 1))) {
                int n4 = (int)((float)lArray[n] * (fArray[n2] * fArray[n3]));
                lArray[n] = n4 * 65536;
                n = (byte)(n + 1);
            }
        }
        this.byte_pos += 64;
    }

    HuffmanTable loadHuffmanTable(HuffmanTable huffmanTable, byte[] byArray, short[] sArray, int[] nArray) {
        byte by;
        byte by2;
        for (by2 = 1; by2 <= 16; by2 = (byte)((byte)(by2 + 1))) {
            huffmanTable.Length[by2] = byArray[by2];
        }
        int n = 0;
        for (by = 1; by <= 16; by = (byte)((byte)(by + 1))) {
            for (by2 = 0; by2 < this.getShort(huffmanTable.Length[by]); by2 = (byte)(by2 + 1)) {
                huffmanTable.V[this.getInt((int)this.WORD_hi_lo((byte)by, (byte)by2))] = sArray[n];
                ++n;
            }
        }
        int n2 = 0;
        for (by = 1; by <= 16; by = (byte)(by + 1)) {
            huffmanTable.minor_code[by] = (short)n2;
            for (by2 = 1; by2 <= this.getShort(huffmanTable.Length[by]); by2 = (byte)(by2 + 1)) {
                ++n2;
            }
            huffmanTable.major_code[by] = (short)(n2 - 1);
            n2 *= 2;
            if (this.getShort(huffmanTable.Length[by]) != 0) continue;
            huffmanTable.minor_code[by] = -1;
            huffmanTable.major_code[by] = 0;
        }
        huffmanTable.Len[0] = 2;
        n = 2;
        for (int i = 1; i < 65535; ++i) {
            huffmanTable.Len[i] = i < nArray[n] ? (byte)(nArray[n + 1] & 0xFF) : (byte)(nArray[(n += 2) + 1] & 0xFF);
        }
        return huffmanTable;
    }

    HuffmanTable loadHuffmanTableYDC(HuffmanTable huffmanTable) {
        byte by;
        byte by2;
        for (by2 = 1; by2 <= 16; by2 = (byte)((byte)(by2 + 1))) {
            huffmanTable.Length[by2] = JTables.std_dc_luminance_nrcodes[by2];
        }
        int n = 0;
        for (by = 1; by <= 16; by = (byte)((byte)(by + 1))) {
            for (by2 = 0; by2 < this.getShort(huffmanTable.Length[by]); by2 = (byte)(by2 + 1)) {
                huffmanTable.V[this.getInt((int)this.WORD_hi_lo((byte)by, (byte)by2))] = JTables.std_dc_luminance_values[n];
                n = (byte)(n + 1);
            }
        }
        short s = 0;
        for (by = 1; by <= 16; by = (byte)(by + 1)) {
            huffmanTable.minor_code[by] = s;
            for (by2 = 1; by2 <= this.getShort(huffmanTable.Length[by]); by2 = (byte)(by2 + 1)) {
                s = (short)(s + 1);
            }
            huffmanTable.major_code[by] = (short)(s - 1);
            s = (short)(s * 2);
            if (this.getShort(huffmanTable.Length[by]) != 0) continue;
            huffmanTable.minor_code[by] = -1;
            huffmanTable.major_code[by] = 0;
        }
        return huffmanTable;
    }

    HuffmanTable loadHuffmanTableYAC(HuffmanTable huffmanTable) {
        byte by;
        byte by2;
        for (by2 = 1; by2 <= 16; by2 = (byte)((byte)(by2 + 1))) {
            huffmanTable.Length[by2] = JTables.std_ac_luminance_nrcodes[by2];
        }
        int n = 0;
        for (by = 1; by <= 16; by = (byte)((byte)(by + 1))) {
            for (by2 = 0; by2 < this.getShort(huffmanTable.Length[by]); by2 = (byte)(by2 + 1)) {
                huffmanTable.V[this.getInt((int)this.WORD_hi_lo((byte)by, (byte)by2))] = JTables.std_ac_luminance_values[n];
                n = (byte)(n + 1);
            }
        }
        short s = 0;
        for (by = 1; by <= 16; by = (byte)(by + 1)) {
            huffmanTable.minor_code[by] = s;
            for (by2 = 1; by2 <= this.getShort(huffmanTable.Length[by]); by2 = (byte)(by2 + 1)) {
                s = (short)(s + 1);
            }
            huffmanTable.major_code[by] = (short)(s - 1);
            s = (short)(s * 2);
            if (this.getShort(huffmanTable.Length[by]) != 0) continue;
            huffmanTable.minor_code[by] = -1;
            huffmanTable.major_code[by] = 0;
        }
        return huffmanTable;
    }

    void decodeHuffmanDataUnit(byte by, byte by2, short[] sArray, short s) {
        byte by3 = 0;
        byte by4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        byte by5 = 0;
        Arrays.fill(this.m_DCT_coeff, 0);
        this.min_code = this.m_HTDC[by].minor_code;
        this.huff_values = this.m_HTDC[by].V;
        byte by6 = 0;
        byte by7 = this.m_HTDC[by].Len[this.m_RecvBuffer[0] >> 16 & 0xFFFF];
        short s2 = this.lookKbits(by7);
        this.skipKbits(by7);
        by3 = (byte)this.huff_values[this.WORD_hi_lo(by7, (byte)(s2 - this.min_code[by7]))];
        if (by3 == 0) {
            this.m_DCT_coeff[s + 0] = sArray[0];
        } else {
            int n;
            this.m_DCT_coeff[s] = n = sArray[0] + this.getKbits(by3);
            sArray[0] = (short)this.m_DCT_coeff[s];
        }
        this.min_code = this.m_HTAC[by2].minor_code;
        this.huff_values = this.m_HTAC[by2].V;
        by6 = 1;
        do {
            by7 = this.m_HTAC[by2].Len[this.m_RecvBuffer[0] >> 16 & 0xFFFF];
            s2 = this.lookKbits(by7);
            this.skipKbits(by7);
            by5 = (byte)this.huff_values[this.WORD_hi_lo(by7, (byte)(s2 - this.min_code[by7]))];
            by3 = (byte)(by5 & 0xF);
            by4 = (byte)(by5 >> 4 & 0xF);
            if (by3 == 0) {
                if (by4 != 15) break;
                by6 = (byte)(by6 + 16);
                continue;
            }
            by6 = (byte)(by6 + by4);
            this.m_DCT_coeff[s + JTables.dezigzag[by6]] = this.getKbits(by3);
            by6 = (byte)(by6 + 1);
        } while (by6 < 64);
    }

    final void precalculateCrCbTables() {
        int n;
        for (n = 0; n <= 255; n = (int)((short)(n + 1))) {
            this.m_Cr_tab[n] = (short)(((double)n - 128.0) * 1.402);
        }
        for (n = 0; n <= 255; n = (int)((short)(n + 1))) {
            this.m_Cb_tab[n] = (short)(((double)n - 128.0) * 1.772);
        }
        for (n = 0; n <= 255; n = (int)((short)(n + 1))) {
            for (int n2 = 0; n2 <= 255; n2 = (int)((short)(n2 + 1))) {
                this.m_Cr_Cb_green_tab[(n << 8) + n2] = (short)(-0.34414 * ((double)n2 - 128.0) - 0.71414 * ((double)n - 128.0));
            }
        }
    }

    void calculateTabs() {
        int n;
        int n2;
        byte[] byArray = new byte[256];
        for (n2 = 0; n2 < 16; n2 = (int)((byte)(n2 + 1))) {
            for (n = 0; n < 16; n = (int)((byte)(n + 1))) {
                byArray[n2 * 16 + n] = (byte)(n2 / this.YV * 8 + n / this.YH);
            }
        }
        for (n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
            for (n = 0; n < 8; n = (int)((byte)(n + 1))) {
                this.tab_1[n2 * 8 + n] = byArray[n2 * 16 + n];
            }
            for (n = 8; n < 16; n = (int)((byte)(n + 1))) {
                this.tab_2[n2 * 8 + (n - 8)] = byArray[n2 * 16 + n];
            }
        }
        for (n2 = 8; n2 < 16; n2 = (int)((byte)(n2 + 1))) {
            for (n = 0; n < 8; n = (int)((byte)(n + 1))) {
                this.tab_3[(n2 - 8) * 8 + n] = byArray[n2 * 16 + n];
            }
            for (n = 8; n < 16; n = (int)((byte)(n + 1))) {
                this.tab_4[(n2 - 8) * 8 + (n - 8)] = byArray[n2 * 16 + n];
            }
        }
    }

    public void initHuffmanTable() {
        this.m_HTDC[0] = this.loadHuffmanTable(this.m_HTDC[0], JTables.std_dc_luminance_nrcodes, JTables.std_dc_luminance_values, JTables.DC_LUMINANCE_HUFFMANCODE);
        this.m_HTAC[0] = this.loadHuffmanTable(this.m_HTAC[0], JTables.std_ac_luminance_nrcodes, JTables.std_ac_luminance_values, JTables.AC_LUMINANCE_HUFFMANCODE);
        this.m_HTDC[1] = this.loadHuffmanTable(this.m_HTDC[1], JTables.std_dc_chrominance_nrcodes, JTables.std_dc_chrominance_values, JTables.DC_CHROMINANCE_HUFFMANCODE);
        this.m_HTAC[1] = this.loadHuffmanTable(this.m_HTAC[1], JTables.std_ac_chrominance_nrcodes, JTables.std_ac_chrominance_values, JTables.AC_CHROMINANCE_HUFFMANCODE);
    }

    final int FIX_G(double d) {
        return (int)(d * 65536.0 + 0.5);
    }

    void initColorTable() {
        int n = 65536;
        int n2 = n >> 1;
        int n3 = 0;
        int n4 = -128;
        while (n3 < 256) {
            this.calculatedRGBofCrToR[n3] = this.FIX_G(1.597656) * n4 + n2 >> 16;
            this.calculatedRGBofCbToB[n3] = this.FIX_G(2.015625) * n4 + n2 >> 16;
            this.calculatedRGBofCrToG[n3] = -this.FIX_G(0.8125) * n4 + n2 >> 16;
            this.calculatedRGBofCbToG[n3] = -this.FIX_G(0.390625) * n4 + n2 >> 16;
            ++n3;
            ++n4;
        }
        n3 = 0;
        n4 = -16;
        while (n3 < 256) {
            this.calculatedRGBofY[n3] = this.FIX_G(1.164) * n4 + n2 >> 16;
            ++n3;
            ++n4;
        }
    }

    void resync() {
        this.byte_pos += 2;
        this.byte_p(this.byte_pos);
        if (this.getShort(this.bp) == 255) {
            ++this.byte_pos;
        }
        this.w1 = this.WORD_hi_lo(this.bp, (byte)0);
        this.byte_p(this.byte_pos);
        if (this.getShort(this.bp) == 255) {
            ++this.byte_pos;
        }
        this.w1 = (short)(this.w1 + this.getShort(this.bp));
        this.byte_p(this.byte_pos);
        if (this.getShort(this.bp) == 255) {
            ++this.byte_pos;
        }
        this.w2 = this.WORD_hi_lo(this.bp, (byte)0);
        this.byte_p(this.byte_pos);
        if (this.getShort(this.bp) == 255) {
            ++this.byte_pos;
        }
        this.w2 = (short)(this.w2 + this.getShort(this.bp));
        this.wordval = this.getInt(this.w1);
        this.d_k = 0;
        Decoder.m_DCY[0] = 0;
        Decoder.DCCb[0] = 0;
        Decoder.DCCr[0] = 0;
    }

    final byte byte_p(int n) {
        return this.buf[n++];
    }

    final int MULTIPLY(int n, int n2) {
        return n * n2 >> 8;
    }

    void inverseDCT(int n, byte by) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        n22 = n;
        for (n19 = 8; n19 > 0; --n19) {
            if ((this.m_DCT_coeff[n22 + 8] | this.m_DCT_coeff[n22 + 16] | this.m_DCT_coeff[n22 + 24] | this.m_DCT_coeff[n22 + 32] | this.m_DCT_coeff[n22 + 40] | this.m_DCT_coeff[n22 + 48] | this.m_DCT_coeff[n22 + 56]) == 0) {
                int n23;
                this.workspace[n21 + 0] = n23 = (int)((long)this.m_DCT_coeff[n22 + 0] * this.m_QT[by][n20 + 0]) >> 16;
                this.workspace[n21 + 8] = n23;
                this.workspace[n21 + 16] = n23;
                this.workspace[n21 + 24] = n23;
                this.workspace[n21 + 32] = n23;
                this.workspace[n21 + 40] = n23;
                this.workspace[n21 + 48] = n23;
                this.workspace[n21 + 56] = n23;
                ++n22;
                ++n20;
                ++n21;
                ++this.nZeroACTerms;
                continue;
            }
            n18 = (int)((long)this.m_DCT_coeff[n22 + 0] * this.m_QT[by][n20 + 0]) >> 16;
            n17 = (int)((long)this.m_DCT_coeff[n22 + 16] * this.m_QT[by][n20 + 16]) >> 16;
            n16 = (int)((long)this.m_DCT_coeff[n22 + 32] * this.m_QT[by][n20 + 32]) >> 16;
            n15 = (int)((long)this.m_DCT_coeff[n22 + 48] * this.m_QT[by][n20 + 48]) >> 16;
            n14 = n18 + n16;
            n13 = n18 - n16;
            n12 = n17 + n15;
            n11 = this.MULTIPLY(n17 - n15, 362) - n12;
            n18 = n14 + n12;
            n15 = n14 - n12;
            n17 = n13 + n11;
            n16 = n13 - n11;
            n10 = (int)((long)this.m_DCT_coeff[n22 + 8] * this.m_QT[by][n20 + 8]) >> 16;
            n9 = (int)((long)this.m_DCT_coeff[n22 + 24] * this.m_QT[by][n20 + 24]) >> 16;
            n8 = (int)((long)this.m_DCT_coeff[n22 + 40] * this.m_QT[by][n20 + 40]) >> 16;
            n7 = (int)((long)this.m_DCT_coeff[n22 + 56] * this.m_QT[by][n20 + 56]) >> 16;
            n6 = n8 + n9;
            n5 = n8 - n9;
            n4 = n10 + n7;
            n3 = n10 - n7;
            n7 = n4 + n6;
            n13 = this.MULTIPLY(n4 - n6, 362);
            n2 = this.MULTIPLY(n5 + n3, 473);
            n14 = this.MULTIPLY(n3, 277) - n2;
            n11 = this.MULTIPLY(n5, -669) + n2;
            n8 = n11 - n7;
            n9 = n13 - n8;
            n10 = n14 + n9;
            this.workspace[n21 + 0] = n18 + n7;
            this.workspace[n21 + 56] = n18 - n7;
            this.workspace[n21 + 8] = n17 + n8;
            this.workspace[n21 + 48] = n17 - n8;
            this.workspace[n21 + 16] = n16 + n9;
            this.workspace[n21 + 40] = n16 - n9;
            this.workspace[n21 + 32] = n15 + n10;
            this.workspace[n21 + 24] = n15 - n10;
            ++n22;
            ++n20;
            ++n21;
        }
        n21 = 0;
        int n24 = 0;
        int n25 = 0;
        for (n19 = 0; n19 < 8; ++n19) {
            n24 = n + n19 * 8;
            n14 = this.workspace[n21 + 0] + this.workspace[n21 + 4];
            n13 = this.workspace[n21 + 0] - this.workspace[n21 + 4];
            n12 = this.workspace[n21 + 2] + this.workspace[n21 + 6];
            n11 = this.MULTIPLY(this.workspace[n21 + 2] - this.workspace[n21 + 6], 362) - n12;
            n18 = n14 + n12;
            n15 = n14 - n12;
            n17 = n13 + n11;
            n16 = n13 - n11;
            n6 = this.workspace[n21 + 5] + this.workspace[n21 + 3];
            n5 = this.workspace[n21 + 5] - this.workspace[n21 + 3];
            n4 = this.workspace[n21 + 1] + this.workspace[n21 + 7];
            n3 = this.workspace[n21 + 1] - this.workspace[n21 + 7];
            n7 = n4 + n6;
            n13 = this.MULTIPLY(n4 - n6, 362);
            n2 = this.MULTIPLY(n5 + n3, 473);
            n14 = this.MULTIPLY(n3, 277) - n2;
            n11 = this.MULTIPLY(n5, -669) + n2;
            n8 = n11 - n7;
            n9 = n13 - n8;
            n10 = n14 + n9;
            n25 = 0;
            n25 = 128 + (n18 + n7 >> 3 & 0x3FF);
            this.YUVTile[n24 + 0] = this.rangeLimitTableShort[n25 + 256];
            n25 = 128 + (n18 - n7 >> 3 & 0x3FF);
            this.YUVTile[n24 + 7] = this.rangeLimitTableShort[n25 + 256];
            n25 = 128 + (n17 + n8 >> 3 & 0x3FF);
            this.YUVTile[n24 + 1] = this.rangeLimitTableShort[n25 + 256];
            n25 = 128 + (n17 - n8 >> 3 & 0x3FF);
            this.YUVTile[n24 + 6] = this.rangeLimitTableShort[n25 + 256];
            n25 = 128 + (n16 + n9 >> 3 & 0x3FF);
            this.YUVTile[n24 + 2] = this.rangeLimitTableShort[n25 + 256];
            n25 = 128 + (n16 - n9 >> 3 & 0x3FF);
            this.YUVTile[n24 + 5] = this.rangeLimitTableShort[n25 + 256];
            n25 = 128 + (n15 + n10 >> 3 & 0x3FF);
            this.YUVTile[n24 + 4] = this.rangeLimitTableShort[n25 + 256];
            n25 = 128 + (n15 - n10 >> 3 & 0x3FF);
            this.YUVTile[n24 + 3] = this.rangeLimitTableShort[n25 + 256];
            n21 += 8;
        }
    }

    final void updateReadBuf(int n) {
        if (m_newbits - n <= 0) {
            this.uprdbuf_readbuf = this.getLong(this.m_RecvBuffer[SOCIVTPPktHdr.VIRTADD + this._index]);
            ++this._index;
            this.m_RecvBuffer[0] = (int)(this.getLong(this.m_RecvBuffer[0]) << n) | (int)((this.getLong(this.m_RecvBuffer[1]) | this.uprdbuf_readbuf >> m_newbits) >> 32 - n);
            this.m_RecvBuffer[1] = (int)(this.uprdbuf_readbuf << n - m_newbits);
            m_newbits = 32 + m_newbits - n;
        } else {
            this.m_RecvBuffer[0] = (int)(this.getLong(this.m_RecvBuffer[0]) << n) | (int)(this.getLong(this.m_RecvBuffer[1]) >> 32 - n);
            this.m_RecvBuffer[1] = (int)(this.getLong(this.m_RecvBuffer[1]) << n);
            m_newbits -= n;
        }
    }

    void convertYUVtoRGB(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 8;
        if (this.m_Mode420 == 0) {
            int n8;
            this.YValueInTile = this.YUVTile;
            for (n8 = 0; n8 < 64; ++n8) {
                this.CbValueInTile[n8] = this.YUVTile[64 + n8];
                this.CrValueInTile[n8] = this.YUVTile[128 + n8];
            }
            int n9 = n * 8;
            int n10 = n2 * 8;
            int n11 = n10 * this.RealWIDTH + n9;
            n7 = this.RealWIDTH - n9;
            if (n7 == 0 || n7 > 8) {
                n7 = 8;
            }
            for (int i = 0; i < 8; ++i) {
                for (n8 = 0; n8 < n7; ++n8) {
                    int n12 = (i << 3) + n8;
                    int n13 = (n11 + n8) * 3;
                    int n14 = this.YValueInTile[n12];
                    int n15 = this.CbValueInTile[n12];
                    int n16 = this.CrValueInTile[n12];
                    this.previousYUVData[n13] = n14;
                    this.previousYUVData[n13 + 1] = n15;
                    this.previousYUVData[n13 + 2] = n16;
                    n4 = this.calculatedRGBofY[n14] + this.calculatedRGBofCbToB[n15];
                    n5 = this.calculatedRGBofY[n14] + (this.calculatedRGBofCbToG[n15] + this.calculatedRGBofCrToG[n16]);
                    n6 = this.calculatedRGBofY[n14] + this.calculatedRGBofCrToR[n16];
                    n4 = n4 >= 0 ? (n4 += 256) : 0;
                    n5 = n5 >= 0 ? (n5 += 256) : 0;
                    n6 = n6 >= 0 ? (n6 += 256) : 0;
                    if (n13 >= this.RealWIDTH * this.RealHEIGHT * 3) continue;
                    this.m_decodeBuf[n13] = this.rangeLimitTable[n4];
                    this.m_decodeBuf[n13 + 1] = this.rangeLimitTable[n5];
                    this.m_decodeBuf[n13 + 2] = this.rangeLimitTable[n6];
                    this.m_socvidClnt.SetPointInSavedScreen(n9 + n8, n10 + i, this.m_decodeBuf[n13], this.m_decodeBuf[n13 + 1], this.m_decodeBuf[n13 + 2]);
                }
                n11 += this.RealWIDTH;
            }
        } else {
            int n17;
            int n18;
            n3 = 0;
            for (n18 = 0; n18 < 4; ++n18) {
                for (n17 = 0; n17 < 64; ++n17) {
                    this.YValueInTile420[n18][n17] = this.YUVTile[n3];
                    ++n3;
                }
            }
            for (n17 = 0; n17 < 64; ++n17) {
                this.CbValueInTile[n17] = this.YUVTile[n3];
                this.CrValueInTile[n17] = this.YUVTile[n3 + 64];
                ++n3;
            }
            int n19 = n * 16;
            int n20 = n2 * 16;
            int n21 = n20 * this.WIDTH + n19;
            int n22 = 0;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 0;
            int n27 = 0;
            int n28 = 0;
            int n29 = 0;
            int n30 = 16;
            if (this.HEIGHT == 608 && n2 == 37) {
                n30 = 8;
            }
            for (n17 = 0; n17 < n30; ++n17) {
                n28 = (n17 >> 3) * 2;
                n29 = n17 >> 1 << 3;
                for (n18 = 0; n18 < 16; ++n18) {
                    n27 = n28 + (n18 >> 3);
                    switch (n27) {
                        case 0: {
                            n22 = n23++;
                            break;
                        }
                        case 1: {
                            n22 = n24++;
                            break;
                        }
                        case 2: {
                            n22 = n25++;
                            break;
                        }
                        default: {
                            n22 = n26++;
                        }
                    }
                    int n31 = (n21 + n18) * 3;
                    int n32 = n29 + (n18 >> 1);
                    int n33 = this.YValueInTile420[n27][n22];
                    int n34 = this.CbValueInTile[n32];
                    int n35 = this.CrValueInTile[n32];
                    n4 = this.calculatedRGBofY[n33] + this.calculatedRGBofCbToB[n34];
                    n5 = this.calculatedRGBofY[n33] + (this.calculatedRGBofCbToG[n34] + this.calculatedRGBofCrToG[n35]);
                    n6 = this.calculatedRGBofY[n33] + this.calculatedRGBofCrToR[n35];
                    this.m_decodeBuf[n31] = n4 >= 0 ? this.rangeLimitTable[n4 + 256] : (byte)0;
                    this.m_decodeBuf[n31 + 1] = n5 >= 0 ? this.rangeLimitTable[n5 + 256] : (byte)0;
                    this.m_decodeBuf[n31 + 2] = n6 >= 0 ? this.rangeLimitTable[n6 + 256] : (byte)0;
                    this.m_socvidClnt.SetPointInSavedScreen(n19 + n18, n20 + n17, this.m_decodeBuf[n31], this.m_decodeBuf[n31 + 1], this.m_decodeBuf[n31 + 2]);
                }
                n21 += this.RealWIDTH;
            }
        }
    }

    void convertYUVToRGBPass2(int n, int n2) {
        int n3 = 8;
        if (this.m_Mode420 == 0) {
            int n4;
            this.YValueInTile = this.YUVTile;
            for (n4 = 0; n4 < 64; ++n4) {
                this.CbValueInTile[n4] = this.YUVTile[64 + n4];
                this.CrValueInTile[n4] = this.YUVTile[128 + n4];
            }
            int n5 = n * 8;
            int n6 = n2 * 8;
            int n7 = n6 * this.RealWIDTH + n5;
            n3 = this.RealWIDTH - n5;
            if (n3 == 0 || n3 > 8) {
                n3 = 8;
            }
            for (int i = 0; i < 8; ++i) {
                for (n4 = 0; n4 < n3; ++n4) {
                    int n8 = (i << 3) + n4;
                    int n9 = (n7 + n4) * 3;
                    int n10 = this.previousYUVData[n9] + (this.YValueInTile[n8] - 128);
                    int n11 = this.previousYUVData[n9 + 1] + (this.CbValueInTile[n8] - 128);
                    int n12 = this.previousYUVData[n9 + 2] + (this.CrValueInTile[n8] - 128);
                    if (n10 < 0) {
                        n10 = 0;
                    }
                    if (n10 > 255) {
                        n10 = 255;
                    }
                    if (n11 < 0) {
                        n11 = 0;
                    }
                    if (n11 > 255) {
                        n11 = 255;
                    }
                    if (n12 < 0) {
                        n12 = 0;
                    }
                    if (n12 > 255) {
                        n12 = 255;
                    }
                    int n13 = this.calculatedRGBofY[n10] + this.calculatedRGBofCbToB[n11];
                    int n14 = this.calculatedRGBofY[n10] + (this.calculatedRGBofCbToG[n11] + this.calculatedRGBofCrToG[n12]);
                    int n15 = this.calculatedRGBofY[n10] + this.calculatedRGBofCrToR[n12];
                    n13 = n13 >= 0 ? (n13 += 256) : 0;
                    n14 = n14 >= 0 ? (n14 += 256) : 0;
                    n15 = n15 >= 0 ? (n15 += 256) : 0;
                    if (n9 >= this.RealWIDTH * this.RealHEIGHT * 3) continue;
                    this.m_decodeBuf[n9] = this.rangeLimitTable[n13];
                    this.m_decodeBuf[n9 + 1] = this.rangeLimitTable[n14];
                    this.m_decodeBuf[n9 + 2] = this.rangeLimitTable[n15];
                    this.m_socvidClnt.SetPointInSavedScreen(n5 + n4, n6 + i, this.m_decodeBuf[n9], this.m_decodeBuf[n9 + 1], this.m_decodeBuf[n9 + 2]);
                }
                n7 += this.RealWIDTH;
            }
        } else {
            System.out.println("Receive Pass 2 data in YUV420 mode");
        }
    }

    final void decompressJPEG(int n, int n2, byte by) {
        this.decodeHuffmanDataUnit(this.m_YDC_nr, this.m_YAC_nr, m_DCY, (short)0);
        this.inverseDCT(0, by);
        if (this.m_Mode420 == 1) {
            this.decodeHuffmanDataUnit(this.m_YDC_nr, this.m_YAC_nr, m_DCY, (short)64);
            this.inverseDCT(64, by);
            this.decodeHuffmanDataUnit(this.m_YDC_nr, this.m_YAC_nr, m_DCY, (short)128);
            this.inverseDCT(128, by);
            if (SOCIVTPPktHdr.gTxb == 0 && SOCIVTPPktHdr.gTyb == 1) {
                SOCIVTPPktHdr.gCheck = 100;
            }
            this.decodeHuffmanDataUnit(this.m_YDC_nr, this.m_YAC_nr, m_DCY, (short)192);
            this.inverseDCT(192, by);
            if (SOCIVTPPktHdr.gTxb == 0 && SOCIVTPPktHdr.gTyb == 1) {
                SOCIVTPPktHdr.gCheck = 101;
            }
            this.decodeHuffmanDataUnit(this.m_CbDC_nr, this.m_CbAC_nr, DCCb, (short)256);
            this.inverseDCT(256, (byte)(by + 1));
            this.decodeHuffmanDataUnit(this.m_CrDC_nr, this.m_CrAC_nr, DCCr, (short)320);
            this.inverseDCT(320, (byte)(by + 1));
        } else {
            this.decodeHuffmanDataUnit(this.m_CbDC_nr, this.m_CbAC_nr, DCCb, (short)64);
            this.inverseDCT(64, (byte)(by + 1));
            this.decodeHuffmanDataUnit(this.m_CrDC_nr, this.m_CrAC_nr, DCCr, (short)128);
            this.inverseDCT(128, (byte)(by + 1));
        }
        this.convertYUVtoRGB(n, n2);
    }

    void decompressJPEGPass2(int n, int n2, byte by) {
        this.decodeHuffmanDataUnit(this.m_YDC_nr, this.m_YAC_nr, m_DCY, (short)0);
        this.inverseDCT(0, by);
        this.decodeHuffmanDataUnit(this.m_CbDC_nr, this.m_CbAC_nr, DCCb, (short)64);
        this.inverseDCT(64, (byte)(by + 1));
        this.decodeHuffmanDataUnit(this.m_CrDC_nr, this.m_CrAC_nr, DCCr, (short)128);
        this.inverseDCT(128, (byte)(by + 1));
        this.convertYUVToRGBPass2(n, n2);
    }

    void decompressVQ(int n, int n2, byte by) {
        short s = 0;
        int n3 = 0;
        if (this.m_VQ.BitMapBits == 0) {
            for (int i = 0; i < 64; ++i) {
                this.YUVTile[n3 + 0] = (char)((this.m_VQ.Color[this.m_VQ.Index[0]] & 0xFF0000L) >> 16);
                this.YUVTile[n3 + 64] = (char)((this.m_VQ.Color[this.m_VQ.Index[0]] & 0xFF00L) >> 8);
                this.YUVTile[n3 + 128] = (char)(this.m_VQ.Color[this.m_VQ.Index[0]] & 0xFFL);
                ++n3;
            }
        } else {
            for (int i = 0; i < 64; ++i) {
                s = this.lookKbits(this.m_VQ.BitMapBits);
                this.YUVTile[n3 + 0] = (char)((this.m_VQ.Color[this.m_VQ.Index[s]] & 0xFF0000L) >> 16);
                this.YUVTile[n3 + 64] = (char)((this.m_VQ.Color[this.m_VQ.Index[s]] & 0xFF00L) >> 8);
                this.YUVTile[n3 + 128] = (char)(this.m_VQ.Color[this.m_VQ.Index[s]] & 0xFFL);
                ++n3;
                this.skipKbits(this.m_VQ.BitMapBits);
            }
        }
        this.convertYUVtoRGB(n, n2);
    }

    final void moveBlockIndex() {
        ++this.txb;
        if (this.txb == this.tmp_WIDTHBy16) {
            this.m_view.repaint((this.txb - 1) * 16, this.tyb * 16, 16, 16);
        }
        if (this.m_Mode420 == 0) {
            if (this.txb >= this.tmp_WIDTHBy16 / 8) {
                ++this.tyb;
                if (this.tyb >= this.tmp_HEIGHTBy16 / 8) {
                    this.tyb = 0;
                }
                this.txb = 0;
            }
        } else if (this.txb >= this.tmp_WIDTHBy16 / 16) {
            ++this.tyb;
            if (this.tyb >= this.tmp_HEIGHTBy16 / 16) {
                this.tyb = 0;
            }
            this.txb = 0;
        }
        SOCIVTPPktHdr.gTxb = this.txb;
        SOCIVTPPktHdr.gTyb = this.tyb;
        this.pixels += 256L;
    }

    public void decode(VideoEngineInfo videoEngineInfo, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            for (n4 = 0; n4 < 4; ++n4) {
                this.m_VQ.Index[n4] = (char)n4;
            }
            this.m_VQ.Color[0] = 32896L;
            this.m_VQ.Color[1] = 0xFF8080L;
            this.m_VQ.Color[2] = 0x808080L;
            this.m_VQ.Color[3] = 0xC08080L;
            this.WIDTH = videoEngineInfo.SourceModeInfo.X;
            this.HEIGHT = videoEngineInfo.SourceModeInfo.Y;
            this.RealWIDTH = videoEngineInfo.SourceModeInfo.X;
            this.RealHEIGHT = videoEngineInfo.SourceModeInfo.Y;
            this.m_Mode420 = videoEngineInfo.FrameHeader.Mode420;
            if (this.m_Mode420 == 1) {
                if (this.WIDTH % 16 != 0) {
                    this.WIDTH = this.WIDTH + 16 - this.WIDTH % 16;
                }
                if (this.HEIGHT % 16 != 0) {
                    this.HEIGHT = this.HEIGHT + 16 - this.HEIGHT % 16;
                }
            } else {
                if (this.WIDTH % 8 != 0) {
                    this.WIDTH = this.WIDTH + 8 - this.WIDTH % 8;
                }
                if (this.HEIGHT % 8 != 0) {
                    this.HEIGHT = this.HEIGHT + 8 - this.HEIGHT % 8;
                }
            }
            this.tmp_WIDTHBy16 = videoEngineInfo.DestinationModeInfo.X;
            this.tmp_HEIGHTBy16 = videoEngineInfo.DestinationModeInfo.Y;
            if (this.m_Mode420 == 1) {
                if (this.tmp_WIDTHBy16 % 16 != 0) {
                    this.tmp_WIDTHBy16 = this.tmp_WIDTHBy16 + 16 - this.tmp_WIDTHBy16 % 16;
                }
                if (this.tmp_HEIGHTBy16 % 16 != 0) {
                    this.tmp_HEIGHTBy16 = this.tmp_HEIGHTBy16 + 16 - this.tmp_HEIGHTBy16 % 16;
                }
            } else {
                if (this.tmp_WIDTHBy16 % 8 != 0) {
                    this.tmp_WIDTHBy16 = this.tmp_WIDTHBy16 + 8 - this.tmp_WIDTHBy16 % 8;
                }
                if (this.tmp_HEIGHTBy16 % 8 != 0) {
                    this.tmp_HEIGHTBy16 = this.tmp_HEIGHTBy16 + 8 - this.tmp_HEIGHTBy16 % 8;
                }
            }
            n2 = videoEngineInfo.CompressData.CompressSize / 4;
            if (videoEngineInfo.FrameHeader.RC4Enable == 1) {
                if (!this.DecodeRC4State) {
                    this.Keys_Expansion(this.DecodeKeys);
                    this.DecodeRC4_setup(this.DecodeKeys, videoEngineInfo);
                }
                this.RC4_crypt(this.m_RecvBuffer, (int)(this.getLong(n2) * 4L));
            }
            this.yheader.qfactor = videoEngineInfo.FrameHeader.JPEGScaleFactor;
            this.yheader.height = videoEngineInfo.DestinationModeInfo.Y;
            this.yheader.width = videoEngineInfo.DestinationModeInfo.X;
            n = videoEngineInfo.FrameHeader.NumberOfMB;
            this.SCALEFACTOR = 16;
            this.SCALEFACTORUV = 16;
            this.ADVANCESCALEFACTOR = 16;
            this.ADVANCESCALEFACTORUV = 16;
            this.selector = videoEngineInfo.FrameHeader.JPEGTableSelector;
            this.advance_selector = videoEngineInfo.FrameHeader.AdvanceTableSelector;
            this.Mapping = videoEngineInfo.FrameHeader.JPEGYUVTableMapping;
            this.byte_pos = 0;
            this.loadLuminanceQuantizationTable(this.m_QT[0]);
            this.loadChrominanceQuantizationTable(this.m_QT[1]);
            this.loadPass2LuminanceQuantizationTable(this.m_QT[2]);
            this.loadPass2ChrominanceQuantizationTable(this.m_QT[3]);
            this.m_RecvBuffer = nArray;
            this._index = 2;
            this.tyb = 0;
            this.txb = 0;
            m_newbits = 32;
            Decoder.DCCr[0] = 0;
            Decoder.DCCb[0] = 0;
            Decoder.m_DCY[0] = 0;
            do {
                if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 0L) {
                    this.updateReadBuf(4);
                    this.decompressJPEG(this.txb, this.tyb, (byte)0);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 8L) {
                    this.txb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF00000L) >> 20);
                    this.tyb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF000L) >> 12);
                    this.updateReadBuf(20);
                    this.decompressJPEG(this.txb, this.tyb, (byte)0);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 2L) {
                    this.updateReadBuf(4);
                    this.decompressJPEGPass2(this.txb, this.tyb, (byte)2);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 10L) {
                    this.txb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF00000L) >> 20);
                    this.tyb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF000L) >> 12);
                    this.updateReadBuf(20);
                    this.decompressJPEGPass2(this.txb, this.tyb, (byte)2);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 5L) {
                    this.updateReadBuf(4);
                    this.m_VQ.BitMapBits = 0;
                    for (n4 = 0; n4 < 1; ++n4) {
                        this.m_VQ.Index[n4] = (char)(this.getLong(this.m_RecvBuffer[0]) >> 29 & 3L);
                        if ((this.getLong(this.m_RecvBuffer[0]) >> 31 & 1L) == 0L) {
                            this.updateReadBuf(3);
                            continue;
                        }
                        this.m_VQ.Color[this.m_VQ.Index[n4]] = this.getLong(this.m_RecvBuffer[0]) >> 5 & 0xFFFFFFL;
                        this.updateReadBuf(27);
                    }
                    this.decompressVQ(this.txb, this.tyb, (byte)0);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 13L) {
                    this.txb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF00000L) >> 20);
                    this.tyb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF000L) >> 12);
                    this.updateReadBuf(20);
                    this.m_VQ.BitMapBits = 0;
                    for (n4 = 0; n4 < 1; ++n4) {
                        this.m_VQ.Index[n4] = (char)(this.getLong(this.m_RecvBuffer[0]) >> 29 & 3L);
                        if ((this.getLong(this.m_RecvBuffer[0]) >> 31 & 1L) == 0L) {
                            this.updateReadBuf(3);
                            continue;
                        }
                        this.m_VQ.Color[this.m_VQ.Index[n4]] = this.getLong(this.m_RecvBuffer[0]) >> 5 & 0xFFFFFFL;
                        this.updateReadBuf(27);
                    }
                    this.decompressVQ(this.txb, this.tyb, (byte)0);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 6L) {
                    this.updateReadBuf(4);
                    this.m_VQ.BitMapBits = 1;
                    for (n4 = 0; n4 < 2; ++n4) {
                        this.m_VQ.Index[n4] = (char)(this.getLong(this.m_RecvBuffer[0]) >> 29 & 3L);
                        if ((this.getLong(this.m_RecvBuffer[0]) >> 31 & 1L) == 0L) {
                            this.updateReadBuf(3);
                            continue;
                        }
                        this.m_VQ.Color[this.m_VQ.Index[n4]] = this.getLong(this.m_RecvBuffer[0]) >> 5 & 0xFFFFFFL;
                        this.updateReadBuf(27);
                    }
                    this.decompressVQ(this.txb, this.tyb, (byte)0);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 14L) {
                    this.txb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF00000L) >> 20);
                    this.tyb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF000L) >> 12);
                    this.updateReadBuf(20);
                    this.m_VQ.BitMapBits = 1;
                    for (n4 = 0; n4 < 2; ++n4) {
                        this.m_VQ.Index[n4] = (char)(this.getLong(this.m_RecvBuffer[0]) >> 29 & 3L);
                        if ((this.getLong(this.m_RecvBuffer[0]) >> 31 & 1L) == 0L) {
                            this.updateReadBuf(3);
                            continue;
                        }
                        this.m_VQ.Color[this.m_VQ.Index[n4]] = this.getLong(this.m_RecvBuffer[0]) >> 5 & 0xFFFFFFL;
                        this.updateReadBuf(27);
                    }
                    this.decompressVQ(this.txb, this.tyb, (byte)0);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 7L) {
                    this.updateReadBuf(4);
                    this.m_VQ.BitMapBits = (byte)2;
                    for (n4 = 0; n4 < 4; ++n4) {
                        this.m_VQ.Index[n4] = (char)(this.getLong(this.m_RecvBuffer[0]) >> 29 & 3L);
                        if ((this.getLong(this.m_RecvBuffer[0]) >> 31 & 1L) == 0L) {
                            this.updateReadBuf(3);
                            continue;
                        }
                        this.m_VQ.Color[this.m_VQ.Index[n4]] = this.getLong(this.m_RecvBuffer[0]) >> 5 & 0xFFFFFFL;
                        this.updateReadBuf(27);
                    }
                    this.decompressVQ(this.txb, this.tyb, (byte)0);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 15L) {
                    this.txb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF00000L) >> 20);
                    this.tyb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF000L) >> 12);
                    this.updateReadBuf(20);
                    this.m_VQ.BitMapBits = (byte)2;
                    for (n4 = 0; n4 < 4; ++n4) {
                        this.m_VQ.Index[n4] = (char)(this.getLong(this.m_RecvBuffer[0]) >> 29 & 3L);
                        if ((this.getLong(this.m_RecvBuffer[0]) >> 31 & 1L) == 0L) {
                            this.updateReadBuf(3);
                            continue;
                        }
                        this.m_VQ.Color[this.m_VQ.Index[n4]] = this.getLong(this.m_RecvBuffer[0]) >> 5 & 0xFFFFFFL;
                        this.updateReadBuf(27);
                    }
                    this.decompressVQ(this.txb, this.tyb, (byte)0);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 4L) {
                    this.updateReadBuf(4);
                    this.decompressJPEG(this.txb, this.tyb, (byte)2);
                    this.moveBlockIndex();
                } else if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 12L) {
                    this.txb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF00000L) >> 20);
                    this.tyb = (int)((this.getLong(this.m_RecvBuffer[0]) & 0xFF000L) >> 12);
                    this.updateReadBuf(20);
                    this.decompressJPEG(this.txb, this.tyb, (byte)2);
                    this.moveBlockIndex();
                } else {
                    if ((this.getLong(this.m_RecvBuffer[0]) >> 28 & 0xFL) == 9L) {
                        return;
                    }
                    System.out.println("Unknow Marco Block type " + (this.getLong(this.m_RecvBuffer[0]) >> 28));
                    this.updateReadBuf(3);
                    this.moveBlockIndex();
                }
                this.m_view.repaint((this.txb - 1) * 16, this.tyb * 16, 16, 16);
                ++n3;
            } while (this._index < n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void RC4_crypt(int[] nArray, int n) {
        int n2 = this.s.x;
        int n3 = this.s.y;
        this.rc4Tmp = this.s.m;
        for (int i = 0; i < n; ++i) {
            int n4;
            n2 = (byte)(n2 + 1);
            int n5 = this.rc4Tmp[n2];
            n3 = (byte)(n3 + n5);
            this.rc4Tmp[n2] = n4 = this.rc4Tmp[n3];
            this.rc4Tmp[n3] = n5;
            nArray[SOCIVTPPktHdr.VIRTADD + i] = nArray[SOCIVTPPktHdr.VIRTADD + i] ^ this.rc4Tmp[(byte)(n5 + n4)];
        }
        this.s.x = n2;
        this.s.y = n3;
    }

    void DecodeRC4_setup(byte[] byArray, VideoEngineInfo videoEngineInfo) {
        int n;
        int[] nArray = new int[256];
        this.s.x = 0;
        this.s.y = 0;
        nArray = this.s.m;
        for (n = 0; n < 256; ++n) {
            nArray[n] = n;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            int n4 = nArray[n];
            n3 = (byte)(n3 + n4 + byArray[n2]);
            nArray[n] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
        }
    }

    void Keys_Expansion(byte[] byArray) {
        short s = (short)byArray.length;
        for (int n = 0; n < 256; n = (int)((short)(n + 1))) {
            byArray[n] = byArray[n % s];
        }
    }

    class rc4_state {
        int x;
        int y;
        int[] m = new int[256];

        rc4_state() {
        }
    }

    class COLOR_CACHE {
        long[] Color = new long[4];
        char[] Index = new char[4];
        byte BitMapBits;

        COLOR_CACHE() {
        }
    }

    class COMPRESSHEADER {
        int codesize;
        int width;
        int height;
        int modes;
        int bwidth;
        int bheight;
        int nd0;
        int nd1;
        int cmptype;
        int qfactor;
        int qfactoruv;
        int nd11;
        int nd12;
        int nd13;
        int nd14;
        int nd15;

        COMPRESSHEADER() {
        }
    }
}

