/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia.gui;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.StatusTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class StatusTabPanel
extends JPanel {
    private StatusTable cdStatusTable;
    private StatusTable hdStatusTable;
    private JScrollPane vmCDScrollPane;
    private JScrollPane vmHDScrollPane;

    public StatusTabPanel() {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 400;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setVMCDScrollPane(this.createStatusScrollPane(0));
        this.add((Component)this.getVMCDScrollPane(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.setVMHDScrollPane(this.createStatusScrollPane(2));
        this.add((Component)this.getVMHDScrollPane(), gridBagConstraints);
        this.setVisible(true);
    }

    public JScrollPane createStatusScrollPane(int n) {
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = null;
        String string = "";
        StatusTable statusTable = new StatusTable(n);
        JScrollPane jScrollPane = new JScrollPane(statusTable.getStatusTable(), 20, 30);
        switch (n) {
            case 0: {
                this.setCDStatusTable(statusTable);
                string = LocaleStrings.getString("AK_3_VMP") + " " + LocaleStrings.getString("AK_2_VMP");
                break;
            }
            case 2: {
                this.setHDStatusTable(statusTable);
                string = LocaleStrings.getString("AK_5_VMP") + " " + LocaleStrings.getString("AK_2_VMP");
            }
        }
        titledBorder = BorderFactory.createTitledBorder(border, string, 0, 1);
        jScrollPane.setBorder(titledBorder);
        return jScrollPane;
    }

    public void updateStatusTable(int n, int n2, boolean bl) {
        IUSBRedirSession iUSBRedirSession = VMApp.getInstance().getIUSBRedirSession();
        JTable jTable = null;
        String string = LocaleStrings.getString("AL_8_ST");
        String string2 = LocaleStrings.getString("AL_8_ST");
        switch (n) {
            case 0: {
                jTable = this.getCDStatusTable().getStatusTable();
                if (!bl) break;
                string = LocaleStrings.getString("AL_5_ST") + " : " + iUSBRedirSession.getCDInstanceNumber(n2);
                break;
            }
            case 2: {
                jTable = this.getHDStatusTable().getStatusTable();
                if (!bl) break;
                string = LocaleStrings.getString("AL_7_ST") + " : " + iUSBRedirSession.getHDInstanceNumber(n2);
            }
        }
        if (bl) {
            string2 = iUSBRedirSession.getDeviceRedirSource(n, n2);
        } else {
            string2 = LocaleStrings.getString("AL_8_ST");
            string = LocaleStrings.getString("AL_8_ST");
        }
        jTable.setValueAt(string, n2, 1);
        jTable.setValueAt(string2, n2, 2);
    }

    public StatusTable getCDStatusTable() {
        return this.cdStatusTable;
    }

    public void setCDStatusTable(StatusTable statusTable) {
        this.cdStatusTable = statusTable;
    }

    public StatusTable getHDStatusTable() {
        return this.hdStatusTable;
    }

    public void setHDStatusTable(StatusTable statusTable) {
        this.hdStatusTable = statusTable;
    }

    public JScrollPane getVMCDScrollPane() {
        return this.vmCDScrollPane;
    }

    public void setVMCDScrollPane(JScrollPane jScrollPane) {
        this.vmCDScrollPane = jScrollPane;
    }

    public JScrollPane getVMHDScrollPane() {
        return this.vmHDScrollPane;
    }

    public void setVMHDScrollPane(JScrollPane jScrollPane) {
        this.vmHDScrollPane = jScrollPane;
    }

    public JScrollPane getDeviceScrollPane(int n) {
        JScrollPane jScrollPane = null;
        switch (n) {
            case 0: {
                jScrollPane = this.getVMCDScrollPane();
                break;
            }
            case 2: {
                jScrollPane = this.getVMHDScrollPane();
            }
        }
        return jScrollPane;
    }
}

