/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JVPopupMenu;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;

public class StatusTable {
    private final int TABLE_ROWS = 4;
    private final String DISCONNECT = "Disconnect";
    private Object[] tableData;
    private String[][] tableStringData;
    private int numInstnces;
    private int deviceType;
    private int deviceIndex;
    private String[] columnNames = new String[]{LocaleStrings.getString("AL_1_ST"), LocaleStrings.getString("AL_2_ST"), LocaleStrings.getString("AL_3_ST"), LocaleStrings.getString("AL_4_ST")};
    private JTable statusTable;
    private JVPopupMenu popupMenu;

    public StatusTable(int n) {
        this.tableData = new Object[4];
        switch (n) {
            case 0: {
                this.tableData[0] = LocaleStrings.getString("AJ_1_DCP");
                this.tableData[1] = LocaleStrings.getString("AL_8_ST");
                this.tableData[2] = LocaleStrings.getString("AL_8_ST");
                this.tableData[3] = LocaleStrings.getString("AL_8_ST");
                this.numInstnces = VMApp.getInstance().getNumCD();
                break;
            }
            case 2: {
                this.tableData[0] = LocaleStrings.getString("AJ_3_DCP");
                this.tableData[1] = LocaleStrings.getString("AL_8_ST");
                this.tableData[2] = LocaleStrings.getString("AL_8_ST");
                this.tableData[3] = LocaleStrings.getString("AL_8_ST");
                this.numInstnces = VMApp.getInstance().getNumHD();
            }
        }
        this.tableStringData = new String[this.numInstnces][4];
        for (int i = 0; i < this.numInstnces; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (j == 0) {
                    String string;
                    this.tableStringData[i][j] = string = (String)this.tableData[0];
                    this.tableStringData[i][j] = this.tableStringData[i][j].concat(" " + (i + 1));
                    continue;
                }
                this.tableStringData[i][j] = (String)this.tableData[j];
            }
        }
        this.statusTable = new JTable(this.tableStringData, this.columnNames){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.statusTable.addMouseListener(new StatusTableMouseListener());
        this.statusTable.setShowGrid(false);
        this.statusTable.setSelectionMode(0);
        this.statusTable.setCellSelectionEnabled(false);
        this.statusTable.setRowSelectionAllowed(true);
        this.statusTable.setCellEditor(null);
        this.statusTable.setEnabled(true);
        this.initPopupMenu();
    }

    public JTable getStatusTable() {
        return this.statusTable;
    }

    private void initPopupMenu() {
        this.popupMenu = new JVPopupMenu();
        this.popupMenu.addMenuItem(LocaleStrings.getString("AJ_5_DCP"), "Disconnect", ' ', null);
        this.popupMenu.addActionListener(new StatusTablePopupActionListener());
    }

    private class StatusTablePopupActionListener
    implements ActionListener {
        private StatusTablePopupActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("Disconnect")) {
                VMApp.getInstance().getRedirectionController().handleDeviceRedirection(StatusTable.this.deviceType, StatusTable.this.deviceIndex);
            }
        }
    }

    private class StatusTableMouseListener
    extends MouseAdapter {
        private StatusTableMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getComponent();
            StatusTable.this.deviceIndex = jTable.getSelectedRow();
            if (mouseEvent.isPopupTrigger()) {
                if (jTable.getSelectedRow() < 0) {
                    return;
                }
                String string = (String)jTable.getModel().getValueAt(jTable.getSelectedRow(), 0);
                if ((string = string.substring(0, string.indexOf(": ") + 2)).equals(LocaleStrings.getString("AJ_1_DCP"))) {
                    StatusTable.this.deviceType = 0;
                } else if (string.equals(LocaleStrings.getString("AJ_3_DCP"))) {
                    StatusTable.this.deviceType = 2;
                } else {
                    Debug.out.println("Wrong Device Label : " + string);
                    return;
                }
                if (VMApp.getInstance().getIUSBRedirSession().getDeviceRedirStatus(StatusTable.this.deviceType, StatusTable.this.deviceIndex) == 1) {
                    StatusTable.this.popupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

