/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.avistream;

import com.ami.kvm.jviewer.avistream.DataChunkOutputStream;
import com.ami.kvm.jviewer.avistream.FilterImageOutputStream;
import com.ami.kvm.jviewer.common.IAVIOutputStream;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class AVIOutputStream
implements IAVIOutputStream {
    private ImageOutputStream out;
    private IAVIOutputStream.VideoFormat videoFormat;
    private float quality = 0.9f;
    private Date creationTime;
    private int imgWidth = -1;
    private int imgHeight = -1;
    private long timeScale = 1L;
    private long frameRate = 30L;
    private States state = States.FINISHED;
    public boolean streamClosed = false;
    public boolean singleVideo = false;
    private LinkedList<Sample> videoFrames;
    private CompositeChunk aviChunk;
    private CompositeChunk moviChunk;
    FixedSizeDataChunk avihChunk;
    FixedSizeDataChunk strhChunk;
    FixedSizeDataChunk strfChunk;

    public AVIOutputStream() {
    }

    public AVIOutputStream(File file, IAVIOutputStream.VideoFormat videoFormat, boolean bl) throws IOException {
        if (videoFormat == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.videoFormat = videoFormat;
        this.videoFrames = new LinkedList();
        this.singleVideo = bl;
    }

    public AVIOutputStream(ImageOutputStream imageOutputStream, IAVIOutputStream.VideoFormat videoFormat) {
        if (videoFormat == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        this.out = imageOutputStream;
        this.videoFormat = videoFormat;
        this.videoFrames = new LinkedList();
    }

    @Override
    public void setTimeScale(long l) {
        if (l <= 0L) {
            l = 1L;
        }
        this.timeScale = l;
    }

    @Override
    public long getTimeScale() {
        return this.timeScale;
    }

    @Override
    public void setFrameRate(long l) {
        if (l <= 0L) {
            l = 1L;
        }
        if (this.state == States.STARTED) {
            throw new IllegalStateException("frameDuration must be set before the first frame is written");
        }
        this.frameRate = l;
    }

    @Override
    public long getFrameRate() {
        return this.frameRate;
    }

    @Override
    public void setVideoCompressionQuality(float f) {
        this.quality = f;
    }

    @Override
    public float getVideoCompressionQuality() {
        return this.quality;
    }

    @Override
    public void setVideoDimension(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("width and height must be greater zero.");
        }
        this.imgWidth = n;
        this.imgHeight = n2;
    }

    @Override
    public Dimension getVideoDimension() {
        if (this.imgWidth < 1 || this.imgHeight < 1) {
            return null;
        }
        return new Dimension(this.imgWidth, this.imgHeight);
    }

    private void ensureStarted() throws IOException {
        if (this.state != States.STARTED) {
            this.creationTime = new Date();
            this.writeProlog();
            this.state = States.STARTED;
        }
    }

    @Override
    public boolean writeFrame(BufferedImage bufferedImage) throws IOException {
        this.ensureOpen();
        this.ensureStarted();
        if (this.imgWidth == -1) {
            this.imgWidth = bufferedImage.getWidth();
            this.imgHeight = bufferedImage.getHeight();
        } else if (!(this.singleVideo || this.imgWidth == bufferedImage.getWidth() && this.imgHeight == bufferedImage.getHeight())) {
            this.close();
            this.imgHeight = -1;
            this.imgWidth = -1;
            this.streamClosed = true;
            return false;
        }
        DataChunk dataChunk = new DataChunk(this.videoFormat == IAVIOutputStream.VideoFormat.RAW ? "00db" : "00dc");
        this.moviChunk.add(dataChunk);
        long l = this.out.getStreamPosition();
        ImageWriter imageWriter = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(this.quality);
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(dataChunk.getOutputStream());
        imageWriter.setOutput(memoryCacheImageOutputStream);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        imageWriter.write(null, iIOImage, imageWriteParam);
        imageWriter.dispose();
        long l2 = this.out.getStreamPosition() - l;
        dataChunk.finish();
        this.videoFrames.add(new Sample(this.frameRate, l, l2));
        if (this.out.getStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFrame(File file) throws IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            this.writeFrame(fileInputStream);
        }
    }

    @Override
    public void writeFrame(InputStream inputStream) throws IOException {
        int n;
        this.ensureOpen();
        this.ensureStarted();
        DataChunk dataChunk = new DataChunk("00dc");
        this.moviChunk.add(dataChunk);
        DataChunkOutputStream dataChunkOutputStream = dataChunk.getOutputStream();
        long l = this.out.getStreamPosition();
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray)) != -1) {
            ((OutputStream)dataChunkOutputStream).write(byArray, 0, n);
        }
        long l2 = this.out.getStreamPosition() - l;
        dataChunk.finish();
        this.videoFrames.add(new Sample(this.frameRate, l, l2));
        if (this.out.getStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.state == States.STARTED) {
            this.finish();
        }
        if (this.state != States.CLOSED) {
            this.out.close();
            this.state = States.CLOSED;
        }
    }

    @Override
    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            if (this.imgWidth == -1 || this.imgHeight == -1) {
                throw new IllegalStateException("image width and height must be specified");
            }
            this.moviChunk.finish();
            this.writeEpilog();
            this.state = States.FINISHED;
            this.imgHeight = -1;
            this.imgWidth = -1;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private void writeProlog() throws IOException {
        this.aviChunk = new CompositeChunk("RIFF", "AVI ");
        CompositeChunk compositeChunk = new CompositeChunk("LIST", "hdrl");
        this.aviChunk.add(compositeChunk);
        this.avihChunk = new FixedSizeDataChunk("avih", 56L);
        this.avihChunk.seekToEndOfChunk();
        compositeChunk.add(this.avihChunk);
        CompositeChunk compositeChunk2 = new CompositeChunk("LIST", "strl");
        compositeChunk.add(compositeChunk2);
        this.strhChunk = new FixedSizeDataChunk("strh", 56L);
        this.strhChunk.seekToEndOfChunk();
        compositeChunk2.add(this.strhChunk);
        this.strfChunk = new FixedSizeDataChunk("strf", 40L);
        this.strfChunk.seekToEndOfChunk();
        compositeChunk2.add(this.strfChunk);
        this.moviChunk = new CompositeChunk("LIST", "movi");
        this.aviChunk.add(this.moviChunk);
    }

    private void writeEpilog() throws IOException {
        int n = 0;
        for (Sample sample : this.videoFrames) {
            n = (int)((long)n + sample.duration);
        }
        long l = 0L;
        for (Sample object2 : this.videoFrames) {
            if (object2.length <= l) continue;
            l = object2.length;
        }
        DataChunk dataChunk = new DataChunk("idx1");
        this.aviChunk.add(dataChunk);
        Object object3 = dataChunk.getOutputStream();
        for (Sample sample : this.videoFrames) {
            ((DataChunkOutputStream)object3).writeType("00dc");
            ((DataChunkOutputStream)object3).writeUInt(16L);
            ((DataChunkOutputStream)object3).writeUInt(sample.offset - this.moviChunk.offset - 16L);
            ((DataChunkOutputStream)object3).writeUInt(sample.length);
        }
        dataChunk.finish();
        this.avihChunk.seekToStartOfData();
        object3 = this.avihChunk.getOutputStream();
        ((DataChunkOutputStream)object3).writeUInt(10000000L * this.timeScale / this.frameRate);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUInt(16L);
        ((DataChunkOutputStream)object3).writeUInt(this.videoFrames.size());
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUInt(1L);
        ((DataChunkOutputStream)object3).writeUInt(l);
        ((DataChunkOutputStream)object3).writeUInt(this.imgWidth);
        ((DataChunkOutputStream)object3).writeUInt(this.imgHeight);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        this.strhChunk.seekToStartOfData();
        object3 = this.strhChunk.getOutputStream();
        ((DataChunkOutputStream)object3).writeType("vids");
        switch (this.videoFormat) {
            case RAW: {
                ((DataChunkOutputStream)object3).writeType("DIB ");
                break;
            }
            case JPG: {
                ((DataChunkOutputStream)object3).writeType("MJPG");
                break;
            }
            default: {
                ((DataChunkOutputStream)object3).writeType("png ");
            }
        }
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUShort(0);
        ((DataChunkOutputStream)object3).writeUShort(0);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUInt(this.timeScale);
        ((DataChunkOutputStream)object3).writeUInt(this.frameRate);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUInt(this.videoFrames.size());
        ((DataChunkOutputStream)object3).writeUInt(l);
        ((DataChunkOutputStream)object3).writeInt(-1);
        ((DataChunkOutputStream)object3).writeUInt(0L);
        ((DataChunkOutputStream)object3).writeUShort(0);
        ((DataChunkOutputStream)object3).writeUShort(0);
        ((DataChunkOutputStream)object3).writeUShort(this.imgWidth);
        ((DataChunkOutputStream)object3).writeUShort(this.imgHeight);
        this.strfChunk.seekToStartOfData();
        object3 = this.strfChunk.getOutputStream();
        ((DataChunkOutputStream)object3).writeUInt(40L);
        ((DataChunkOutputStream)object3).writeInt(this.imgWidth);
        ((DataChunkOutputStream)object3).writeInt(this.imgHeight);
        ((DataChunkOutputStream)object3).writeShort(1);
        ((DataChunkOutputStream)object3).writeShort(24);
        switch (this.videoFormat) {
            case RAW: {
                ((DataChunkOutputStream)object3).writeInt(0);
                break;
            }
            case JPG: {
                ((DataChunkOutputStream)object3).writeType("MJPG");
                break;
            }
            default: {
                ((DataChunkOutputStream)object3).writeType("png ");
            }
        }
        ((DataChunkOutputStream)object3).writeInt(this.imgWidth * this.imgHeight * 3);
        ((DataChunkOutputStream)object3).writeInt(0);
        ((DataChunkOutputStream)object3).writeInt(0);
        ((DataChunkOutputStream)object3).writeInt(0);
        ((DataChunkOutputStream)object3).writeInt(0);
        this.aviChunk.finish();
    }

    @Override
    public void initVideoFrames() {
        this.videoFrames = new LinkedList();
    }

    @Override
    public void setOutputFile(File file) {
        try {
            this.out = new FileImageOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setVideoFormat(IAVIOutputStream.VideoFormat videoFormat) {
        this.videoFormat = videoFormat;
    }

    @Override
    public void setSingleVideo(boolean bl) {
        this.singleVideo = bl;
    }

    @Override
    public boolean isStreamClosed() {
        return this.streamClosed;
    }

    @Override
    public void setStreamClosed(boolean bl) {
        this.streamClosed = bl;
    }

    private class FixedSizeDataChunk
    extends Chunk {
        private DataChunkOutputStream data;
        private boolean finished;
        private long fixedSize;

        public FixedSizeDataChunk(String string, long l) throws IOException {
            super(string);
            this.fixedSize = l;
            this.data = new DataChunkOutputStream(new FilterImageOutputStream(AVIOutputStream.this.out));
            this.data.writeType(string);
            this.data.writeUInt(l);
            this.data.clearCount();
            byte[] byArray = new byte[(int)Math.min(512L, l)];
            for (long i = 0L; i < l; i += Math.min((long)byArray.length, l - i)) {
                this.data.write(byArray, 0, (int)Math.min((long)byArray.length, l - i));
            }
            if (l % 2L == 1L) {
                AVIOutputStream.this.out.writeByte(0);
            }
            this.seekToStartOfData();
        }

        public DataChunkOutputStream getOutputStream() {
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        public void seekToStartOfData() throws IOException {
            AVIOutputStream.this.out.seek(this.offset + 8L);
            this.data.clearCount();
        }

        public void seekToEndOfChunk() throws IOException {
            AVIOutputStream.this.out.seek(this.offset + 8L + this.fixedSize + this.fixedSize % 2L);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 8L + this.fixedSize;
        }
    }

    private class DataChunk
    extends Chunk {
        private DataChunkOutputStream data;
        private boolean finished;

        public DataChunk(String string) throws IOException {
            super(string);
            AVIOutputStream.this.out.writeLong(0L);
            this.data = new DataChunkOutputStream(new FilterImageOutputStream(AVIOutputStream.this.out));
        }

        public DataChunkOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataChunk is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long l = this.size();
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("DataChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long l2 = AVIOutputStream.this.out.getStreamPosition();
                AVIOutputStream.this.out.seek(this.offset);
                DataChunkOutputStream dataChunkOutputStream = new DataChunkOutputStream(new FilterImageOutputStream(AVIOutputStream.this.out));
                dataChunkOutputStream.writeType(this.chunkType);
                dataChunkOutputStream.writeUInt(this.size() - 8L);
                AVIOutputStream.this.out.seek(l2);
                if (this.size() % 2L == 1L) {
                    AVIOutputStream.this.out.writeByte(0);
                }
                this.finished = true;
                long l3 = this.size();
                if (l != l3) {
                    System.err.println("size mismatch " + l + ".." + l3);
                }
            }
        }

        @Override
        public long size() {
            return 8L + this.data.size();
        }
    }

    private class CompositeChunk
    extends Chunk {
        protected String compositeType;
        private LinkedList<Chunk> children;
        private boolean finished;

        public CompositeChunk(String string, String string2) throws IOException {
            super(string2);
            this.compositeType = string;
            AVIOutputStream.this.out.writeLong(0L);
            AVIOutputStream.this.out.writeInt(0);
            this.children = new LinkedList();
        }

        public void add(Chunk chunk) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(chunk);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long l = AVIOutputStream.this.out.getStreamPosition();
                AVIOutputStream.this.out.seek(this.offset);
                DataChunkOutputStream dataChunkOutputStream = new DataChunkOutputStream(new FilterImageOutputStream(AVIOutputStream.this.out));
                dataChunkOutputStream.writeType(this.compositeType);
                dataChunkOutputStream.writeUInt(this.size() - 8L);
                dataChunkOutputStream.writeType(this.chunkType);
                for (Chunk chunk : this.children) {
                    chunk.finish();
                }
                AVIOutputStream.this.out.seek(l);
                if (this.size() % 2L == 1L) {
                    AVIOutputStream.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long l = 12L;
            for (Chunk chunk : this.children) {
                l += chunk.size() + chunk.size() % 2L;
            }
            return l;
        }
    }

    private abstract class Chunk {
        protected String chunkType;
        protected long offset;

        public Chunk(String string) throws IOException {
            this.chunkType = string;
            this.offset = AVIOutputStream.this.out.getStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    private static class Sample {
        long offset;
        long length;
        long duration;

        public Sample(long l, long l2, long l3) {
            this.duration = l;
            this.offset = l2;
            this.length = l3;
        }
    }

    private static enum States {
        STARTED,
        FINISHED,
        CLOSED;

    }
}

