/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JVPopupMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class IPMICommandDialog
extends JDialog
implements ActionListener {
    private final int WIDTH = 800;
    private final int HEIGHT = 500;
    private JPanel summaryPanel;
    private JPanel commandPanel;
    private JScrollPane summaryScrollPane;
    private JLabel commandLabel;
    private JTextArea hexCommandArea;
    private JTextArea asciiCommandArea;
    private JButton sendButton;
    private JButton clearButton;
    private JTable summaryTable;
    private DefaultTableModel summaryTableModel;
    private IPMICommandDialogKeyListener dialogKeyListener = new IPMICommandDialogKeyListener();
    private IPMICommandDialogMouseListener dialogMouseListener = new IPMICommandDialogMouseListener();
    private IPMICommandDialogPopupMenuActionListener popupMenuActionListener = new IPMICommandDialogPopupMenuActionListener();
    protected static int SEQUENCE_LIMIT = 1000;
    private static Hashtable<Integer, String[]> savedSummary = null;
    private static byte sequenceData = 1;
    private static int sequenceNum = 1;
    private String errorStirng = null;
    private boolean scrollToBottom = false;
    private int scrollMax = 0;
    private JVPopupMenu popupMenu = null;
    private Component rightClickComponent = null;
    private JTextArea textAreaCell;

    public IPMICommandDialog(JFrame jFrame) {
        super(jFrame, LocaleStrings.getString("AG_1_IPMI"), false);
        this.initDialogPopupMenu();
    }

    public void showDialog() {
        Point point = JViewerApp.getInstance().getPopUpWindowPosition(800, 500);
        this.setBounds(new Rectangle(point.x, point.y, 800, 500));
        this.setMinimumSize(new Dimension(800, 500));
        if (this.summaryPanel == null) {
            this.summaryPanel = this.createSummaryPanel();
        }
        this.getContentPane().add((Component)this.summaryPanel, "Center");
        if (this.commandPanel == null) {
            this.commandPanel = this.createCommandPanel();
        }
        this.getContentPane().add((Component)this.commandPanel, "South");
        if (savedSummary != null) {
            this.restoreSummary();
        }
        this.setVisible(true);
        this.addWindowListener(new IPMICommandDialogWindowListener());
    }

    private JPanel createSummaryPanel() {
        Color color = new Color(237, 237, 237);
        Object[][] objectArray = new Object[][]{};
        Object[] objectArray2 = new String[]{LocaleStrings.getString("AG_9_IPMI"), LocaleStrings.getString("AG_10_IPMI")};
        this.summaryTableModel = new DefaultTableModel(objectArray, objectArray2);
        this.summaryTable = new JTable(this.summaryTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                MatteBorder matteBorder = new MatteBorder(0, 0, 2, 0, Color.GRAY);
                EmptyBorder emptyBorder = new EmptyBorder(0, 1, 0, 1);
                CompoundBorder compoundBorder = new CompoundBorder(matteBorder, emptyBorder);
                TextWrapTableCellRenderer textWrapTableCellRenderer = (TextWrapTableCellRenderer)super.prepareRenderer(tableCellRenderer, n, n2);
                if (n % 2 == 0) {
                    textWrapTableCellRenderer.setBackground(new Color(230, 230, 230));
                    textWrapTableCellRenderer.setBorder(null);
                } else {
                    textWrapTableCellRenderer.setBackground(Color.WHITE);
                    textWrapTableCellRenderer.setBorder(compoundBorder);
                }
                return textWrapTableCellRenderer;
            }
        };
        this.summaryTable.setShowHorizontalLines(false);
        this.summaryTable.setFocusable(false);
        this.summaryTable.setCellSelectionEnabled(true);
        this.summaryTable.setColumnSelectionAllowed(true);
        this.summaryTable.setRowSelectionAllowed(true);
        this.summaryTable.setSelectionMode(0);
        this.summaryTable.addMouseListener(this.dialogMouseListener);
        this.setSummaryTableCellRenderer();
        this.setSummaryTableCellEditor();
        this.summaryScrollPane = new JScrollPane(this.summaryTable, 20, 30);
        this.summaryScrollPane.getVerticalScrollBar().addAdjustmentListener(new DialogAdjustmentListener());
        JPanel jPanel = new JPanel(new BorderLayout());
        MatteBorder matteBorder = new MatteBorder(5, 5, 5, 5, color);
        jPanel.setBorder(matteBorder);
        jPanel.add((Component)this.summaryScrollPane, "Center");
        return jPanel;
    }

    private void setSummaryTableCellRenderer() {
        TextWrapTableCellRenderer textWrapTableCellRenderer = new TextWrapTableCellRenderer();
        for (int i = 0; i < this.summaryTable.getColumnCount(); ++i) {
            this.summaryTable.getColumnModel().getColumn(i).setCellRenderer(textWrapTableCellRenderer);
        }
    }

    private void setSummaryTableCellEditor() {
        TextCellEditor textCellEditor = new TextCellEditor();
        for (int i = 0; i < this.summaryTable.getColumnCount(); ++i) {
            this.summaryTable.getColumnModel().getColumn(i).setCellEditor(textCellEditor);
        }
    }

    private JPanel createCommandPanel() {
        Color color = new Color(237, 237, 237);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        this.commandLabel = new JLabel(LocaleStrings.getString("AG_2_IPMI"));
        jPanel.add((Component)this.commandLabel, "North");
        jPanel.add((Component)this.createTextPanel(), "Center");
        jPanel.add((Component)this.createButtonPanel(), "South");
        MatteBorder matteBorder = new MatteBorder(5, 5, 5, 5, color);
        jPanel.setBorder(matteBorder);
        return jPanel;
    }

    private JPanel createTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JLabel jLabel = new JLabel(LocaleStrings.getString("AG_9_IPMI"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 1, 2, 2);
        gridBagConstraints.gridy = 1;
        this.hexCommandArea = new JTextArea(2, 25);
        this.hexCommandArea.setAutoscrolls(true);
        this.hexCommandArea.setLineWrap(true);
        this.hexCommandArea.setWrapStyleWord(true);
        this.hexCommandArea.setBorder(new SoftBevelBorder(1));
        this.hexCommandArea.addKeyListener(this.dialogKeyListener);
        this.hexCommandArea.addMouseListener(this.dialogMouseListener);
        JScrollPane jScrollPane = new JScrollPane(this.hexCommandArea, 20, 31);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        JLabel jLabel2 = new JLabel(LocaleStrings.getString("AG_10_IPMI"));
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setVerticalAlignment(0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 2, 2, 1);
        gridBagConstraints.gridy = 1;
        this.asciiCommandArea = new JTextArea(2, 25);
        this.asciiCommandArea.setRows(2);
        this.asciiCommandArea.setAutoscrolls(true);
        this.asciiCommandArea.setLineWrap(true);
        this.asciiCommandArea.setWrapStyleWord(true);
        this.asciiCommandArea.setBorder(new SoftBevelBorder(1));
        this.asciiCommandArea.addKeyListener(this.dialogKeyListener);
        this.asciiCommandArea.addMouseListener(this.dialogMouseListener);
        JScrollPane jScrollPane2 = new JScrollPane(this.asciiCommandArea, 20, 31);
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.sendButton = new JButton(LocaleStrings.getString("AG_3_IPMI"));
        this.sendButton.addActionListener(this);
        this.sendButton.addKeyListener(this.dialogKeyListener);
        jPanel.add((Component)this.sendButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 5, 1, 1);
        gridBagConstraints.gridx = 2;
        this.clearButton = new JButton(LocaleStrings.getString("AG_12_IPMI"));
        this.clearButton.addActionListener(this);
        this.clearButton.addKeyListener(this.dialogKeyListener);
        jPanel.add((Component)this.clearButton, gridBagConstraints);
        return jPanel;
    }

    private void sendCommand() {
        String string = this.hexCommandArea.getText();
        if (string.length() > 0) {
            int[] nArray = this.formCommandArray(this.hexCommandArea.getText());
            byte[] byArray = null;
            if (nArray != null) {
                byArray = new byte[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    byArray[i] = (byte)nArray[i];
                }
            }
            if (byArray == null && this.errorStirng != null) {
                this.hexCommandArea.setText("");
                this.asciiCommandArea.setText("");
                InfoDialog.showDialog((Component)this, this.errorStirng, LocaleStrings.getString("AG_6_IPMI"), 2);
                this.errorStirng = null;
            } else if (byArray.length < 2) {
                this.hexCommandArea.setText("");
                this.asciiCommandArea.setText("");
                this.errorStirng = LocaleStrings.getString("AG_11_IPMI");
                InfoDialog.showDialog((Component)this, this.errorStirng, LocaleStrings.getString("AG_6_IPMI"), 2);
                this.errorStirng = null;
            } else {
                JViewerApp.getInstance().onSendIPMICommand(sequenceData, byArray);
                this.appendRequestText();
                sequenceData = (byte)(++sequenceNum);
                this.resetSequence();
            }
        }
    }

    private void resetSequence() {
        int n = JViewerApp.getOEMManager().getOEMIoemipmiCommandDialog().getOEMSEQUENCE_LIMIT();
        if (sequenceData > n) {
            sequenceNum = 1;
            sequenceData = 1;
        }
    }

    private void clearSummary() {
        for (int i = this.summaryTable.getRowCount() - 1; i >= 0; --i) {
            this.summaryTableModel.removeRow(i);
        }
        sequenceNum = 1;
        sequenceData = 1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.sendButton)) {
            this.sendCommand();
        } else if (actionEvent.getSource().equals(this.clearButton)) {
            this.clearSummary();
        }
    }

    private int[] formCommandArray(String string) {
        int[] nArray = null;
        String string2 = string;
        String[] stringArray = null;
        try {
            if (string2.contains("0x")) {
                string2 = string2.replaceAll("0x ", "");
                string2 = string2.replaceAll("0x", "");
            } else if (string2.startsWith(" ")) {
                string2 = string2.replaceFirst(" ", "");
            } else if (string2.contains("\n")) {
                string2 = string2.replaceAll("\n", "");
            }
            stringArray = string2.split(" ");
            if (stringArray.length < 1) {
                this.hexCommandArea.setText("");
                this.asciiCommandArea.setText("");
                return null;
            }
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    stringArray[i] = stringArray[i].trim();
                    nArray[i] = Integer.parseInt(stringArray[i], 16);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorStirng = LocaleStrings.getString("AG_6_IPMI") + " \"" + stringArray[i] + "\".\n" + LocaleStrings.getString("AG_7_IPMI") + "\n" + "( " + LocaleStrings.getString("AG_8_IPMI") + "0x2a 0x1f )";
                    Debug.out.println("Invalid command");
                    Debug.out.println(numberFormatException);
                    return null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.errorStirng = LocaleStrings.getString("AG_6_IPMI") + " \"" + string + "\".\n" + LocaleStrings.getString("AG_7_IPMI") + "\n" + "( " + LocaleStrings.getString("AG_8_IPMI") + "0x2a 0x1f )";
            Debug.out.println(nullPointerException);
            return null;
        }
        return nArray;
    }

    private String convertHexToASCII(String string) {
        String string2 = "";
        int[] nArray = this.formCommandArray(string);
        if (nArray == null) {
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            string2 = nArray[i] < 32 ? string2 + ".    " : string2 + (char)nArray[i] + "    ";
            if (i <= 0 || (i + 1) % 16 != 0) continue;
            string2 = string2 + "\n";
        }
        return string2;
    }

    public void onIPMICommandRespose(byte by, String string) {
        this.appendResponseText(by, string);
    }

    private void appendRequestText() {
        if (this.hexCommandArea.getText().equals("")) {
            return;
        }
        int n = 2 * sequenceNum - 2;
        String string = this.convertHexToASCII(this.hexCommandArea.getText());
        string = string != null ? "\n" + string : "";
        Object[] objectArray = new Object[]{LocaleStrings.getString("AG_4_IPMI") + " :\n" + this.hexCommandArea.getText(), string};
        this.summaryTableModel.insertRow(n, objectArray);
        this.hexCommandArea.setText("");
        this.asciiCommandArea.setText("");
        this.scrollToBottom = true;
        this.summaryTable.setFocusable(true);
    }

    public void appendResponseText(int n, String string) {
        int n2 = 2 * n - 1;
        String string2 = this.convertHexToASCII(string);
        string2 = string2 != null ? "\n" + string2 : "";
        Object[] objectArray = new Object[]{LocaleStrings.getString("AG_5_IPMI") + " :\n" + string, string2};
        this.summaryTableModel.insertRow(n2, objectArray);
        this.scrollToBottom = true;
    }

    private void saveCommandSummary() {
        int n = this.summaryTableModel.getRowCount();
        int n2 = this.summaryTableModel.getColumnCount();
        String[][] stringArray = new String[n][n2];
        savedSummary = new Hashtable();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = (String)this.summaryTableModel.getValueAt(i, j);
            }
            savedSummary.put(i, stringArray[i]);
        }
    }

    private void restoreSummary() {
        if (this.summaryTableModel != null) {
            int n = savedSummary.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = savedSummary.get(i);
                objectArray = this.localizeSummaryData((String[])objectArray);
                this.summaryTableModel.addRow(objectArray);
            }
        }
        savedSummary = null;
    }

    private String[] localizeSummaryData(String[] stringArray) {
        if (stringArray[0].startsWith(LocaleStrings.getPreviousLocaleString("AG_4_IPMI"))) {
            stringArray[0] = stringArray[0].replaceAll(LocaleStrings.getPreviousLocaleString("AG_4_IPMI"), LocaleStrings.getString("AG_4_IPMI"));
        } else if (stringArray[0].startsWith(LocaleStrings.getPreviousLocaleString("AG_5_IPMI"))) {
            stringArray[0] = stringArray[0].replaceAll(LocaleStrings.getPreviousLocaleString("AG_5_IPMI"), LocaleStrings.getString("AG_5_IPMI"));
        }
        if (stringArray[0].contains(LocaleStrings.getPreviousLocaleString("D_49_JVAPP"))) {
            stringArray[0] = stringArray[0].replaceAll(LocaleStrings.getPreviousLocaleString("D_49_JVAPP"), LocaleStrings.getString("D_49_JVAPP"));
        }
        return stringArray;
    }

    public void closeIPMICommandDialog() {
        this.saveCommandSummary();
        IPMICommandDialog iPMICommandDialog = null;
        JViewerApp.getInstance().setIPMIDialog(iPMICommandDialog);
        this.dispose();
    }

    private void initDialogPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JVPopupMenu();
            this.popupMenu.createEditPopup();
            this.popupMenu.addActionListener(this.popupMenuActionListener);
        }
    }

    private class IPMICommandDialogPopupMenuActionListener
    implements ActionListener {
        private IPMICommandDialogPopupMenuActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (IPMICommandDialog.this.rightClickComponent.equals(IPMICommandDialog.this.textAreaCell)) {
                JTextArea jTextArea = (JTextArea)IPMICommandDialog.this.rightClickComponent;
                if (string.equals("Copy")) {
                    jTextArea.copy();
                }
            } else if (IPMICommandDialog.this.rightClickComponent.equals(IPMICommandDialog.this.hexCommandArea) || IPMICommandDialog.this.rightClickComponent.equals(IPMICommandDialog.this.asciiCommandArea)) {
                JTextArea jTextArea = (JTextArea)IPMICommandDialog.this.rightClickComponent;
                if (string.equals("Cut")) {
                    jTextArea.cut();
                } else if (string.equals("Copy")) {
                    jTextArea.copy();
                } else if (string.equals("Paste")) {
                    jTextArea.paste();
                }
            }
        }
    }

    private class IPMICommandDialogMouseListener
    extends MouseAdapter {
        private IPMICommandDialogMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            IPMICommandDialog.this.rightClickComponent = mouseEvent.getComponent();
            if (IPMICommandDialog.this.rightClickComponent != null) {
                IPMICommandDialog.this.popupMenu.enableAll();
                if (IPMICommandDialog.this.rightClickComponent instanceof JTextArea) {
                    JTextArea jTextArea = (JTextArea)IPMICommandDialog.this.rightClickComponent;
                    if (!jTextArea.isEditable()) {
                        IPMICommandDialog.this.popupMenu.getMenuItem("Cut").setEnabled(false);
                        IPMICommandDialog.this.popupMenu.getMenuItem("Paste").setEnabled(false);
                    }
                    if (jTextArea.getSelectedText() == null) {
                        IPMICommandDialog.this.popupMenu.getMenuItem("Cut").setEnabled(false);
                        IPMICommandDialog.this.popupMenu.getMenuItem("Copy").setEnabled(false);
                    }
                    if (transferable.equals(null) || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        IPMICommandDialog.this.popupMenu.getMenuItem("Paste").setEnabled(false);
                    }
                } else {
                    IPMICommandDialog.this.popupMenu.getMenuItem("Copy").setEnabled(false);
                    IPMICommandDialog.this.popupMenu.getMenuItem("Cut").setEnabled(false);
                    IPMICommandDialog.this.popupMenu.getMenuItem("Paste").setEnabled(false);
                }
                if (this.isPopupTrigger(mouseEvent)) {
                    IPMICommandDialog.this.popupMenu.show(IPMICommandDialog.this.rightClickComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        private boolean isPopupTrigger(MouseEvent mouseEvent) {
            boolean bl = false;
            if (mouseEvent.isPopupTrigger()) {
                bl = true;
            }
            return bl;
        }
    }

    private class DialogAdjustmentListener
    implements AdjustmentListener {
        private DialogAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (IPMICommandDialog.this.scrollToBottom || IPMICommandDialog.this.scrollMax < IPMICommandDialog.this.summaryScrollPane.getVerticalScrollBar().getMaximum()) {
                IPMICommandDialog.this.scrollMax = IPMICommandDialog.this.summaryScrollPane.getVerticalScrollBar().getMaximum();
                IPMICommandDialog.this.summaryScrollPane.getVerticalScrollBar().setValue(IPMICommandDialog.this.scrollMax);
                IPMICommandDialog.this.scrollToBottom = false;
            }
        }
    }

    private class TextCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        Border outside = new MatteBorder(0, 0, 2, 0, Color.GRAY);
        Border inside = new EmptyBorder(0, 1, 0, 1);
        Border highlight = new CompoundBorder(this.outside, this.inside);

        public TextCellEditor() {
            IPMICommandDialog.this.textAreaCell = new JTextArea();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n % 2 == 0) {
                IPMICommandDialog.this.textAreaCell.setBackground(new Color(230, 230, 230));
                IPMICommandDialog.this.textAreaCell.setBorder(null);
            } else {
                IPMICommandDialog.this.textAreaCell.setBackground(Color.WHITE);
                IPMICommandDialog.this.textAreaCell.setBorder(this.highlight);
            }
            IPMICommandDialog.this.textAreaCell.setLineWrap(true);
            IPMICommandDialog.this.textAreaCell.setText((String)object);
            IPMICommandDialog.this.textAreaCell.setEditable(false);
            IPMICommandDialog.this.textAreaCell.addMouseListener(IPMICommandDialog.this.dialogMouseListener);
            return IPMICommandDialog.this.textAreaCell;
        }

        @Override
        public Object getCellEditorValue() {
            return IPMICommandDialog.this.textAreaCell.getText();
        }
    }

    private class TextWrapTableCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private TextWrapTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText((String)object);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setSize(jTable.getColumnModel().getColumn(n2).getWidth(), this.getPreferredSize().height);
            if (jTable.getRowHeight(n) < this.getPreferredSize().height) {
                jTable.setRowHeight(n, this.getPreferredSize().height);
            }
            return this;
        }
    }

    private class IPMICommandDialogWindowListener
    extends WindowAdapter {
        private IPMICommandDialogWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            IPMICommandDialog.this.closeIPMICommandDialog();
        }
    }

    private class IPMICommandDialogKeyListener
    extends KeyAdapter {
        private IPMICommandDialogKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (keyEvent.getSource().equals(IPMICommandDialog.this.sendButton) || keyEvent.getSource().equals(IPMICommandDialog.this.hexCommandArea) || keyEvent.getSource().equals(IPMICommandDialog.this.asciiCommandArea)) {
                    IPMICommandDialog.this.sendCommand();
                    keyEvent.consume();
                } else if (keyEvent.getSource().equals(IPMICommandDialog.this.clearButton)) {
                    IPMICommandDialog.this.clearSummary();
                    keyEvent.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            String string = null;
            String string2 = "";
            if (keyEvent.getSource().equals(IPMICommandDialog.this.asciiCommandArea)) {
                IPMICommandDialog.this.hexCommandArea.setText("");
                string = IPMICommandDialog.this.asciiCommandArea.getText();
                string = string.replaceAll(" ", "");
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    string2 = string2 + Integer.toHexString(cArray[i]) + " ";
                }
                IPMICommandDialog.this.hexCommandArea.setText(string2);
            } else if (keyEvent.getSource().equals(IPMICommandDialog.this.hexCommandArea)) {
                IPMICommandDialog.this.asciiCommandArea.setText("");
                string = IPMICommandDialog.this.convertHexToASCII(IPMICommandDialog.this.hexCommandArea.getText());
                IPMICommandDialog.this.asciiCommandArea.setText(string);
            }
        }
    }
}

