/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.hid.USBMessage;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KMCrypt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class USBMouseRep
extends USBMessage {
    private static final int DIRABS_MAX_SCALED_X = Short.MAX_VALUE;
    private static final int DIRABS_MAX_SCALED_Y = Short.MAX_VALUE;
    public static byte INVALID_MOUSE_MODE = (byte)-1;
    public static byte RELATIVE_MOUSE_MODE = 1;
    public static byte ABSOLUTE_MOUSE_MODE = (byte)2;
    public static byte OTHER_MOUSE_MODE = (byte)3;
    private byte m_MouseMode = INVALID_MOUSE_MODE;
    public static byte m_btnStatus = 0;
    public double m_xDisp;
    public double m_yDisp;
    private ByteBuffer m_repBuf;
    private byte[] m_report;
    private static int SeqNum = 0;
    private double m_screenwidth;
    private double m_screenheight;
    private byte m_wheelrotation;

    public USBMouseRep() {
        this(0, 0, 0, 0);
    }

    public USBMouseRep(byte by, int n, int n2, byte by2) {
        m_btnStatus = by;
        this.m_xDisp = n;
        this.m_yDisp = n2;
        this.m_wheelrotation = by2;
    }

    public void set(byte by, double d, double d2, byte by2, int n, int n2, byte by3) {
        m_btnStatus = by;
        this.m_xDisp = d;
        this.m_yDisp = d2;
        this.m_MouseMode = by2;
        this.m_screenwidth = n;
        this.m_screenheight = n2;
        if (this.m_screenwidth == 832.0) {
            this.m_screenwidth = 800.0;
        }
        this.m_wheelrotation = by3;
    }

    public byte[] ABSreport(KMCrypt kMCrypt) {
        short s = (short)(this.m_xDisp * 32767.0 / this.m_screenwidth + 0.5);
        short s2 = (short)(this.m_yDisp * 32767.0 / this.m_screenheight + 0.5);
        if (kMCrypt != null) {
            this.m_vHdr = new IVTPPktHdr(1, 41, 0);
            this.m_report = new byte[49];
        } else {
            this.m_vHdr = new IVTPPktHdr(1, 39, 0);
            this.m_report = new byte[47];
        }
        int n = 7;
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        if (kMCrypt != null) {
            this.m_vHdr.setSize(41);
            this.m_vHdr.setStatus((short)255);
        } else {
            this.m_vHdr.setSize(39);
            this.m_vHdr.setStatus((short)0);
        }
        this.m_repBuf.put(this.m_vHdr.array());
        this.m_repBuf.put(this.m_signature);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(n);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)49);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)-128);
        this.m_repBuf.put((byte)2);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(SeqNum);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)6);
        if (kMCrypt != null) {
            byte[] byArray = new byte[6];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(m_btnStatus);
            byteBuffer.putShort(s);
            byteBuffer.putShort(s2);
            byteBuffer.put(this.m_wheelrotation);
            byte[] byArray2 = kMCrypt.encrypt(byArray);
            if (byArray2 == null) {
                return this.ABSreport(null);
            }
            this.m_repBuf.put(byArray2);
        } else {
            this.m_repBuf.put(m_btnStatus);
            this.m_repBuf.putShort(s);
            this.m_repBuf.putShort(s2);
            this.m_repBuf.put(this.m_wheelrotation);
        }
        int n2 = 0;
        for (int i = 8; i < 40; ++i) {
            n2 = n2 + (this.m_repBuf.get(i) & 0xFF) & 0xFF;
        }
        this.m_repBuf.put(19, -((byte)(n2 & 0xFF)));
        ++SeqNum;
        return this.m_report;
    }

    public byte[] RELreport(KMCrypt kMCrypt) {
        if (kMCrypt != null) {
            this.m_vHdr = new IVTPPktHdr(1, 41, 0);
            this.m_report = new byte[49];
        } else {
            this.m_vHdr = new IVTPPktHdr(1, 37, 0);
            this.m_report = new byte[45];
        }
        int n = 5;
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        if (kMCrypt != null) {
            this.m_vHdr.setSize(41);
            this.m_vHdr.setStatus((short)255);
        } else {
            this.m_vHdr.setSize(37);
            this.m_vHdr.setStatus((short)0);
        }
        try {
            this.m_repBuf.put(this.m_vHdr.array());
            this.m_repBuf.put(this.m_signature);
            this.m_repBuf.put((byte)1);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)32);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.putInt(n);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)49);
            this.m_repBuf.put((byte)32);
            this.m_repBuf.put((byte)-128);
            this.m_repBuf.put((byte)2);
            this.m_repBuf.put((byte)1);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.putInt(SeqNum);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)4);
            if (kMCrypt != null) {
                byte[] byArray = new byte[4];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.put(m_btnStatus);
                byteBuffer.put((byte)this.m_xDisp);
                byteBuffer.put((byte)this.m_yDisp);
                byteBuffer.put(this.m_wheelrotation);
                byte[] byArray2 = kMCrypt.encrypt(byArray);
                if (byArray2 == null) {
                    return this.RELreport(null);
                }
                this.m_repBuf.put(byArray2);
            } else {
                this.m_repBuf.put(m_btnStatus);
                this.m_repBuf.put((byte)this.m_xDisp);
                this.m_repBuf.put((byte)this.m_yDisp);
                this.m_repBuf.put(this.m_wheelrotation);
            }
            int n2 = 0;
            for (int i = 8; i < 40; ++i) {
                n2 = n2 + (this.m_repBuf.get(i) & 0xFF) & 0xFF;
            }
            this.m_repBuf.put(19, -((byte)(n2 & 0xFF)));
            ++SeqNum;
            return this.m_report;
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            return null;
        }
    }

    @Override
    public byte[] report() {
        if (this.m_MouseMode == ABSOLUTE_MOUSE_MODE) {
            return this.ABSreport(null);
        }
        return this.RELreport(null);
    }

    @Override
    public byte[] encryptedReport(KMCrypt kMCrypt) {
        if (this.m_MouseMode == ABSOLUTE_MOUSE_MODE) {
            return this.ABSreport(kMCrypt);
        }
        return this.RELreport(kMCrypt);
    }
}

