/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.videorecord;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.videorecord.DisplayVideoDataTask;
import com.ami.kvm.jviewer.videorecord.VideoFrame;
import com.ami.kvm.jviewer.videorecord.VideoFrameBuffer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JOptionPane;

public class BufferFiller
extends Thread {
    private static final int VIDEO_LENGTH_TAG_SIZE = 4;
    private static final int RESERVED_BYTES_VIDEO_LENGTH = 20;
    private boolean run;
    private VideoFrame videoFrame;
    private FileInputStream fileReader;
    private VideoFrameBuffer videoFrameBuffer;

    public BufferFiller() {
        block9: {
            this.run = false;
            this.videoFrame = null;
            this.fileReader = null;
            this.videoFrameBuffer = null;
            this.setName("BufferFillerThread");
            this.videoFrameBuffer = JViewerApp.getInstance().getVideorecordapp().getVideoFrameBuffer();
            int n = JViewerApp.getInstance().getVideorecordapp().getFileIndex();
            byte[] byArray = new byte[20];
            try {
                this.fileReader = new FileInputStream(JViewerApp.getInstance().getVideorecordapp().getVideotmpstorepath()[n]);
                try {
                    this.fileReader.read(byArray, 0, byArray.length);
                    if (new String(byArray, 0, 4).equals("len=")) {
                        DisplayVideoDataTask.setVideoDuration((int)Double.parseDouble(new String(byArray, 4, byArray.length - 4)));
                        break block9;
                    }
                    this.fileReader.close();
                    this.fileReader = new FileInputStream(JViewerApp.getInstance().getVideorecordapp().getVideotmpstorepath()[n]);
                }
                catch (IOException iOException) {
                    Debug.out.println(iOException);
                    if (this.fileReader != null) {
                        try {
                            this.fileReader.close();
                            this.fileReader = null;
                        }
                        catch (IOException iOException2) {
                            this.fileReader = null;
                            Debug.out.println(iOException);
                        }
                    }
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("AN_1_BF"), LocaleStrings.getString("A_5_GLOBAL"), 0);
                    JViewer.exit(0);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Debug.out.println(fileNotFoundException);
                JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("AN_1_BF"), LocaleStrings.getString("A_5_GLOBAL"), 0);
                JViewer.exit(0);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("AN_1_BF"), LocaleStrings.getString("A_5_GLOBAL"), 0);
                JViewer.exit(0);
            }
        }
        this.run = true;
        this.start();
    }

    @Override
    public void run() {
        while (this.run) {
            int n = 0;
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[1];
            byte[] byArray3 = new byte[3];
            ISOCFrameHdr iSOCFrameHdr = JViewerApp.getSoc_manager().getSOCFramehdr();
            byte[] byArray4 = new byte[iSOCFrameHdr.getFrameHeadersize()];
            byte[] byArray5 = new byte[8];
            try {
                Object object;
                ByteBuffer byteBuffer;
                n = this.fileReader.read(byArray);
                if (n <= 0) {
                    if (this.videoFrame != null && !this.videoFrameBuffer.contains(this.videoFrame)) {
                        this.videoFrameBuffer.put(this.videoFrame);
                    }
                    this.run = false;
                    continue;
                }
                this.videoFrame = new VideoFrame();
                ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
                byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer2.position(0);
                this.videoFrame.setTimeStamp((long)byteBuffer2.getInt() & 0xFFFFFFFFL);
                n = this.fileReader.read(byArray2);
                if (n <= 0) {
                    this.run = false;
                    continue;
                }
                this.videoFrame.setCode(byArray2[0]);
                n = this.fileReader.read(byArray3);
                if (n <= 0) {
                    this.run = false;
                    continue;
                }
                if (byArray2[0] == -86) continue;
                if (byArray2[0] == 102 || byArray2[0] == 170) {
                    this.videoFrameBuffer.put(this.videoFrame);
                    continue;
                }
                if (byArray2[0] == 119) {
                    n = this.fileReader.read(byArray5);
                    if (n <= 0) {
                        this.run = false;
                        continue;
                    }
                    byteBuffer = ByteBuffer.wrap(byArray5);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byteBuffer.position(0);
                    object = new IVTPPktHdr(byteBuffer.getShort(), byteBuffer.getInt(), byteBuffer.getShort());
                    if (((IVTPPktHdr)object).type == 4097) {
                        byte[] byArray6 = new byte[1024];
                        n = this.fileReader.read(byArray6);
                        if (n <= 0) {
                            this.run = false;
                            continue;
                        }
                        this.videoFrame.setPalette(byArray6);
                        byte[] byArray7 = new byte[16];
                        n = this.fileReader.read(byArray7);
                        if (n <= 0) {
                            this.run = false;
                            continue;
                        }
                        this.videoFrame.setAttribute(byArray7);
                    }
                    this.videoFrameBuffer.put(this.videoFrame);
                    continue;
                }
                n = this.fileReader.read(byArray4);
                if (n <= 0) {
                    this.run = false;
                    continue;
                }
                this.videoFrame.setHeader(byArray4);
                byteBuffer = ByteBuffer.wrap(byArray4);
                byteBuffer.clear();
                byteBuffer.position(iSOCFrameHdr.getFrameHeadersize());
                iSOCFrameHdr.setHeader(byteBuffer);
                byteBuffer.position(0);
                object = new byte[iSOCFrameHdr.getFrameSize()];
                n = this.fileReader.read((byte[])object);
                if (n < 0 || n < iSOCFrameHdr.getFrameSize()) {
                    this.run = false;
                    continue;
                }
                this.videoFrame.setFrameData((byte[])object);
                this.videoFrameBuffer.put(this.videoFrame);
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                this.run = false;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                this.run = false;
            }
        }
        try {
            this.fileReader.close();
            this.fileReader = null;
        }
        catch (IOException iOException) {
            this.fileReader = null;
            Debug.out.println(iOException);
        }
    }

    public FileInputStream getFileReader() {
        return this.fileReader;
    }

    public boolean isRunning() {
        return this.run;
    }

    public void stopRunning() {
        this.run = false;
    }
}

