/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.commands;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.CommandInvoker;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.engines.records.EngineRecordStates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class BatchedInvoker
implements CommandInvoker {
    private int invokeCount = 0;
    private int successCount = 0;
    private List<CommandTaskRecords> commandTaskRecords = new ArrayList<CommandTaskRecords>();

    @Override
    public void invoke(AbstractCommandBuilder ... builders) {
        this.invoke(Arrays.asList(builders));
    }

    @Override
    public void invoke(List<AbstractCommandBuilder> builderList) {
        this.successCount = 0;
        this.commandTaskRecords.clear();
        this.invokeCount = builderList.size();
        for (AbstractCommandBuilder commandBuilder : builderList) {
            AbstractCommand command = commandBuilder.build();
            if (!command.checkAll()) {
                try {
                    command.close();
                    this.commandTaskRecords.add(new CommandTaskRecords(command).setStates(EngineRecordStates.Fail));
                }
                catch (Exception e) {
                    command = null;
                }
                continue;
            }
            if (command.execute()) {
                this.commandTaskRecords.add(new CommandTaskRecords(command).setStates(EngineRecordStates.Pass));
                ++this.successCount;
            } else {
                this.commandTaskRecords.add(new CommandTaskRecords(command).setStates(EngineRecordStates.Fail));
            }
            try {
                command.close();
            }
            catch (Exception e) {
                command = null;
            }
        }
    }

    @Override
    public int getTotalCount() {
        return this.invokeCount;
    }

    @Override
    public int getSuccessCount() {
        return this.successCount;
    }

    @Override
    public List<CommandTaskRecords> getCommandTaskRecords() {
        return this.commandTaskRecords;
    }
}

