/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines;

import Gbt.core.engines.AbstractEngineThreadFactory;
import Gbt.core.engines.AbstractMultipleTask;
import Gbt.core.engines.EngineThreadPoolFactory;
import Gbt.core.engines.EngineThreadPoolTypes;
import Gbt.core.engines.records.EngineGroupRecords;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import java.util.Iterator;
import java.util.Map;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractEngineController
implements Observer,
AutoCloseable {
    private volatile ScheduledExecutorService minorPool;
    protected volatile boolean isShutdown = false;
    protected volatile AbstractEngineThreadFactory majorPoolConfig;
    protected volatile ExecutorService majorPool;
    protected volatile AbstractLoggerWriter loggerWriter;
    protected volatile Map<String, AbstractMultipleTask> tasks = new ConcurrentHashMap<String, AbstractMultipleTask>();
    protected volatile Map<String, Future<EngineGroupRecords>> futures = new ConcurrentHashMap<String, Future<EngineGroupRecords>>();
    protected volatile Map<String, EngineGroupRecords> previousRecords = new ConcurrentHashMap<String, EngineGroupRecords>();

    protected AbstractEngineController(AbstractEngineThreadFactory threadPoolFactory) {
        this.loggerWriter = new DefaultLoggerWriter(this.getClass());
        this.majorPoolConfig = threadPoolFactory;
        this.majorPool = this.majorPoolConfig.createThreadPool();
        this.minorPool = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("InnerControl")).setThreadNumber(1)).setPoolType(EngineThreadPoolTypes.SCHEDULED)).setDaemon(false)).setPriority(5)).build().createScheduledThreadPool();
        this.minorPool.scheduleAtFixedRate(new FutureCollector(this), 1000L, 3000L, TimeUnit.MICROSECONDS);
    }

    public synchronized boolean isTaskRunning(String taskID) {
        if (this.futures.containsKey(taskID)) {
            return !this.futures.get(taskID).isDone();
        }
        return false;
    }

    protected <T> T notificationFilter(Object args, Class<T> classType) {
        if (classType.isInstance(args)) {
            return classType.cast(args);
        }
        return null;
    }

    protected void restartTaskPool() {
        if (this.majorPool == null) {
            this.majorPool = this.majorPoolConfig.createThreadPool();
            this.writeLogs(GbtLogLevel.TRACE, this.majorPoolConfig.getPoolName(), "MainEngineRecords", "Restart the thread pool success.");
        }
        if (this.majorPool.isShutdown()) {
            this.majorPool = this.majorPoolConfig.createThreadPool();
            this.writeLogs(GbtLogLevel.TRACE, this.majorPoolConfig.getPoolName(), "MainEngineRecords", "Restart the thread pool success.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLogs(GbtLogLevel level, String engineName, String engineTaskID, String messages) {
        AbstractLoggerWriter abstractLoggerWriter = this.loggerWriter;
        synchronized (abstractLoggerWriter) {
            this.loggerWriter.appendPath(engineName).writeLogs(level, engineTaskID, messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLogs(GbtLogLevel level, String engineName, String engineTaskID, String messages, Throwable exceptions) {
        AbstractLoggerWriter abstractLoggerWriter = this.loggerWriter;
        synchronized (abstractLoggerWriter) {
            this.loggerWriter.appendPath(engineName).writeLogs(level, engineTaskID, messages, exceptions);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.tasks != null) {
            this.tasks.clear();
            this.tasks = null;
        }
        if (this.futures != null) {
            this.futures.clear();
            this.futures = null;
        }
        if (this.previousRecords != null) {
            this.previousRecords.clear();
            this.previousRecords = null;
        }
        if (!this.majorPool.isTerminated()) {
            this.majorPool.shutdown();
            do {
                Thread.sleep(500L);
            } while (!this.majorPool.awaitTermination(1L, TimeUnit.SECONDS));
            this.majorPool = null;
        }
        if (!this.minorPool.isTerminated()) {
            this.minorPool.shutdownNow();
            do {
                Thread.sleep(500L);
            } while (!this.minorPool.awaitTermination(1L, TimeUnit.SECONDS));
            this.minorPool = null;
        }
    }

    private static final class FutureCollector
    implements Runnable {
        private volatile Thread currentThread;
        private volatile AbstractEngineController engineController;

        private FutureCollector(AbstractEngineController engineController) {
            this.engineController = engineController;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.currentThread = Thread.currentThread();
            if (this.engineController.futures.isEmpty()) {
                return;
            }
            Iterator<String> iterator = this.engineController.futures.keySet().iterator();
            while (iterator.hasNext()) {
                String taskID = iterator.next();
                if (this.currentThread.isInterrupted()) {
                    return;
                }
                if (!this.engineController.futures.get(taskID).isDone()) continue;
                try {
                    EngineGroupRecords results = this.engineController.futures.get(taskID).get();
                    if (results.getGroupStates().isFail()) {
                        this.engineController.writeLogs(GbtLogLevel.INFO, taskID, taskID, "[" + taskID + "] Collect the failed future results.");
                        this.engineController.previousRecords.put(taskID, results);
                        continue;
                    }
                    this.engineController.writeLogs(GbtLogLevel.INFO, taskID, taskID, "[" + taskID + "] Skip the passed records.");
                }
                catch (InterruptedException ie) {
                    this.engineController.writeLogs(GbtLogLevel.WARN, taskID, taskID, "[" + taskID + "] Get the interrupted future cache.", ie);
                }
                catch (ExecutionException ee) {
                    this.engineController.writeLogs(GbtLogLevel.ERROR, taskID, taskID, "[" + taskID + "] Get the execution error future cache.", ee);
                }
                finally {
                    this.engineController.writeLogs(GbtLogLevel.INFO, taskID, taskID, "[" + taskID + "] Remove future caches.");
                    this.engineController.futures.remove(taskID);
                    iterator.remove();
                }
            }
        }
    }
}

