/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines.records;

public enum EngineRecordStates {
    Pass(0, "Success"),
    Fail(1, "Fail"),
    Running(2, "Running"),
    Lock(3, "Lock");

    private static final int PASS_CODE = 0;
    private static final int FAIL_CODE = 1;
    private static final int RUNNING_CODE = 2;
    private static final int LOCK_CODE = 3;
    private static final String PASS_ITEM = "Success";
    private static final String FAIL_ITEM = "Fail";
    private static final String RUNNING_ITEM = "Running";
    private static final String LOCK_ITEM = "Lock";
    private final int code;
    private final String item;

    private EngineRecordStates(int code, String item) {
        this.code = code;
        this.item = item;
    }

    public final int getCode() {
        return this.code;
    }

    public String toString() {
        return this.item;
    }

    public final boolean isPass() {
        switch (this) {
            case Pass: {
                return true;
            }
        }
        return false;
    }

    public final boolean isFail() {
        switch (this) {
            case Fail: {
                return true;
            }
        }
        return false;
    }

    public final boolean isRunning() {
        switch (this) {
            case Running: {
                return true;
            }
        }
        return false;
    }

    public final boolean isLock() {
        switch (this) {
            case Lock: {
                return true;
            }
        }
        return false;
    }
}

