/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers.async;

import Gbt.core.engines.AbstractSingleTask;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.SSHCmdRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtSSHCommandReceiver;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CancellationException;

public final class AsyncSshExecuteCmdTask
extends AbstractSingleTask {
    private final Session session;
    private final String reqCmd;
    private int timeout;
    private final boolean redirection;
    private final String logFolderName;
    private final SSHCmdRecords records;

    protected AsyncSshExecuteCmdTask(Builder builder) {
        super(builder);
        this.session = builder.session;
        this.reqCmd = builder.reqCmd;
        this.timeout = builder.timeout;
        this.redirection = builder.redirection;
        this.logFolderName = builder.logFolderName;
        this.records = new SSHCmdRecords(this.taskID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSHCmdRecords call() throws CancellationException {
        SSHCmdRecords sSHCmdRecords;
        String command;
        this.currentThread = Thread.currentThread();
        String string = command = this.redirection && !this.reqCmd.endsWith("2>&1") ? this.reqCmd + " 2>&1" : this.reqCmd;
        if (this.session == null) {
            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.ERROR, this.taskID, "The given session instance is null.");
            return this.records.setStates(EngineRecordStates.Fail).addErrors("The given session instance is null.");
        }
        if (!this.session.isConnected()) {
            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.ERROR, this.taskID, "[" + this.session.getHost() + "] SSH session is not connected.");
            return this.records.setStates(EngineRecordStates.Fail).addErrors("[" + this.session.getHost() + "] SSH session is not connected.");
        }
        byte[] bytesBuffer = new byte[512];
        StringBuilder resultBuffer = new StringBuilder();
        StringBuilder errorBuffer = new StringBuilder();
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setErrStream((OutputStream)System.err);
            channel.setPty(true);
            channel.setCommand(command);
            OutputStream writeStream = channel.getOutputStream();
            InputStream readStream = channel.getInputStream();
            InputStream errorStream = channel.getErrStream();
            channel.connect(this.timeout);
            writeStream.flush();
            block18: while (!this.currentThread.isInterrupted() && !channel.isClosed()) {
                int i;
                while (readStream.available() > 0 && (i = readStream.read(bytesBuffer, 0, bytesBuffer.length)) >= 0) {
                    resultBuffer.append(new String(bytesBuffer, 0, i));
                    if (resultBuffer.length() > 0) {
                        for (String line : resultBuffer.toString().split("[\\r\\n]+")) {
                            this.records.addMessages(line);
                            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.DEBUG, this.taskID, line);
                        }
                        resultBuffer.setLength(0);
                    }
                    if (!this.currentThread.isInterrupted()) continue;
                    channel.disconnect();
                    this.closeSession();
                    this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH connection while reading response.");
                    if (i < 0) {
                        if (writeStream != null) {
                            writeStream.close();
                            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH request write stream.");
                        }
                        if (readStream == null) break;
                        readStream.close();
                        this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH normal response read stream.");
                        break;
                    }
                    writeStream.write(3);
                    writeStream.flush();
                }
                while (errorStream.available() > 0 && (i = errorStream.read(bytesBuffer, 0, bytesBuffer.length)) >= 0) {
                    errorBuffer.append(new String(bytesBuffer, 0, i));
                    if (errorBuffer.length() > 0) {
                        for (String lines : errorBuffer.toString().split("[\\r\\n]+")) {
                            this.records.addErrors(lines);
                            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.ERROR, this.taskID, lines);
                        }
                        errorBuffer.setLength(0);
                    }
                    if (!this.currentThread.isInterrupted()) continue;
                    channel.disconnect();
                    this.closeSession();
                    this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH connection while reading error response.");
                    if (i < 0) {
                        if (writeStream != null) {
                            writeStream.close();
                            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH request write stream.");
                        }
                        if (errorStream == null) continue block18;
                        errorStream.close();
                        this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH error response read stream.");
                        continue block18;
                    }
                    writeStream.write(3);
                    writeStream.flush();
                }
            }
            if (this.currentThread.isInterrupted()) {
                if (writeStream != null) {
                    writeStream.close();
                    this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH request write stream.");
                }
                if (readStream != null) {
                    readStream.close();
                    this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH normal response read stream.");
                }
                if (errorStream != null) {
                    errorStream.close();
                    this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "[" + this.session.getHost() + "] Interrupted SSH error response read stream.");
                }
                channel.disconnect();
                this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.DEBUG, this.taskID, "[" + this.session.getHost() + "] SSH channel disconnected.");
                this.closeSession();
                SSHCmdRecords sSHCmdRecords2 = this.records.setStates(EngineRecordStates.Fail);
                return sSHCmdRecords2;
            }
            channel.disconnect();
            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.DEBUG, this.taskID, "[" + this.session.getHost() + "] SSH channel disconnected.");
            SSHCmdRecords sSHCmdRecords3 = this.records.setStates(this.records.containsError() ? EngineRecordStates.Fail : EngineRecordStates.Pass);
            return sSHCmdRecords3;
        }
        catch (JSchException je) {
            channel.disconnect();
            this.closeSession();
            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.ERROR, this.taskID, "[" + this.session.getHost() + "] SSH channel open fail.", je);
            sSHCmdRecords = this.records.setStates(EngineRecordStates.Fail).addErrors("[" + this.session.getHost() + "] SSH channel open fail : " + je.getMessage());
            return sSHCmdRecords;
        }
        catch (IOException ioe) {
            channel.disconnect();
            this.closeSession();
            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.ERROR, this.taskID, "[" + this.session.getHost() + "] SSH channel I/O exceptions.", ioe);
            sSHCmdRecords = this.records.setStates(EngineRecordStates.Fail).addErrors("[" + this.session.getHost() + "] SSH channel I/O exceptions : " + ioe.getMessage());
            return sSHCmdRecords;
        }
        finally {
            try {
                this.close();
            }
            catch (Exception e) {
                this.loggerWriter = null;
            }
        }
    }

    @Override
    public synchronized void cancelConsideration() {
        this.currentThread.interrupt();
        this.closeSession();
        this.records.setStates(EngineRecordStates.Fail);
    }

    @Override
    public synchronized SSHCmdRecords getResult() {
        return this.records;
    }

    @Override
    public void close() throws Exception {
        this.loggerWriter.close();
    }

    private void closeSession() {
        if (this.session == null) {
            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.WARN, this.taskID, "The given session is null.");
            return;
        }
        if (this.session.isConnected()) {
            this.loggerWriter.appendPath(this.logFolderName).writeLogs(GbtLogLevel.DEBUG, this.taskID, "[" + this.session.getHost() + "] SSH session disconnected.");
            this.session.disconnect();
        }
    }

    public static final class Builder
    extends AbstractSingleTask.TaskBuilder<Builder> {
        private Session session;
        private String reqCmd;
        private int timeout = 5000;
        private boolean redirection = false;
        private String logFolderName = GbtSSHCommandReceiver.getInstance().getReceiverName();

        @Override
        protected Builder getThis() {
            return this;
        }

        public AsyncSshExecuteCmdTask build() {
            return new AsyncSshExecuteCmdTask(this);
        }

        public Builder setSession(Session session) {
            this.session = session;
            return this.getThis();
        }

        public Builder setReqCmd(String reqCmd) {
            this.reqCmd = reqCmd;
            return this.getThis();
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this.getThis();
        }

        public Builder setRedirection(boolean redirection) {
            this.redirection = redirection;
            return this.getThis();
        }

        public Builder setLogFolderName(String logFolderName) {
            this.logFolderName = logFolderName;
            return this.getThis();
        }
    }
}

