/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.isocaching;

import Gbt.core.vmedia.isocaching.CacheManager;
import Gbt.core.vmedia.isocaching.ISOReader;
import Gbt.core.vmedia.isocaching.RequestHandler;
import Gbt.core.vmedia.isocaching.SectorBank;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.util.LinkedList;

public class ReadAheadCache
extends Thread {
    public static final int MAX_CACHE_SIZE = 256;
    public static final int MAX_BANK_SIZE = 64;
    private LinkedList<SectorBank> sectorDataCache = null;
    private RequestHandler requestHandler = null;
    private CacheManager cacheManager = null;
    private ISOReader isoReader = null;
    private RandomAccessFile imageFile = null;
    private boolean running = false;
    private boolean cacheLocked = false;
    private boolean fileReadWait = false;
    private byte[] sectorData = null;
    private final Object cacheSync = new Object();
    private final Object readSync = new Object();
    private final Object cacheLock = new Object();
    private final Object fileLock = new Object();
    private final Object reqSync = new Object();
    private int numSectors;
    private long startingSector;

    public ReadAheadCache(RandomAccessFile imageFile) {
        this.imageFile = imageFile;
        if (this.getSectorDataCache() == null) {
            this.setSectorDataCache(new LinkedList<SectorBank>());
        }
        if (this.requestHandler == null) {
            this.requestHandler = new RequestHandler(this);
            this.requestHandler.startThread();
            this.requestHandler.setName("RequestHandler");
        }
        if (this.cacheManager == null) {
            this.cacheManager = new CacheManager(this);
            this.cacheManager.startThread();
            this.cacheManager.setName("CacheManager");
        }
        this.isoReader = new ISOReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            Object object = this.cacheSync;
            synchronized (object) {
                try {
                    this.sectorData = this.readSectorData();
                    Object object2 = this.readSync;
                    synchronized (object2) {
                        this.readSync.notifyAll();
                    }
                    this.cacheSync.wait();
                }
                catch (InterruptedException e) {
                    e.getMessage();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readSectorData() {
        byte[] data = null;
        int dataBufferSize = 2048 * this.numSectors;
        long sectorKey = this.getSectorKey(this.startingSector);
        int offset = (int)(2048L * (this.startingSector - sectorKey));
        byte[] availableBuffer = null;
        byte[] remainingBuffer = null;
        if (sectorKey >= 0L) {
            if (!this.isCacheLocked()) {
                SectorBank sectorBank;
                block29: {
                    sectorBank = this.getSectorBank(sectorKey);
                    data = new byte[dataBufferSize];
                    if (this.startingSector + (long)this.numSectors > sectorKey + 64L) {
                        int excess = (int)(this.startingSector + (long)this.numSectors - (sectorKey + 64L));
                        int available = (int)(sectorKey + 64L - this.startingSector);
                        long startRemaining = this.startingSector + (long)available;
                        int availableBufferSize = 2048 * available;
                        int remainingBufferSize = 2048 * excess;
                        byte[] dataBuffer = sectorBank.getSectorData();
                        availableBuffer = new byte[availableBufferSize];
                        remainingBuffer = new byte[remainingBufferSize];
                        if (dataBuffer != null) {
                            if (dataBuffer.length >= offset + availableBuffer.length) {
                                System.arraycopy(dataBuffer, offset, availableBuffer, 0, availableBuffer.length);
                                this.rearrangeSectorBank(sectorBank);
                            } else {
                                availableBuffer = null;
                            }
                        }
                        if ((sectorKey = this.getSectorKey(startRemaining)) >= 0L) {
                            offset = (int)(2048L * (startRemaining - sectorKey));
                            try {
                                sectorBank = this.getSectorBank(sectorKey);
                                byte[] remainingDataBuffer = this.getSectorBank(sectorKey).getSectorData();
                                if (remainingDataBuffer.length >= offset + remainingBuffer.length) {
                                    System.arraycopy(remainingDataBuffer, offset, remainingBuffer, 0, remainingBuffer.length);
                                    this.rearrangeSectorBank(sectorBank);
                                    break block29;
                                }
                                remainingBuffer = null;
                            }
                            catch (NullPointerException | BufferUnderflowException npe) {
                                remainingBuffer = null;
                            }
                        } else {
                            remainingBuffer = null;
                        }
                    }
                }
                if (availableBuffer != null && remainingBuffer != null) {
                    System.arraycopy(availableBuffer, 0, data, 0, availableBuffer.length);
                    System.arraycopy(remainingBuffer, 0, data, availableBuffer.length, remainingBuffer.length);
                } else {
                    sectorKey = this.getSectorKey(this.startingSector);
                    if (sectorKey >= 0L) {
                        byte[] dataBuffer = null;
                        try {
                            sectorBank = this.getSectorBank(sectorKey);
                            dataBuffer = sectorBank.getSectorData();
                        }
                        catch (NullPointerException npe) {
                            dataBuffer = null;
                            System.out.println(npe);
                        }
                        if (dataBuffer != null) {
                            if (dataBuffer.length >= offset + dataBufferSize) {
                                try {
                                    System.arraycopy(dataBuffer, offset, data, 0, dataBufferSize);
                                    this.rearrangeSectorBank(sectorBank);
                                }
                                catch (Exception ae) {
                                    data = null;
                                }
                            } else {
                                data = null;
                            }
                        } else {
                            data = null;
                        }
                    }
                }
            } else {
                data = null;
            }
        }
        if (data == null) {
            try {
                this.getRequestHandler().setMissingBankInfo(this.startingSector / 64L * 64L);
                this.getRequestHandler().setSectorMiss(true);
                data = new byte[dataBufferSize];
                data = this.readFromFile(this.startingSector, this.numSectors);
            }
            catch (IOException e) {
                data = null;
                System.out.println(e);
            }
            Object object = this.getReqSync();
            synchronized (object) {
                this.getReqSync().notifyAll();
            }
        }
        return data;
    }

    public byte[] getSectorData() {
        return this.sectorData;
    }

    private long getSectorKey(long startingSector) {
        long sectorKey = startingSector / 64L * 64L;
        if (this.getSectorBank(sectorKey) == null) {
            sectorKey = -1L;
        }
        return sectorKey;
    }

    public boolean addToCache(byte[] sectorData, long startingSector) {
        boolean status = false;
        if (this.getSectorDataCache().size() <= 256 && this.getSectorBank(startingSector) == null) {
            SectorBank sectorBank = new SectorBank();
            sectorBank.setSectorKey(startingSector);
            sectorBank.setSectorData(sectorData);
            this.getSectorDataCache().addFirst(sectorBank);
            status = true;
        }
        return status;
    }

    public SectorBank getSectorBank(long sectorKey) {
        SectorBank sectorBank = null;
        try {
            for (int index = 0; index < this.getSectorDataCache().size(); ++index) {
                SectorBank temp = this.getSectorDataCache().get(index);
                if (temp.getSectorKey() != sectorKey) continue;
                sectorBank = temp;
                break;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            sectorBank = null;
        }
        return sectorBank;
    }

    public void rearrangeSectorBank(SectorBank sectorBank) {
        int sectorBankIndex;
        if (sectorBank != null && (sectorBankIndex = this.getSectorDataCache().indexOf(sectorBank)) >= 0 && sectorBankIndex < this.getSectorDataCache().size()) {
            try {
                SectorBank element = this.getSectorDataCache().remove(sectorBankIndex);
                this.getSectorDataCache().addFirst(element);
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromFile(long startingSector, int numSectors) throws IOException {
        byte[] sectorData = new byte[2048 * numSectors];
        if (this.imageFile != null) {
            this.fileReadWait = true;
            Object object = this.fileLock;
            synchronized (object) {
                if (this.isoReader == null) {
                    this.isoReader = new ISOReader();
                }
                sectorData = this.isoReader.readSectorData(this.imageFile, startingSector, numSectors);
                this.fileReadWait = false;
                this.fileLock.notifyAll();
            }
        }
        return sectorData;
    }

    public LinkedList<SectorBank> getSectorDataCache() {
        return this.sectorDataCache;
    }

    public void setSectorDataCache(LinkedList<SectorBank> sectorDataCache) {
        this.sectorDataCache = sectorDataCache;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void startThread() {
        this.running = true;
        this.start();
    }

    public void stopThread() {
        this.running = false;
    }

    public Object getCacheSync() {
        return this.cacheSync;
    }

    public Object getReadSync() {
        return this.readSync;
    }

    public void setSectorRequest(long startingSector, int numSectors) {
        this.startingSector = startingSector;
        this.numSectors = numSectors;
    }

    public boolean isCacheLocked() {
        return this.cacheLocked;
    }

    public void setCacheLocked(boolean cacheLocked) {
        this.cacheLocked = cacheLocked;
    }

    public Object getCacheLock() {
        return this.cacheLock;
    }

    public Object getFileLock() {
        return this.fileLock;
    }

    public boolean isFileReadWait() {
        return this.fileReadWait;
    }

    public Object getReqSync() {
        return this.reqSync;
    }
}

