/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.redirection;

import Gbt.core.vmedia.data.KvmSessionToken;
import Gbt.core.vmedia.isocaching.CDImage;
import Gbt.core.vmedia.protocol.CdromProtocol;
import Gbt.core.vmedia.protocol.IUSBHeader;
import Gbt.core.vmedia.protocol.IUSBSCSI;
import Gbt.core.vmedia.protocol.PacketMaster;
import Gbt.core.vmedia.protocol.VmRedirectionException;
import Gbt.core.vmedia.protocol.VmRedirectionProtocolException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.ws.rs.client.Client;

public final class CdromIsoRedirection
extends Thread {
    private PacketMaster packetMaster;
    private CdromProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean physicalDrive;
    private int CDDevice_no;
    private boolean running = false;
    private boolean stopRunning = false;
    private Thread redirThread;
    private File sourceFilePath;
    private int nBytesRedirected = 0;
    private boolean cdReconnect = false;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    private static final int AUTH_CMD = 242;
    private static final int MAX_READ_SECTORS = 64;
    private static final int MAX_READ_SIZE = 131072;
    private static final int MAX_READ_DATA_SIZE = 1024;
    private static final int SCSI_GET_STATUS_COUNT_SEC = 50;
    private boolean cdImageEjected = false;
    private boolean cdServiceRestarted = false;
    private boolean cdImageRedirected = false;
    private int cdInstanceNum;
    private String errorMessage = "";
    private static Object syncObj = new Object();
    private boolean confModified = false;
    private boolean cdRedirectionKilled = false;
    private CDImage newCDImage = null;
    private boolean cdStoppedByUser = false;
    private int cdromRedirStatus;
    private int cdROMDeviceStatus;
    private int cdStopMode;
    private boolean command_sent = false;
    private boolean Get_notification_scsi_support = false;
    private int Get_notification_scsi_counter = 0;

    public CdromIsoRedirection(boolean physicalDrive) {
        this.physicalDrive = physicalDrive;
        this.cdromRedirStatus = 0;
        this.cdROMDeviceStatus = 1;
        this.cdStopMode = 0;
        this.protocol = new CdromProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(1024);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131134);
    }

    private int cdromConnect(Client client, KvmSessionToken kvmSessionToken, String host, int port) throws IOException {
        this.packetMaster = new PacketMaster(host, port, this.protocol);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        if (this.packetMaster.connectVmedia(client, kvmSessionToken) < 0) {
            this.packetMaster.vmediaSockclose();
            return -1;
        }
        return 0;
    }

    private void cdromDisconnect() {
        try {
            this.packetMaster.vmediaSockclose();
        }
        catch (IOException e) {
            System.err.println("4_6_CDROMREDIR");
        }
    }

    public boolean startRedirection(Client client, KvmSessionToken kvmSessionToken, String host, File sourceFilePath, int port, int cddevice_no) throws VmRedirectionException {
        block15: {
            if (this.running) {
                return true;
            }
            this.CDDevice_no = cddevice_no;
            try {
                if (this.cdromConnect(client, kvmSessionToken, host, port) < 0) {
                    return false;
                }
                this.sendKvmSessionToken(kvmSessionToken);
                IUSBSCSI.SendMediaInfo(this.packetMaster, this.packetWriteBuffer, sourceFilePath.getAbsolutePath());
                this.packetMaster.setSocketTimeout();
                IUSBSCSI request = (IUSBSCSI)this.packetMaster.receivePacket();
                this.cdInstanceNum = request.instanceNum;
                if (request.opcode == 241) {
                    if (request.connectionStatus == 5) {
                        this.cdromDisconnect();
                        this.setErrorMessage("4_17_CDROMREDIR");
                        return false;
                    }
                    if (request.connectionStatus == 8) {
                        this.cdromDisconnect();
                        this.setErrorMessage("4_18_CDROMREDIR");
                        return false;
                    }
                    if (request.connectionStatus == 13) {
                        this.cdromDisconnect();
                        this.setErrorMessage("F_136_JVM");
                        return false;
                    }
                    if (request.connectionStatus != 1) {
                        if (request.connectionStatus == 3) {
                            this.stopRedirection();
                            this.setErrorMessage("6_52_IUSBREDIR");
                        } else if (request.m_otherIP != null) {
                            this.cdromDisconnect();
                            if (request.m_otherIP.equalsIgnoreCase("127.0.0.1") || request.m_otherIP.equalsIgnoreCase("::1")) {
                                this.setErrorMessage("4_19_CDROMREDIR");
                            } else {
                                this.setErrorMessage("4_7_CDROMREDIR" + request.m_otherIP);
                            }
                        }
                        return false;
                    }
                    break block15;
                }
                this.cdromDisconnect();
                throw new VmRedirectionProtocolException("4_8_CDROMREDIR" + request.opcode);
            }
            catch (IOException e) {
                throw new VmRedirectionException(e.getMessage());
            }
        }
        this.sourceFilePath = sourceFilePath;
        this.newCDImage = new CDImage(sourceFilePath);
        if (!this.newCDImage.isOpened()) {
            this.setErrorMessage("6_9_IUSBREDIR");
            this.cdromDisconnect();
            return false;
        }
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        this.cdromRedirStatus = 1;
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (!this.isPhysicalDevice() && this.newCDImage != null) {
            this.newCDImage.closeImage();
            this.newCDImage = null;
        }
        if (this.running) {
            if (this.Get_notification_scsi_support) {
                this.command_sent = true;
                do {
                    try {
                        CdromIsoRedirection.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.getCause().getMessage();
                    }
                    if (this.Get_notification_scsi_counter > 50) {
                        this.command_sent = false;
                        this.Get_notification_scsi_counter = 0;
                    }
                    ++this.Get_notification_scsi_counter;
                } while (this.command_sent);
                this.Get_notification_scsi_support = false;
            }
            try {
                if (!this.isCdServiceRestarted()) {
                    IUSBSCSI.sendCommandToMediaServer(this.packetMaster, this.packetWriteBuffer, null, 247);
                }
            }
            catch (Exception e) {
                System.out.println("Sending MEDIA_SESSION_DISCONNECT command to media server failed : " + e);
            }
            this.stopRunning = true;
            this.cdromDisconnect();
            try {
                this.redirThread.join();
            }
            catch (InterruptedException e) {
                System.err.println("4_14_CDROMREDIR");
            }
            this.running = false;
            this.stopRunning = false;
        }
        this.nBytesRedirected = 0;
        this.cdromRedirStatus = 0;
        return true;
    }

    public boolean isRedirActive() {
        return this.running;
    }

    private void stopRedirectionAbnormal() {
        if (this.running) {
            if (this.Get_notification_scsi_support) {
                this.command_sent = true;
                do {
                    try {
                        CdromIsoRedirection.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.getCause().getMessage();
                    }
                    if (this.Get_notification_scsi_counter > 50) {
                        this.command_sent = false;
                        this.Get_notification_scsi_counter = 0;
                    }
                    ++this.Get_notification_scsi_counter;
                } while (this.command_sent);
                this.Get_notification_scsi_support = false;
            }
            if (!this.isPhysicalDevice() && this.newCDImage != null) {
                this.newCDImage.closeImage();
                this.newCDImage = null;
            }
            this.stopRunning = true;
            this.cdromDisconnect();
            this.running = false;
            this.stopRunning = false;
        }
        this.cdromRedirStatus = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int nTempLen = 0;
        int dataLen = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI request = (IUSBSCSI)this.packetMaster.receivePacket();
                if (request == null) continue;
                if (request.opcode == 243) {
                    IUSBSCSI.sendCommandToMediaServer(this.packetMaster, this.packetWriteBuffer, null, 243);
                    continue;
                }
                this.newCDImage.executeSCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                dataLen = this.newCDImage.getDataLength() + 61;
                if (dataLen >= 0 && dataLen <= this.packetWriteBuffer.capacity()) {
                    this.packetWriteBuffer.limit(dataLen);
                }
                this.packetWriteBuffer.position(0);
                if (request.opcode == 246) {
                    this.cdRedirectionKilled = true;
                    return;
                }
                if (request.opcode == 247) {
                    this.cdServiceRestarted = true;
                    return;
                }
                IUSBSCSI response = new IUSBSCSI(this.packetWriteBuffer, true);
                if (request.opcode == 74 && response.dataLen == 37) {
                    this.Get_notification_scsi_support = true;
                }
                if (this.command_sent && request.opcode == 74 && response.dataLen == 37) {
                    response.data.put(34, (byte)0);
                    response.data.put(33, (byte)1);
                    response.data.put(36, (byte)0);
                }
                this.packetMaster.sendPacket(response);
                this.nBytesRedirected += (nTempLen += dataLen) / 1024;
                nTempLen %= 1024;
                if (this.command_sent && request.opcode == 74 && response.dataLen == 37) {
                    this.command_sent = false;
                }
                if (request.opcode != 27 || request.Lba != 2) continue;
                this.cdImageEjected = true;
            }
            catch (Exception e) {
                if (this.stopRunning) continue;
                Object object = CdromIsoRedirection.getSyncObj();
                synchronized (object) {
                    try {
                        if (!this.confModified) {
                            CdromIsoRedirection.getSyncObj().wait(10000L);
                            if (this.cdStoppedByUser) {
                                return;
                            }
                        }
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (!this.confModified) {
                    this.setCdStopMode(5);
                } else {
                    this.confModified = false;
                }
                this.Get_notification_scsi_support = false;
                this.stopRedirectionAbnormal();
                return;
            }
        }
        System.out.println("Exiting the CDROM/ISO Redirection thread");
    }

    public File getSourceDrive() {
        return this.sourceFilePath;
    }

    public boolean isPhysicalDevice() {
        return this.physicalDrive;
    }

    private void sendKvmSessionToken(KvmSessionToken kvmSessionToken) throws VmRedirectionException, IOException {
        int dataLen = 128;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(160);
        IUSBHeader AuthPktIUSBHeader = new IUSBHeader(dataLen);
        AuthPktIUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(kvmSessionToken.getKvmToken().getBytes());
        this.packetWriteBuffer.position(23);
        this.packetWriteBuffer.put((byte)this.CDDevice_no);
        this.packetWriteBuffer.position(0);
        IUSBSCSI pkt = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(pkt);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    public static Object getSyncObj() {
        return syncObj;
    }

    public boolean isConfModified() {
        return this.confModified;
    }

    public void setConfModified(boolean confModified) {
        this.confModified = confModified;
    }

    public int getCdInstanceNum() {
        return this.cdInstanceNum;
    }

    public boolean isCdImageRedirected() {
        return this.cdImageRedirected;
    }

    public void setCdImageRedirected(boolean cdImageRedirected) {
        this.cdImageRedirected = cdImageRedirected;
    }

    public boolean isCdImageEjected() {
        return this.cdImageEjected;
    }

    public boolean isCdRedirectionKilled() {
        return this.cdRedirectionKilled;
    }

    public void setCdReconnect(boolean cdReconnect) {
        this.cdReconnect = cdReconnect;
    }

    public boolean getCdReconnect() {
        return this.cdReconnect;
    }

    public boolean isCdStoppedByUser() {
        return this.cdStoppedByUser;
    }

    public void setCdStoppedByUser(boolean cdStoppedByUser) {
        this.cdStoppedByUser = cdStoppedByUser;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setCdRedirectionKilled(boolean cdRedirectionKilled) {
        this.cdRedirectionKilled = cdRedirectionKilled;
    }

    public int getCdromRedirStatus() {
        return this.cdromRedirStatus;
    }

    public void setCdromRedirStatus(int cdromRedirStatus) {
        this.cdromRedirStatus = cdromRedirStatus;
    }

    public int getCdROMDeviceStatus() {
        return this.cdROMDeviceStatus;
    }

    public void setCdROMDeviceStatus(int cdROMDeviceStatus) {
        this.cdROMDeviceStatus = cdROMDeviceStatus;
    }

    public int getCdStopMode() {
        return this.cdStopMode;
    }

    public void setCdStopMode(int cdStopMode) {
        this.cdStopMode = cdStopMode;
    }

    public boolean isCdServiceRestarted() {
        return this.cdServiceRestarted;
    }
}

