/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FilenameUtils;

public final class CompressFile {
    private CompressFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File compressZIPFile(String resourcesDir, String outputDir, boolean override) {
        File outputZIPFile;
        File resourcesFile = new File(resourcesDir);
        if (!resourcesFile.exists()) {
            return null;
        }
        if (!resourcesFile.isDirectory()) {
            return null;
        }
        File targetFile = new File(outputDir);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        if ((outputZIPFile = new File(targetFile.getAbsolutePath() + "/" + resourcesFile.getName() + ".zip")).exists() && !override) {
            System.out.println(outputZIPFile.getAbsolutePath() + " already exist and not override it.");
            return outputZIPFile;
        }
        FileOutputStream outputStream = null;
        ZipOutputStream outputZip = null;
        try {
            outputStream = new FileOutputStream(outputZIPFile);
            outputZip = new ZipOutputStream(new BufferedOutputStream(outputStream));
            if (!CompressFile.createCompressedZIPFile(outputZip, resourcesFile, "")) {
                File file = null;
                return file;
            }
            File file = outputZIPFile;
            return file;
        }
        catch (FileNotFoundException e) {
            System.out.println(targetFile.getAbsolutePath() + "/" + outputZIPFile.getParentFile().getAbsolutePath() + " not found.");
            File file = null;
            return file;
        }
        finally {
            try {
                outputZip.close();
                outputStream.close();
            }
            catch (IOException e) {
                System.out.println("Resources close error.");
            }
        }
    }

    public static final File compressTarFile(List<File> srcFileList, String outputTarName, boolean override) throws Exception {
        File outputTarFile;
        if (outputTarName == null) {
            throw new FileNotFoundException("Output file name is null");
        }
        if (!outputTarName.endsWith(".tar")) {
            outputTarName = outputTarName + ".tar";
        }
        if ((outputTarFile = new File(outputTarName)).exists() && !override) {
            return outputTarFile;
        }
        FileOutputStream tar_output = new FileOutputStream(outputTarFile);
        ArchiveOutputStream my_tar_ball = new ArchiveStreamFactory().createArchiveOutputStream("tar", tar_output);
        for (File filename : srcFileList) {
            if (!filename.exists()) continue;
            TarArchiveEntry tar_file = new TarArchiveEntry(filename.getName());
            tar_file.setSize(filename.length());
            my_tar_ball.putArchiveEntry(tar_file);
            IOUtils.copy(new FileInputStream(filename), my_tar_ball);
            my_tar_ball.closeArchiveEntry();
        }
        my_tar_ball.finish();
        ((OutputStream)tar_output).close();
        return outputTarFile;
    }

    public static final File compressTarGzFile(List<File> srcFileNames, String outputTarName, boolean override) throws Exception {
        File tarName = CompressFile.compressTarFile(srcFileNames, outputTarName, override);
        File output = new File(tarName.getAbsolutePath() + ".gz");
        if (output.exists() && !override) {
            return output;
        }
        if (!CompressFile.compressGzipFile(tarName.getAbsolutePath(), output.getAbsolutePath())) {
            return null;
        }
        return output;
    }

    public static final boolean compressGzipFile(String srcfile, String dstGzipFile) {
        try {
            int len;
            System.out.println("[LoadDefaultThread] Input: " + srcfile);
            System.out.println("[LoadDefaultThread] GzipFIle: " + dstGzipFile);
            FileInputStream fis = new FileInputStream(srcfile);
            FileOutputStream fos = new FileOutputStream(dstGzipFile);
            GZIPOutputStream gzipOS = new GZIPOutputStream(fos);
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                gzipOS.write(buffer, 0, len);
            }
            gzipOS.close();
            fos.close();
            fis.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("[LoadDefaultThread] Compress " + dstGzipFile + " failed.");
            return false;
        }
    }

    public static final boolean compressGzipFile(File srcfile, File dstGzipFile) {
        try {
            int len;
            System.out.println("Source file path : " + srcfile.getAbsolutePath());
            System.out.println("Output file path : " + dstGzipFile.getAbsolutePath());
            FileInputStream fis = new FileInputStream(srcfile);
            FileOutputStream fos = new FileOutputStream(dstGzipFile);
            GZIPOutputStream gzipOS = new GZIPOutputStream(fos);
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                gzipOS.write(buffer, 0, len);
            }
            gzipOS.close();
            fos.close();
            fis.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Compress GZ " + dstGzipFile + " failed.");
            return false;
        }
    }

    public static final File compressGzipFile(File srcfile) throws IOException {
        String dstGzipFile = FilenameUtils.removeExtension((String)srcfile.getAbsolutePath()) + ".gz";
        byte[] buffer = new byte[1024];
        try (FileInputStream fileInputStream = new FileInputStream(srcfile);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(new FileOutputStream(dstGzipFile));){
            int len;
            while ((len = fileInputStream.read(buffer)) != -1) {
                gzipOutputStream.write(buffer, 0, len);
            }
        }
        return new File(dstGzipFile);
    }

    private static final boolean createCompressedZIPFile(ZipOutputStream out, File file, String dir) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            dir = dir.length() == 0 ? "" : dir + "/";
            for (File file1 : files) {
                CompressFile.createCompressedZIPFile(out, file1, dir + file1.getName());
            }
        } else {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(dir));
                int j = 0;
                byte[] buffer = new byte[1024];
                while ((j = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, j);
                }
                fis.close();
            }
            catch (FileNotFoundException e) {
                System.out.println(file.getAbsolutePath() + " not found.");
                return false;
            }
            catch (IOException e) {
                System.out.println("I/O read errors.");
                return false;
            }
        }
        return true;
    }
}

