/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import Gbt.utility.Common.ZipUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;

public final class UncompressFile {
    private UncompressFile() {
    }

    public static final synchronized boolean deCompressedFile(String resourcesPath) {
        File check = new File(FilenameUtils.removeExtension((String)resourcesPath));
        if (check.exists()) {
            check = null;
            return true;
        }
        check = null;
        if (resourcesPath.toLowerCase().indexOf("zip") > 0) {
            return ZipUtils.decompress(resourcesPath);
        }
        if (resourcesPath.toLowerCase().indexOf("tgz") > 0) {
            File f = UncompressFile.deCompressTGZFile(resourcesPath);
            if (f == null) {
                return false;
            }
            String subDirName = FilenameUtils.removeExtension((String)new File(resourcesPath).getName());
            return UncompressFile.deCompressTARFile(f, subDirName);
        }
        System.out.println("No valid decompress function.");
        return false;
    }

    public static final synchronized boolean deCompressedFile(String resourcesPath, boolean notCreateSubDir) {
        File check = new File(FilenameUtils.removeExtension((String)resourcesPath));
        if (check.exists()) {
            check = null;
            return true;
        }
        check = null;
        if (resourcesPath.toLowerCase().indexOf("zip") > 0) {
            return ZipUtils.decompress(resourcesPath, notCreateSubDir);
        }
        if (resourcesPath.toLowerCase().indexOf("tgz") > 0) {
            File f = UncompressFile.deCompressTGZFile(resourcesPath);
            if (f == null) {
                return false;
            }
            String subDirName = FilenameUtils.removeExtension((String)new File(resourcesPath).getName());
            return UncompressFile.deCompressTARFile(f, subDirName);
        }
        System.out.println("No valid decompress function.");
        return false;
    }

    public static final synchronized boolean deCompressedFile(File resourcesPath) {
        File check = new File(FilenameUtils.removeExtension((String)resourcesPath.getAbsolutePath()));
        if (check.exists()) {
            check = null;
            return true;
        }
        check = null;
        if (resourcesPath.getAbsolutePath().toLowerCase().indexOf("zip") > 0) {
            return ZipUtils.decompress(resourcesPath);
        }
        if (resourcesPath.getAbsolutePath().toLowerCase().indexOf("tgz") > 0) {
            File f = UncompressFile.deCompressTGZFile(resourcesPath);
            if (f == null) {
                return false;
            }
            String subDirName = FilenameUtils.removeExtension((String)resourcesPath.getName());
            return UncompressFile.deCompressTARFile(f, subDirName);
        }
        System.out.println("No valid decompress function.");
        return false;
    }

    public static final File deCompressGZFile(String srcFile, String tarFile) {
        byte[] buffer = new byte[1024];
        try {
            int len;
            GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(srcFile));
            FileOutputStream out = new FileOutputStream(tarFile);
            while ((len = gzis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            gzis.close();
            out.close();
            return new File(tarFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final void deCompressGZFile(File srcFile, File dstFile) throws IOException {
        byte[] buffer = new byte[1024];
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(srcFile));
             FileOutputStream fileOutputStream = new FileOutputStream(dstFile);){
            int len;
            while ((len = gzipInputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, len);
            }
        }
    }

    private static final synchronized File deCompressTGZFile(String file) {
        return UncompressFile.deCompressTGZFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized File deCompressTGZFile(File file) {
        FileOutputStream out = null;
        GzipCompressorInputStream gzIn = null;
        try {
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(fin);
            File outFile = new File(file.getParent() + File.separator + "tmp.tar");
            out = new FileOutputStream(outFile);
            gzIn = new GzipCompressorInputStream(in);
            byte[] buffer = new byte[2048];
            int n = 0;
            while (-1 != (n = gzIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
            File file2 = outFile;
            return file2;
        }
        catch (Exception e) {
            System.out.println("[DecompressFile] " + e.getMessage());
            File file3 = null;
            return file3;
        }
        finally {
            try {
                out.close();
                gzIn.close();
            }
            catch (IOException e) {
                System.out.println("[DecompressFile] " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized boolean deCompressTARFile(File file, String subDirName) {
        String basePath = file.getParent() + File.separator;
        TarArchiveInputStream is = null;
        try {
            TarArchiveEntry entry22;
            if (!UncompressFile.checkSubDirectory(file, subDirName)) {
                basePath = basePath + subDirName + File.separator;
            }
            is = new TarArchiveInputStream(new FileInputStream(file));
            while ((entry22 = is.getNextTarEntry()) != null) {
                if (!entry22.isDirectory()) {
                    File f = new File(basePath + entry22.getName());
                    if (!f.getParentFile().exists()) {
                        f.getParentFile().mkdirs();
                    }
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    try {
                        FileOutputStream os = new FileOutputStream(f);
                        Throwable throwable = null;
                        try {
                            byte[] bs = new byte[2048];
                            int len = -1;
                            while ((len = is.read(bs)) != -1) {
                                os.write(bs, 0, len);
                            }
                            os.flush();
                            continue;
                        }
                        catch (Throwable bs) {
                            throwable = bs;
                            throw bs;
                        }
                        finally {
                            if (os == null) continue;
                            if (throwable != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable bs) {
                                    throwable.addSuppressed(bs);
                                }
                                continue;
                            }
                            os.close();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("[DecompressFile] " + e.getMessage());
                        boolean bl = false;
                        try {
                            is.close();
                            file.delete();
                        }
                        catch (IOException e2) {
                            System.out.println("[DecompressFile] " + e2.getMessage());
                        }
                        return bl;
                    }
                }
                new File(basePath + entry22.getName()).mkdirs();
            }
            boolean entry22 = true;
            return entry22;
        }
        catch (Exception e) {
            System.out.println("[DecompressFile] " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
                file.delete();
            }
            catch (IOException e) {
                System.out.println("[DecompressFile] " + e.getMessage());
            }
        }
    }

    private static final synchronized boolean checkSubDirectory(File srcFile, String subDirName) {
        boolean hasSubDir = false;
        TarArchiveInputStream is = null;
        try {
            is = new TarArchiveInputStream(new FileInputStream(srcFile));
        }
        catch (FileNotFoundException e) {
            return false;
        }
        while (true) {
            TarArchiveEntry entry;
            try {
                entry = is.getNextTarEntry();
            }
            catch (IOException e) {
                break;
            }
            if (!entry.getName().contains(subDirName)) continue;
            hasSubDir = true;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (!hasSubDir) {
            File subDirPath = new File(srcFile.getParent() + File.separator + subDirName);
            subDirPath.mkdir();
        }
        return hasSubDir;
    }
}

