/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.FRU.record;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ChassisInfo;
import Gbt.utility.FRU.record.MultiRecordInfo;
import Gbt.utility.FRU.record.ProductInfo;
import com.veraxsystems.vxipmi.coding.commands.fru.ReadFruDataResponseData;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public abstract class FruRecord
extends AbstractJSONPOJO {
    protected static final String decodeString(int typeFormat, byte[] data, boolean isEnglishLanguageCode) {
        switch (typeFormat) {
            case 0: {
                StringBuilder sb = new StringBuilder();
                for (byte singleData : data) {
                    int num = TypeConverter.byteToInt(singleData);
                    if (num < 16) {
                        sb.append("0");
                    }
                    sb.append(Integer.toHexString(num));
                }
                return sb.toString();
            }
            case 1: {
                return TypeConverter.decodeBcdPlus(data);
            }
            case 2: {
                return TypeConverter.decode6bitAscii(data);
            }
            case 3: {
                System.arraycopy(data, 0, data, 0, data.length);
                if (isEnglishLanguageCode) {
                    return new String(data, Charset.forName("ISO-8859-1")).trim();
                }
                return new String(data, Charset.forName("UTF-8")).trim();
            }
        }
        return "";
    }

    public static final List<FruRecord> decodeFruData(List<ReadFruDataResponseData> fruData) {
        int size = 0;
        for (ReadFruDataResponseData responseData : fruData) {
            size += responseData.getFruData().length;
        }
        byte[] data = new byte[size];
        int offset = 0;
        for (ReadFruDataResponseData responseData : fruData) {
            int length = responseData.getFruData().length;
            System.arraycopy(responseData.getFruData(), 0, data, offset, length);
            offset += length;
        }
        ArrayList<FruRecord> list = new ArrayList<FruRecord>();
        if (data[0] == 1) {
            ProductInfo productInfo;
            BoardInfo boardInfo;
            ChassisInfo chassisInfo;
            int chassisOffset = TypeConverter.byteToInt(data[2]) * 8;
            int boardOffset = TypeConverter.byteToInt(data[3]) * 8;
            int productInfoOffset = TypeConverter.byteToInt(data[4]) * 8;
            int multiRecordOffset = TypeConverter.byteToInt(data[5]) * 8;
            if (chassisOffset != 0 && !(chassisInfo = new ChassisInfo(data, chassisOffset)).checkFieldsFullNull()) {
                list.add(chassisInfo);
            }
            if (boardOffset != 0 && !(boardInfo = new BoardInfo(data, boardOffset)).checkFieldsFullNull()) {
                list.add(boardInfo);
            }
            if (productInfoOffset != 0 && !(productInfo = new ProductInfo(data, productInfoOffset)).checkFieldsFullNull()) {
                list.add(productInfo);
            }
            if (multiRecordOffset != 0 && multiRecordOffset + 1 < data.length) {
                while ((TypeConverter.byteToInt(data[multiRecordOffset + 1]) & 0x80) == 0) {
                    MultiRecordInfo multiRecordInfo = MultiRecordInfo.populateMultiRecord(data, multiRecordOffset);
                    if (multiRecordInfo != null) {
                        list.add(multiRecordInfo);
                    }
                    if ((multiRecordOffset += TypeConverter.byteToInt(data[multiRecordOffset + 2]) + 5) <= data.length) continue;
                    break;
                }
            }
        }
        return list;
    }

    public static final List<FruRecord> decodeFruData(byte[] fullRawData) {
        ArrayList<FruRecord> list = new ArrayList<FruRecord>();
        if (fullRawData[0] == 1) {
            ProductInfo productInfo;
            BoardInfo boardInfo;
            ChassisInfo chassisInfo;
            int chassisOffset = TypeConverter.byteToInt(fullRawData[2]) * 8;
            int boardOffset = TypeConverter.byteToInt(fullRawData[3]) * 8;
            int productInfoOffset = TypeConverter.byteToInt(fullRawData[4]) * 8;
            int multiRecordOffset = TypeConverter.byteToInt(fullRawData[5]) * 8;
            if (chassisOffset != 0 && !(chassisInfo = new ChassisInfo(fullRawData, chassisOffset)).checkFieldsFullNull()) {
                list.add(chassisInfo);
            }
            if (boardOffset != 0 && !(boardInfo = new BoardInfo(fullRawData, boardOffset)).checkFieldsFullNull()) {
                list.add(boardInfo);
            }
            if (productInfoOffset != 0 && !(productInfo = new ProductInfo(fullRawData, productInfoOffset)).checkFieldsFullNull()) {
                list.add(productInfo);
            }
            if (multiRecordOffset != 0) {
                while ((TypeConverter.byteToInt(fullRawData[multiRecordOffset + 1]) & 0x80) == 0) {
                    MultiRecordInfo multiRecordInfo = MultiRecordInfo.populateMultiRecord(fullRawData, multiRecordOffset);
                    if (multiRecordInfo != null) {
                        list.add(multiRecordInfo);
                    }
                    if ((multiRecordOffset += TypeConverter.byteToInt(fullRawData[multiRecordOffset + 2]) + 5) <= fullRawData.length) continue;
                    break;
                }
            }
        }
        return list;
    }
}

