/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.GPUFanPolicy;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.GPUFanPolicy.GPUFanPolicyData;
import Gbt.utility.bmcinfo.BMCVendor;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class GetGPUFanPolicyCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "gpufan";
    private GbtIPMICommandReceiver ipmiReceiver;
    private String policyIDString;

    protected GetGPUFanPolicyCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        if (this.ipmiReceiver == null) {
            return false;
        }
        return ((Builder)this.commandArgs).bmcIP != null;
    }

    @Override
    public boolean execute() {
        GPUFanPolicyData data = new GPUFanPolicyData();
        data.setBMCIP(((Builder)this.commandArgs).bmcIP);
        boolean executeStatus = false;
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start get SMBIOS info.");
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, ((Builder)this.commandArgs).bmcIP + " IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                break;
            }
            case AMI: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor.");
                return false;
            }
        }
        if (((Builder)this.commandArgs).action.equals("get")) {
            executeStatus = this.getAllPolicy(handle);
            String title = String.format("\n%-20s | %-20s", "IP", "GPU Fan Policy");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + title);
            String resultString = String.format("%-20s | %-20s", ((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).policyID + "(" + this.policyIDString + ")");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + resultString);
            if (executeStatus) {
                data.setPolicyID(((Builder)this.commandArgs).policyID);
                data.setPolicy(this.policyIDString);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get GPU Fan policy success");
            } else {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get GPU Fan policy  fail");
            }
            this.commandResults.add(data);
        } else if (((Builder)this.commandArgs).action.equals("set")) {
            executeStatus = this.setAllPolicy(handle);
            if (executeStatus) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set GPU Fan policy success");
            } else {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set GPU Fan policy  fail");
            }
            this.commandResults.add(new NullJSONData().setError(!executeStatus).setMessages("Set GPU fan policy " + (executeStatus ? "success" : "fail")));
        }
        return executeStatus;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private boolean getAllPolicy(ConnectionHandle handle) {
        boolean getPolicyStatus = false;
        byte[] getPolicyStatusData = null;
        getPolicyStatusData = this.ipmiReceiver.getGPUFanPolicy(handle, COMMAND_NAME, this.commandID);
        if (getPolicyStatusData == null) {
            getPolicyStatus = false;
            this.judgePolicyID(-1);
        } else {
            this.judgePolicyID(getPolicyStatusData[0]);
        }
        return getPolicyStatus;
    }

    private boolean setAllPolicy(ConnectionHandle handle) {
        boolean setPolicyStatus = false;
        setPolicyStatus = this.ipmiReceiver.setGPUFanPolicy(handle, ((Builder)this.commandArgs).policyID, COMMAND_NAME, this.commandID);
        return setPolicyStatus;
    }

    private void judgePolicyID(int ID) {
        this.policyIDString = ID == 0 ? "Depend on SKU data" : (ID == 1 ? "Nvidia GTX1080 Titan" : (ID == 2 ? "Nvidia GTX980" : (ID == 3 ? "Nvidia M2000 x 8" : (ID == 4 ? "Nvidia M2000 x 12" : (ID == 5 ? "RX480" : (ID == 6 ? "K2200" : (ID == -1 ? "Fail" : "Unknown")))))));
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private String action;
        private int policyID;

        @Override
        public boolean checkArgs() {
            boolean result = true;
            if (this.args != null) {
                if (this.args.length == 0) {
                    result = false;
                } else if (this.args.length == 1) {
                    if (this.args[0].equalsIgnoreCase("get")) {
                        this.setAction("get");
                    } else {
                        result = false;
                    }
                } else if (this.args.length == 2) {
                    if (this.args[0].equalsIgnoreCase("get")) {
                        result = false;
                    } else if (this.args[0].equalsIgnoreCase("set")) {
                        this.setAction("set");
                        this.setPolicyID(Integer.parseInt(this.args[1]));
                    } else {
                        result = false;
                    }
                } else {
                    result = false;
                }
            } else {
                if (this.bmcIP == null) {
                    return false;
                }
                if (this.action.equals("set") && this.policyID < 0) {
                    return false;
                }
            }
            return result;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public GetGPUFanPolicyCommand build() {
            return new GetGPUFanPolicyCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setAction(String action) {
            this.action = action;
            return this.getThis();
        }

        public Builder setPolicyID(int policyID) {
            this.policyID = policyID;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.action = null;
            this.policyID = 0;
            this.loggerWriter.close();
        }
    }
}

