/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HpmUpdate;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.utility.Common.UncompressFile;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.FruRecord;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.Update.parsers.BiosSuitableFwParser;
import Gbt.utility.Update.parsers.BmcSuitableFwParser;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class HpmPreUpdateCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "hpmpreupdate";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private final GbtLocalCommandReceiver localReceiver;

    protected HpmPreUpdateCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME + "_" + ((Builder)this.commandArgs).updateType.toString();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Local command receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = null;
        BoardInfo boardInfo = null;
        ProductInfo productInfo = null;
        SuitableFwParser parser = null;
        CommonUpdateFWInfo updatFWInfo = null;
        List<FruRecord> fruRecords = null;
        handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            ((Builder)this.commandArgs).isContinue = false;
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI connection fail."));
            return false;
        }
        BMCInfoJSONData bmcInfo = this.ipmiReceiver.getBmcInfo(handle, ((Builder)this.commandArgs).bmcIP, COMMAND_NAME, this.commandID);
        if (bmcInfo == null) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Get BMC info fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC info fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        switch (((Builder)this.commandArgs).updateType) {
            case EROT: 
            case VBIOS: 
            case BMC: 
            case SCP: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute preupdate " + ((Builder)this.commandArgs).updateType.toString() + ".");
                if (!this.uncompressFWPkgs()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    ((Builder)this.commandArgs).isContinue = false;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Extract FW pkg fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                fruRecords = this.ipmiReceiver.getFRU(handle, bmcInfo.isAST2400() || bmcInfo.isCMC() ? 0 : 1, 16, this.getCommandName(), this.commandID);
                if (fruRecords == null) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    ((Builder)this.commandArgs).isContinue = false;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                if (boardInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (productInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board Product     : " + boardInfo.getBoardProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product Name      : " + productInfo.getProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC Product ID    : " + bmcInfo.getProductID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC FW Revision   : " + bmcInfo.getFirmwareRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC platform      : " + bmcInfo.getProductName().toString());
                break;
            }
            case BIOS: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute preupdate " + ((Builder)this.commandArgs).updateType.toString() + ".");
                if (!this.uncompressFWPkgs()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    ((Builder)this.commandArgs).isContinue = false;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Extract FW pkg fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                fruRecords = this.ipmiReceiver.getFRU(handle, bmcInfo.isAST2400() ? 0 : 1, 16, this.getCommandName(), this.commandID);
                if (fruRecords == null) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    ((Builder)this.commandArgs).isContinue = false;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                if (boardInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (productInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board Product     : " + boardInfo.getBoardProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product Name      : " + productInfo.getProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC Product ID    : " + bmcInfo.getProductID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC FW Revision   : " + bmcInfo.getFirmwareRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC platform      : " + bmcInfo.getProductName().toString());
                break;
            }
            default: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unknown update type.");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Unknown update type."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
        }
        parser = SuitableFwParser.getFwParser(((Builder)this.commandArgs).updateType, this.loggerWriter, this.getCommandName(), this.commandID, ((Builder)this.commandArgs).bmcIP);
        if (parser instanceof BiosSuitableFwParser) {
            ((BiosSuitableFwParser)parser).setSkipCheckBiosSubject(((Builder)this.commandArgs).skipCheckBiosSubject);
            ((BiosSuitableFwParser)parser).setIgnoreChecksum(((Builder)this.commandArgs).ignoreChecksum);
            ((BiosSuitableFwParser)parser).setIsHpmUpdate(true);
        } else if (parser instanceof BmcSuitableFwParser) {
            ((BmcSuitableFwParser)parser).isHpmUpdate(true);
        }
        updatFWInfo = parser.parseSuitableFw(((Builder)this.commandArgs).fwPkgs, boardInfo, productInfo, bmcInfo);
        if (updatFWInfo == null) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            ((Builder)this.commandArgs).isContinue = false;
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot find any suitable " + ((Builder)this.commandArgs).updateType.toString() + " FW."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (updatFWInfo.getImagePath() == null || updatFWInfo.getImagePath().equals("")) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            ((Builder)this.commandArgs).isContinue = false;
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot find any hpm FW."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        updatFWInfo.setWithoutAsk(((Builder)this.commandArgs).isContinue);
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, updatFWInfo.toString());
        this.commandResults.add(updatFWInfo);
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public boolean isContinue() {
        return ((Builder)this.commandArgs).isContinue;
    }

    private boolean uncompressFWPkgs() {
        boolean ok = true;
        for (File fwpkg : ((Builder)this.commandArgs).fwPkgs) {
            ok &= UncompressFile.deCompressedFile(fwpkg);
        }
        return ok;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private UpdateType updateType = UpdateType.UNKNOWN;
        private List<File> fwPkgs = new ArrayList<File>();
        private boolean isContinue = false;
        private boolean skipCheckBiosSubject = false;
        private boolean ignoreChecksum = false;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(HpmPreUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "0.0.0.0_hpmpreupdate", "BMC IP address is null.");
                return false;
            }
            if (this.updateType == UpdateType.UNKNOWN) {
                this.loggerWriter.appendPath(HpmPreUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + HpmPreUpdateCommand.COMMAND_NAME, "[" + this.bmcIP + "] Unknown update type.");
                return false;
            }
            if (this.fwPkgs.isEmpty()) {
                this.loggerWriter.appendPath(HpmPreUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + HpmPreUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] Cannot find any firmware packages.");
                return false;
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public HpmPreUpdateCommand build() {
            if (this.args != null && this.args.length > 0) {
                this.updateType = this.args.length > 1 ? UpdateType.parse(this.args[0], this.args[1]) : UpdateType.parse(this.args[0], null);
                this.commandLineParser(this.args);
            }
            return new HpmPreUpdateCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.fwPkgs.clear();
            this.fwPkgs = null;
            this.loggerWriter.close();
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this.getThis();
        }

        public Builder setFWPackage(String firmwarePath) {
            if (firmwarePath.toLowerCase().indexOf(".zip") > 0) {
                File fw;
                if (!firmwarePath.contains("/") && !firmwarePath.contains("\\")) {
                    firmwarePath = "./" + firmwarePath;
                }
                if ((fw = new File(firmwarePath)).exists()) {
                    this.fwPkgs.add(fw);
                }
            }
            return this.getThis();
        }

        public Builder setFWPackage(File firmwarePath) {
            if (firmwarePath.getName().toLowerCase().indexOf(".zip") > 0 && firmwarePath.exists()) {
                this.fwPkgs.add(firmwarePath);
            }
            return this.getThis();
        }

        public Builder setFWPackages(List<File> firmwarePaths) {
            this.fwPkgs = firmwarePaths;
            return this.getThis();
        }

        public Builder setAuto(boolean autoMode) {
            this.isContinue = autoMode;
            return this.getThis();
        }

        public Builder setSkipCheckBiosSubject(boolean skipCheckBiosSubject) {
            this.skipCheckBiosSubject = skipCheckBiosSubject;
            return this.getThis();
        }

        public Builder setIgnoreChecksum(boolean ignoreChecksum) {
            this.ignoreChecksum = ignoreChecksum;
            return this.getThis();
        }

        private void commandLineParser(String[] args) {
            int startPosition = 1;
            if (args[0].equals("cpld")) {
                startPosition = 2;
            }
            block10: for (int i = startPosition; i < args.length; ++i) {
                switch (args[i]) {
                    case "auto": {
                        this.setAuto(true);
                        continue block10;
                    }
                    case "skip": {
                        this.setSkipCheckBiosSubject(true);
                        continue block10;
                    }
                    case "ignore": {
                        this.setIgnoreChecksum(true);
                        continue block10;
                    }
                    default: {
                        this.setFWPackage(args[i]);
                    }
                }
            }
        }
    }
}

