/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.IPv6Config;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.FRU.GetFRUCommand;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.FruRecord;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.util.List;

public class IPv6ConfigCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "ipv6";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected IPv6ConfigCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return ((Builder)this.commandArgs).bmcIP != null;
    }

    @Override
    public boolean execute() {
        int count;
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCInfoJSONData bmcInfo = this.ipmiReceiver.getBmcInfo(handle, ((Builder)this.commandArgs).bmcIP, COMMAND_NAME, this.commandID);
        if (bmcInfo == null) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Get BMC info fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC info fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        switch (bmcInfo.getBmcVendor()) {
            case VERTIV: {
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + (Object)((Object)bmcInfo.getBmcVendor()) + " FW.");
                return false;
            }
        }
        boolean ok = false;
        if (bmcInfo.isGrantley()) {
            for (count = 0; !ok && count <= 3; ++count) {
                ok = this.ipmiReceiver.setIPv6Grantley(handle, COMMAND_NAME, this.commandID, (byte)((Builder)this.commandArgs).command);
            }
            if (!ok || count > 3) {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Set Ipv6 command fail."));
                return false;
            }
        } else {
            List<FruRecord> fruRecords = this.ipmiReceiver.getFRU(handle, 0, 16, COMMAND_NAME, this.commandID);
            String boardProduct = GetFRUCommand.parseFRUrecords(fruRecords, BoardInfo.class).getBoardProductName();
            if (boardProduct.contains("7PTSH") || boardProduct.contains("7PTSV")) {
                while (!ok && count <= 3) {
                    ok = this.ipmiReceiver.setIPv6RomleyOR(handle, COMMAND_NAME, this.commandID, (byte)((Builder)this.commandArgs).command);
                    ++count;
                }
                if (!ok || count > 3) {
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Set Ipv6 command fail."));
                    return false;
                }
            } else {
                while (!ok && count <= 3) {
                    ok = this.ipmiReceiver.setIPv6RomleyNormal(handle, COMMAND_NAME, this.commandID, (byte)((Builder)this.commandArgs).command);
                    ++count;
                }
                if (!ok || count > 3) {
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Set Ipv6 command fail."));
                    return false;
                }
            }
        }
        this.commandResults.add(new NullJSONData().setError(false).setMessages("Set Ipv6 command success."));
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private int command = 0;

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                if (this.args.length != 1) {
                    return false;
                }
                if (this.args[0] != null) {
                    if (this.args[0].equals("disable")) {
                        this.command = 1;
                    } else if (this.args[0].equals("enable")) {
                        this.command = 2;
                    }
                } else {
                    return false;
                }
                return true;
            }
            return this.bmcIP != null && this.command != 0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public IPv6ConfigCommand build() {
            return new IPv6ConfigCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setCommand(int command) {
            this.command = command;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.command = 0;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }
    }
}

