/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Local;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.LocalCmdRecords;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.ZipUtils;
import Gbt.utility.Local.SearchLatestFirmware;
import Gbt.utility.Update.PreUpdateCommand;
import Gbt.utility.Update.UpdateType;
import java.util.List;
import java.util.Scanner;

public final class LocalSubCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "local";
    public static final String checksum = "check";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private final GbtLocalCommandReceiver localReceiver;
    private Scanner scanner = new Scanner(System.in);

    protected LocalSubCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = COMMAND_NAME;
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[ IPMI command receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, " Local command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, " Command arguments check fail.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean result = false;
        if (((Builder)this.commandArgs).comType.equals(((Builder)this.commandArgs).UPDATE_OPTION)) {
            result = this.onlineupdate();
            this.commandResults.add(new NullJSONData().setError(!result).setMessages("Online update " + (result ? "success" : "fail")));
        }
        return result;
    }

    private boolean onlineupdate() {
        boolean result = false;
        boolean doPreudate = false;
        boolean doUpdate = false;
        boolean connectResult = false;
        String fileName = null;
        String version = null;
        ((Builder)this.commandArgs).modelName = this.localReceiver.getModelName(COMMAND_NAME, this.commandID);
        try {
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(1000L);
                SearchLatestFirmware slf = new SearchLatestFirmware();
                slf.run(((Builder)this.commandArgs).updateType, ((Builder)this.commandArgs).modelName);
                connectResult = slf.getResult();
                fileName = slf.getFirmwareName().replaceAll(".zip", "");
                version = slf.getFirmwareVersion();
                if (!connectResult) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "SearchLatestFirmware fail ... updateType:" + ((Builder)this.commandArgs).updateType + " ... Please check your connection");
        }
        if (connectResult) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "get Firmware From Web Complete , fileName:" + fileName);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Are you sure to update " + ((Builder)this.commandArgs).updateType + " using online firmware ... firmware:" + fileName + " version:" + version + " ? (Y/N)");
            String answer = this.scanner.nextLine();
            if (answer.equalsIgnoreCase("Y") || answer.equalsIgnoreCase("Yes")) {
                doPreudate = true;
            }
        }
        if (!doPreudate) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Are you sure to update " + ((Builder)this.commandArgs).updateType + " using local File ? (Y/N)");
            String answer = this.scanner.nextLine();
            if (answer.equalsIgnoreCase("Y") || answer.equalsIgnoreCase("Yes")) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Please key in your Firmware Path:");
                fileName = this.scanner.nextLine();
                doPreudate = true;
            }
        }
        if (doPreudate) {
            System.out.println("fileName:" + fileName);
            PreUpdateCommand command = new PreUpdateCommand.Builder().setBMCIP("").setBMCUsername("").setBMCPassword("").setUpdateType(UpdateType.parse(((Builder)this.commandArgs).updateType, null)).setFWPackage(fileName).setLocal(true).build();
            if (!command.checkAll()) {
                try {
                    command.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                doUpdate = false;
            }
            if (!command.execute()) {
                try {
                    command.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                doUpdate = false;
            } else {
                try {
                    command.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                doUpdate = true;
            }
        }
        if (doUpdate) {
            if (CommonFunction.isUnix()) {
                if (((Builder)this.commandArgs).updateType.equals("bmc")) {
                    result = this.doUnixBMClocalUpdate(fileName);
                } else if (((Builder)this.commandArgs).updateType.equals("bios")) {
                    result = this.doUnixBIOSlocalUpdate(fileName);
                }
            } else if (CommonFunction.isWindows()) {
                if (((Builder)this.commandArgs).updateType.equals("bmc")) {
                    result = this.doWindowsBMClocalUpdate(fileName);
                } else if (((Builder)this.commandArgs).updateType.equals("bios")) {
                    result = this.doWindowsBIOSlocalUpdate(fileName);
                }
            }
        }
        return result;
    }

    private boolean doUnixBMClocalUpdate(String filename) {
        boolean result = false;
        int BMC_COUNT = 1;
        String passStr = "UpdateFlashChipO.K.";
        String[] twiceModelName = new String[]{"T174-N40-Y3N"};
        String[] twiceBMCFolder = new String[]{"/utility/fwud/linux/BMC_FLH1/", "/utility/fwud/linux/BMC_FLH2/"};
        String BMCFolder = "/utility/fwud/linux/";
        String localBMCversion = "";
        String firmwareVersion = "";
        String fwFolder = filename.replace(".zip", "");
        for (String aTwiceModelName : twiceModelName) {
            if (!((Builder)this.commandArgs).modelName.equals(aTwiceModelName)) continue;
            BMC_COUNT = 2;
        }
        try {
            LocalCmdRecords records = this.localReceiver.executeLocalCommand("ipmitool mc info | grep \"Firmware Revision\" | awk -F':' '{print $2}' | sed -e 's/ //g'", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            localBMCversion = records.getResults().replace("\n", "").replace(".", "");
            records = this.localReceiver.executeLocalCommand("echo $PWD/", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            String localPath = records.getResults().replace("\n", "");
            if (this.unzipFile(filename)) {
                records = this.localReceiver.executeLocalCommand("ls $PWD/" + fwFolder + "/ | grep -v \".zip\"", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                firmwareVersion = records.getResults().replace("\n", "");
                if (!firmwareVersion.contains(localBMCversion)) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "start update ...Please Wait....");
                    records = this.localReceiver.executeLocalCommand("chmod -R 777 " + fwFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    block3: for (int i = 0; i < BMC_COUNT; ++i) {
                        if (BMC_COUNT > 1) {
                            BMCFolder = twiceBMCFolder[i];
                        }
                        records = this.localReceiver.executeLocalCommand("cd $PWD/" + fwFolder + "/" + firmwareVersion + BMCFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                        records = this.localReceiver.executeLocalCommand("./flashall64.sh > " + localPath + "BMCupdateInfo" + (i + 1) + ".log", fwFolder + "/" + firmwareVersion + BMCFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                        records = this.localReceiver.executeLocalCommand("cat BMCupdateInfo" + (i + 1) + ".log | grep \"Update Flash Chip O.K.\" | sed 's/ //g'", localPath, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                        List<String> stdOutList = records.getLineResults();
                        for (String aStdOutList : stdOutList) {
                            if (!passStr.equals(aStdOutList)) {
                                result = false;
                                continue block3;
                            }
                            result = true;
                        }
                    }
                    if (result) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BMC update success");
                    } else {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BMC update Fail");
                    }
                } else {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "vserion is same ... skip update");
                    result = true;
                }
            } else {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "unzipFile Fail ... filename:" + filename);
                result = false;
            }
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "doBMClocalUpdate Fail ... filename:" + filename);
        }
        return result;
    }

    private boolean doUnixBIOSlocalUpdate(String filename) {
        boolean result;
        block15: {
            result = false;
            String intelPassStr1 = "ME Entire Image update success";
            String intelPassStr2 = "Update success for MER";
            String amdPassStr = "Verifying RomHole Block ..... done";
            String BIOSFolder = "/Tool/LNX/afulnx64/";
            String localBIOSversion = "";
            String firmwareVersion = "";
            String biosDriverPath = "$PWD/biosDriver/";
            String biosDriverName = "/amifldrv_mod.o";
            String fwFolder = filename.replace(".zip", "");
            try {
                LocalCmdRecords records = this.localReceiver.executeLocalCommand("dmidecode -t 0 | grep \"Version:\" | cut -d \":\" -f 2 | sed 's/ //g'", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                localBIOSversion = records.getResults().replace("\n", "").replace(".", "");
                records = this.localReceiver.executeLocalCommand("echo $PWD/", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                String localPath = records.getResults().replace("\n", "") + "biosUpd.log";
                if (this.unzipFile(filename)) {
                    records = this.localReceiver.executeLocalCommand("ls $PWD/" + fwFolder + "/ | grep -v \".zip\"", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    firmwareVersion = records.getResults().replace("\n", "");
                    if (firmwareVersion.contains(localBIOSversion)) break block15;
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "start update ...Please Wait....");
                    records = this.localReceiver.executeLocalCommand("echo $PWD/" + fwFolder + "/" + firmwareVersion + BIOSFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    records = this.localReceiver.executeLocalCommand("uname -r", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    String kernel = records.getResults().replace("\n", "").split("\\.")[0] + "." + records.getResults().replace("\n", "").split("\\.")[1];
                    records = this.localReceiver.executeLocalCommand("cp -pr " + biosDriverPath + kernel + biosDriverName + " $PWD/" + fwFolder + "/" + firmwareVersion + BIOSFolder + "/", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    records = this.localReceiver.executeLocalCommand("cp -f $PWD/" + fwFolder + "/" + firmwareVersion + BIOSFolder + "/amifldrv_mod.o  $PWD/" + fwFolder + "/" + firmwareVersion + BIOSFolder + "/amifldrv_mod", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    records = this.localReceiver.executeLocalCommand("chmod -R 777 " + fwFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    records = this.localReceiver.executeLocalCommand("./f.sh > " + localPath, fwFolder + "/" + firmwareVersion + BIOSFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    String cpuVendor = this.localReceiver.localGetCPUVendor(COMMAND_NAME, this.commandID);
                    if (cpuVendor.equals("Intel")) {
                        records = this.localReceiver.executeLocalCommand("cat " + localPath + " | grep \"" + intelPassStr1 + "\" | sed 's/^.*- //g' | sed 's/ !*.$//g'", COMMAND_NAME, this.commandID);
                        List<String> stdOutList = records.getLineResults();
                        for (String aStdOutList : stdOutList) {
                            if (!intelPassStr1.equals(aStdOutList)) {
                                result = false;
                                break;
                            }
                            result = true;
                        }
                        if (!result) {
                            records = this.localReceiver.executeLocalCommand("cat " + localPath + " | grep \"" + intelPassStr2 + "\" | sed 's/^.*- //g' | sed 's/ !*.$//g'", COMMAND_NAME, this.commandID);
                            stdOutList = records.getLineResults();
                            for (String aStdOutList : stdOutList) {
                                if (!intelPassStr2.equals(aStdOutList)) {
                                    result = false;
                                    break;
                                }
                                result = true;
                            }
                        }
                    } else if (cpuVendor.equals("AMD")) {
                        records = this.localReceiver.executeLocalCommand("cat " + localPath + " | grep \"" + amdPassStr + "\" | sed 's/^.*- //g' | sed 's/ !*.$//g'", COMMAND_NAME, this.commandID);
                        List<String> stdOutList = records.getLineResults();
                        for (String aStdOutList : stdOutList) {
                            if (!amdPassStr.equals(aStdOutList)) {
                                result = false;
                                break;
                            }
                            result = true;
                        }
                    }
                    if (result) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BIOS update success!!!");
                    } else {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BIOS update fail!!!");
                    }
                    break block15;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "unzipFile Fail ... filename:" + filename);
                result = false;
            }
            catch (Exception e) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "do BIOS local Update Fail ... filename:" + filename);
                result = false;
            }
        }
        return result;
    }

    private boolean doWindowsBMClocalUpdate(String filename) {
        boolean result = false;
        int BMC_COUNT = 1;
        String passStr = "UpdateFlashChipOK";
        String[] twiceModelName = new String[]{"T174-N40-Y3N"};
        String[] twiceBMCFolder = new String[]{"\\utility\\fwud\\windows\\BMC_FLH1\\", "\\utility\\fwud\\windows\\BMC_FLH2\\"};
        String BMCFolder = "\\utility\\fwud\\windows\\";
        String localBmcVersion = "";
        String firmwareVersion = "";
        String fwFolder = filename.replace(".zip", "");
        for (String aTwiceModelName : twiceModelName) {
            if (!((Builder)this.commandArgs).modelName.equals(aTwiceModelName)) continue;
            BMC_COUNT = 2;
        }
        try {
            localBmcVersion = this.localReceiver.getBMCInfoByLocalCmd(COMMAND_NAME, this.commandID).getFirmwareRevision();
            if (this.unzipFile(filename)) {
                LocalCmdRecords records = this.localReceiver.executeLocalCommand("dir /a:d /b %cd%\\" + fwFolder + "\\" + filename + "\\", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                firmwareVersion = records.getResults().replace("\n", "");
                if (!firmwareVersion.contains(localBmcVersion)) {
                    records = this.localReceiver.executeLocalCommand("echo %cd%", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    String localPath = records.getResults().replace("\n", "");
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "start update ...Please Wait....");
                    block3: for (int i = 0; i < BMC_COUNT; ++i) {
                        if (BMC_COUNT > 1) {
                            BMCFolder = twiceBMCFolder[i];
                        }
                        records = this.localReceiver.executeLocalCommand("call flashall64.bat > " + localPath + "\\BMCupdateInfo" + (i + 1) + ".log", fwFolder + "\\" + firmwareVersion + BMCFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                        records = this.localReceiver.executeLocalCommand("type BMCupdateInfo" + (i + 1) + ".log | find \"Update Flash Chip O.K.\"", localPath, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                        List<String> stdOutList = records.getLineResults();
                        for (String aStdOutList : stdOutList) {
                            String resultStr = aStdOutList.replace(".", "").replace(" ", "");
                            if (!passStr.equals(resultStr)) {
                                result = false;
                                continue block3;
                            }
                            result = true;
                        }
                    }
                    if (result) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BMC update success");
                    } else {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BMC update Fail");
                    }
                } else {
                    result = true;
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "vserion is same ... skip update");
                }
            } else {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "unzipFile Fail ... filename:" + filename);
            }
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "doBMClocalUpdate Fail ... filename:" + filename);
        }
        return result;
    }

    private boolean doWindowsBIOSlocalUpdate(String filename) {
        boolean result = false;
        String intelPassStr1 = "ME Entire Image update success !!";
        String intelPassStr2 = "Update success for MER";
        String amdPassStr = "Verifying RomHole Block ..... done";
        String BIOSFolder = "/Tool/WIN/afuwin64/";
        String localBIOSversion = "";
        String firmwareVersion = "";
        String fwFolder = filename.replace(".zip", "");
        try {
            LocalCmdRecords records = this.localReceiver.executeLocalCommand("wmic BIOS get SMBIOSBIOSVersion", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            localBIOSversion = records.getLineResults().get(2).trim();
            records = this.localReceiver.executeLocalCommand("echo %cd%", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            String localPath = records.getResults().replace("\n", "") + "\\biosUpd.log";
            if (this.unzipFile(filename)) {
                records = this.localReceiver.executeLocalCommand("dir /a:d /b %cd%\\" + fwFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                firmwareVersion = records.getResults().replace("\n", "");
                System.out.println("@@@firmwareVersion:" + firmwareVersion);
                if (!firmwareVersion.contains(localBIOSversion)) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "start update ...Please Wait....");
                    records = this.localReceiver.executeLocalCommand("call f.bat > " + localPath, fwFolder + "\\" + firmwareVersion + BIOSFolder, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
                    String cpuVendor = this.localReceiver.localGetCPUVendor(COMMAND_NAME, this.commandID);
                    if (cpuVendor.equals("Intel")) {
                        records = this.localReceiver.executeLocalCommand("type " + localPath + " | find /C /I \"" + intelPassStr1 + "\"", COMMAND_NAME, this.commandID);
                        int count = Integer.parseInt(records.getLineResults().get(0));
                        result = count != 0;
                        if (!result) {
                            records = this.localReceiver.executeLocalCommand("type " + localPath + " | find /C /I \"" + intelPassStr2 + "\" ", COMMAND_NAME, this.commandID);
                            count = Integer.parseInt(records.getLineResults().get(0));
                            result = count != 0;
                        }
                    } else if (cpuVendor.equals("AMD")) {
                        records = this.localReceiver.executeLocalCommand("type " + localPath + " | find /C /I \"" + amdPassStr + "\"", COMMAND_NAME, this.commandID);
                        int count = Integer.parseInt(records.getLineResults().get(0));
                        result = count != 0;
                    }
                    if (result) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BIOS update success!!!");
                    } else {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "BIOS update fail!!!");
                    }
                }
            } else {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "unzipFile Fail ... filename:" + filename);
                result = false;
            }
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "do BIOS local Update Fail ... filename:" + filename);
            result = false;
        }
        return result;
    }

    private boolean unzipFile(String filename) {
        boolean result = false;
        filename = filename.replace(".zip", "");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "start unzip ...");
        if (CommonFunction.isUnix()) {
            LocalCmdRecords records = this.localReceiver.executeLocalCommand("ls | grep \"" + filename + "\" | grep -v \".zip\"", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            if (records.getResults().contains(filename)) {
                records = this.localReceiver.executeLocalCommand("rm -r " + filename + "/", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            }
            if (!(records = this.localReceiver.executeLocalCommand("ls | grep \"" + filename + ".zip\"", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID)).getResults().contains(filename)) {
                System.out.println("Fatal error : \"" + filename + ".zip\" not exist!!");
                throw new IllegalArgumentException("Fatal error : \"" + filename + ".zip\" not exist!!");
            }
            records = this.localReceiver.executeLocalCommand("mkdir " + filename, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            records = this.localReceiver.executeLocalCommand("cp " + filename + ".zip " + filename + "/", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            records = this.localReceiver.executeLocalCommand("echo $PWD/" + filename + "/" + filename + ".zip", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            try {
                ZipUtils.decompress(records.getResults().replace("\n", ""), false);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, filename + ".zip unzip OK.");
                result = true;
            }
            catch (Exception e) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, filename + ".zip unzip Fail.");
                result = false;
            }
        } else if (CommonFunction.isWindows()) {
            LocalCmdRecords records = this.localReceiver.executeLocalCommand("dir /a:d /b %cd%", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            if (records.getLineResults().contains(filename)) {
                records = this.localReceiver.executeLocalCommand("rd " + filename + " /S /Q", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            }
            if (!(records = this.localReceiver.executeLocalCommand("dir " + filename + ".zip", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID)).getResults().contains(filename + ".zip")) {
                throw new IllegalArgumentException("Fatal error : " + filename + ".zip not exist!!");
            }
            records = this.localReceiver.executeLocalCommand("md " + filename, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            records = this.localReceiver.executeLocalCommand("copy " + filename + ".zip " + filename, GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            records = this.localReceiver.executeLocalCommand("echo %cd%\\" + filename + "\\" + filename + ".zip", GbtLogLevel.DEBUG, COMMAND_NAME, this.commandID);
            try {
                ZipUtils.decompress(records.getResults().replace("\n", ""), false);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, filename + " unzip OK.\n");
                result = true;
            }
            catch (Exception e) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, filename + " unzip Fail.\n");
            }
        }
        return result;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String comType;
        private String updateType;
        private String modelName;
        private String UPDATE_OPTION = "onlineupdate";

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                if (this.args.length != 2) {
                    return false;
                }
                if (this.args.length == 2) {
                    if (this.args[0].equals(this.UPDATE_OPTION)) {
                        this.setComType(this.args[0]);
                        this.setUpdtaeType(this.args[1]);
                    } else {
                        return false;
                    }
                }
                return true;
            }
            if (this.comType == null) {
                return false;
            }
            return !this.comType.equals(this.UPDATE_OPTION) || this.updateType != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public LocalSubCommand build() {
            return new LocalSubCommand(this);
        }

        public Builder setUpdtaeType(String updateType) {
            this.updateType = updateType;
            return this.getThis();
        }

        public Builder setComType(String comType) {
            this.comType = comType;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.updateType = null;
            this.modelName = null;
            this.comType = null;
            this.UPDATE_OPTION = null;
            this.loggerWriter.close();
        }
    }
}

