/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Local;

import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Local.GetJSONData;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class SearchLatestFirmware {
    private String filename = "";
    private String version = "";
    boolean result = false;

    public void run(String firmwareType, String model) {
        ArrayNode arry;
        String url_getInfo = "http://global.test.gigabyte.com/json/ProductDownload?n=";
        String url_download = "http://download.gigabyte.asia";
        String url = "";
        model = model.replaceAll("_", "-");
        url_getInfo = url_getInfo + model + ".json";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        GetJSONData gjd = null;
        try {
            gjd = new GetJSONData(url_getInfo);
        }
        catch (IOException e) {
            this.result = false;
            e.printStackTrace();
            return;
        }
        Date uploadDate = null;
        JsonNode rows = gjd.getJsonNode().get("rows");
        if (rows.isArray() && (arry = (ArrayNode)rows).has("filetype")) {
            Iterator itar = arry.elements();
            while (itar.hasNext()) {
                JsonNode ele = (JsonNode)itar.next();
                Date jsonDate = null;
                try {
                    jsonDate = sdf.parse(ele.get("date").textValue());
                    if (uploadDate == null) {
                        uploadDate = jsonDate;
                        this.filename = ele.get("filename").textValue();
                        url = ele.get("url").textValue();
                        this.version = ele.get("version").textValue();
                    }
                    if (!jsonDate.after(uploadDate)) continue;
                    uploadDate = jsonDate;
                    this.filename = ele.get("filename").textValue();
                    url = ele.get("url").textValue();
                    this.version = ele.get("version").textValue();
                }
                catch (ParseException pe) {
                    this.filename = ele.get("filename").textValue();
                    url = ele.get("url").textValue();
                    this.version = ele.get("version").textValue();
                }
            }
        }
        url_download = url_download + url + this.filename;
        try {
            this.result = CommonFunction.downloadFromURL(new URL(url_download), new File(this.filename));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.result = false;
        }
    }

    public boolean getResult() {
        return this.result;
    }

    public String getFirmwareName() {
        return this.filename;
    }

    public String getFirmwareVersion() {
        return this.version;
    }
}

