/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.MultiNode.openrack;

import Gbt.utility.Common.GbtCommonConverters;
import java.math.BigInteger;

public class GRackNodeStruct {
    private short id;
    private short fwvers;
    private byte[] biosvers = new byte[4];
    private byte type;
    private byte slave_addr;
    private short product_id;
    private int ipaddr;
    private byte[] ipv6addr = new byte[16];
    private byte nr_children;
    private byte floor;
    private byte timeout_interval;
    private byte[] macaddr = new byte[6];
    private byte[] lan1macaddr = new byte[6];
    private byte[] lan2macaddr = new byte[6];
    private byte[] lan3macaddr = new byte[6];
    private byte[] lan4macaddr = new byte[6];
    private byte i2c_mux_port;
    private byte next_brdcmd;
    private long status;
    private byte[] temperatures = new byte[8];
    private byte[] fan_reading = new byte[16];
    private byte[] fan_pwm = new byte[8];
    private byte fanLastID;
    private byte[] cpu_performance = new byte[2];
    private byte[] power_consumption = new byte[8];
    private byte cpu_watt;
    private byte[] padding4 = new byte[9];
    private int slotID;
    private int slotIndex;

    public void set20Id(short Id) {
        this.id = (short)(Id >> 8);
        this.slotID = GbtCommonConverters.OR20IDtoSlot(this.id);
        this.slotIndex = GbtCommonConverters.OR20IDtoArrayindex(this.id);
    }

    public void set25Id(short Id) {
        this.id = (short)(Id >> 8);
        this.slotID = GbtCommonConverters.OR25IDtoSlot(this.id);
        this.slotIndex = GbtCommonConverters.OR25IDtoArrayindex(this.id);
    }

    public void setFwvers(short Fwvers) {
        this.fwvers = Fwvers;
    }

    public void setBiosvers(byte[] Biosvers) {
        this.biosvers = Biosvers;
    }

    public void setType(byte Type2) {
        this.type = Type2;
    }

    public void setSlave_addr(byte Slave_addr) {
        this.slave_addr = Slave_addr;
    }

    public void setProduct_id(short Product_id) {
        this.product_id = Product_id;
    }

    public void setIpaddr(int Ipaddr) {
        this.ipaddr = Ipaddr;
    }

    public void setIpv6addr(byte[] Ipv6addr) {
        this.ipv6addr = Ipv6addr;
    }

    public void setNr_children(byte Nr_children) {
        this.nr_children = Nr_children;
    }

    public void setFloor(byte Floor) {
        this.floor = Floor;
    }

    public void setTimeout_interval(byte Timeout_interval) {
        this.timeout_interval = Timeout_interval;
    }

    public void setMacaddr(byte[] Macaddr) {
        this.macaddr = Macaddr;
    }

    public void setLan1macaddr(byte[] Lan1macaddr) {
        this.lan1macaddr = Lan1macaddr;
    }

    public void setLan2macaddr(byte[] Lan2macaddr) {
        this.lan2macaddr = Lan2macaddr;
    }

    public void setLan3macaddr(byte[] Lan3macaddr) {
        this.lan3macaddr = Lan3macaddr;
    }

    public void setLan4macaddr(byte[] Lan4macaddr) {
        this.lan4macaddr = Lan4macaddr;
    }

    public void setI2c_mux_port(byte I2c_mux_port) {
        this.i2c_mux_port = I2c_mux_port;
    }

    public void setNext_brdcmd(byte Next_brdcmd) {
        this.next_brdcmd = Next_brdcmd;
    }

    public void setStatus(long Status2) {
        this.status = GbtCommonConverters.swap(Status2);
    }

    public void setTemperatures(byte[] Temperatures) {
        this.temperatures = Temperatures;
    }

    public void setFan_reading(byte[] Fan_reading) {
        this.fan_reading = Fan_reading;
    }

    public void setFan_pwm(byte[] Fan_pwm) {
        this.fan_pwm = Fan_pwm;
    }

    public void setFanLastID(byte FanLastID) {
        this.fanLastID = FanLastID;
    }

    public void setCpu_performance(byte[] Cpu_performance) {
        this.cpu_performance = Cpu_performance;
    }

    public void setPower_consumption(byte[] Power_consumption) {
        this.power_consumption = Power_consumption;
    }

    public void setCpu_watt(byte Cpu_watt) {
        this.cpu_watt = Cpu_watt;
    }

    public void setPadding4(byte[] Padding4) {
        this.padding4 = Padding4;
    }

    public short getId() {
        return this.id;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public int getSlotArrayIndex() {
        return this.slotIndex;
    }

    public short getFwvers() {
        return this.fwvers;
    }

    public String getFwversString() {
        if (this.fwvers != 0) {
            return (byte)((this.fwvers & 0xFF00) >> 8) + "." + GbtCommonConverters.bytesToHex(new byte[]{(byte)(this.fwvers & 0xFF)});
        }
        return "N/A";
    }

    public byte[] getBiosvers() {
        return this.biosvers;
    }

    public String getBiosversString() {
        return new String(this.biosvers);
    }

    public byte getType() {
        return this.type;
    }

    public String getSlave_addr() {
        return GbtCommonConverters.bytesToHex(new byte[]{this.slave_addr}) + "h";
    }

    public short getProduct_id() {
        return this.product_id;
    }

    public String getIpaddr() {
        try {
            return GbtCommonConverters.BigIntegerToIp(BigInteger.valueOf(this.ipaddr));
        }
        catch (RuntimeException e) {
            return "0.0.0.0";
        }
    }

    public String getIpv6addr() {
        return GbtCommonConverters.bytesToIPv6Address(this.ipv6addr);
    }

    public byte getNr_children() {
        return this.nr_children;
    }

    public byte getFloor() {
        return this.floor;
    }

    public byte getTimeout_interval() {
        return this.timeout_interval;
    }

    public String getMacaddr() {
        return GbtCommonConverters.bytesToMacAddress(this.macaddr);
    }

    public String getLan1macaddr() {
        return GbtCommonConverters.bytesToMacAddress(this.lan1macaddr);
    }

    public String getLan2macaddr() {
        return GbtCommonConverters.bytesToMacAddress(this.lan2macaddr);
    }

    public String getLan3macaddr() {
        return GbtCommonConverters.bytesToMacAddress(this.lan3macaddr);
    }

    public String getLan4macaddr() {
        return GbtCommonConverters.bytesToMacAddress(this.lan4macaddr);
    }

    public byte getI2c_mux_port() {
        return this.i2c_mux_port;
    }

    public byte getNext_brdcmd() {
        return this.next_brdcmd;
    }

    public long getStatus() {
        return this.status;
    }

    public int[] getTemperatures() {
        int[] temperature = new int[this.temperatures.length];
        for (int i = 0; i < this.temperatures.length; ++i) {
            byte[] value = new byte[]{this.temperatures[i]};
            temperature[i] = GbtCommonConverters.ByteArraytoInt(value);
        }
        return temperature;
    }

    public int[] getFan_reading() {
        int[] reading = new int[this.fan_reading.length / 2];
        for (int i = 0; i < reading.length; ++i) {
            byte[] value = new byte[]{this.fan_reading[i * 2], this.fan_reading[i * 2 + 1]};
            reading[i] = GbtCommonConverters.ByteArraytoInt(value);
        }
        return reading;
    }

    public byte[] getFan_pwm() {
        return this.fan_pwm;
    }

    public byte getFanLastID() {
        return this.fanLastID;
    }

    public byte[] getCpu_performance() {
        return this.cpu_performance;
    }

    public int[] getPower_consumption() {
        int[] consumption = new int[this.power_consumption.length];
        for (int i = 0; i < consumption.length; ++i) {
            byte[] value = new byte[]{this.power_consumption[i]};
            consumption[i] = GbtCommonConverters.ByteArraytoInt(value);
        }
        return consumption;
    }

    public byte getCpu_watt() {
        return this.cpu_watt;
    }

    public byte[] getPadding4() {
        return this.padding4;
    }
}

