/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SDR;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Chassis.ChassisPowerIpmiOptions;
import Gbt.utility.Chassis.ChassisResponseData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SDR.SDRIpmiOptions;
import Gbt.utility.SDR.SdrRecordPayloadData;
import Gbt.utility.SDR.SdrRepositoryInfoData;
import Gbt.utility.SDR.SdrSensorReadingData;
import Gbt.utility.SDR.SdrSensorRecordsRawData;
import Gbt.utility.SDR.SdrSensorThresholdReadingData;
import Gbt.utility.SDR.record.CompactSensorRecord;
import Gbt.utility.SDR.record.FullSensorRecord;
import Gbt.utility.SDR.record.SensorRecord;
import Gbt.utility.SDR.record.SensorState;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.text.DecimalFormat;

public final class SDRCommand
extends AbstractCommand<Builder> {
    private static final int MAX_REPO_RECORD_ID = 65535;
    private static final int INITIAL_CHUNK_SIZE = 8;
    private static final int CHUNK_SIZE = 16;
    private static final int HEADER_SIZE = 5;
    public static final String COMMAND_NAME = "sdr";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private final DecimalFormat sdrReadingFormat;

    protected SDRCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.sdrReadingFormat = new DecimalFormat("#0.000");
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.ipmiReceiver != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        AbstractJSONPOJO ipmiResp = null;
        switch (((Builder)this.commandArgs).option) {
            case GET_SDR_REPOSITORY_INFO: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get sdr info.");
                ipmiResp = this.ipmiReceiver.sendIPMIRawCommand(handle, SDRIpmiOptions.GET_SDR_REPOSITORY_INFO, this.commandArgs, this.getCommandName(), this.commandID);
                if (this.isIPMISendMessagesFail(ipmiResp)) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
                SdrRepositoryInfoData sdrInfo = ipmiResp.castConcreteJSON(SdrRepositoryInfoData.class);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "sdr Version                         : " + GbtCommonConverters.bytesToHex(GbtCommonConverters.intToByte(sdrInfo.getSdrVersion().byteValue())));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Record Count                        : " + sdrInfo.getRecordCount());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Free Space                          : " + sdrInfo.getFreeSpace() + " bytes");
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Most recent Addition                : " + sdrInfo.getAddTimestamp());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Most recent Erase                   : " + sdrInfo.getDelTimestamp());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "sdr overflow                        : " + (sdrInfo.getSdrOverflow() != false ? "yes" : "no"));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "sdr Repository update Support       : " + (Object)((Object)sdrInfo.getUpdSupportModel()));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Delete sdr supported                : " + (sdrInfo.getDeleteSDRSupport() != false ? "yes" : "no"));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Partial Add sdr supported           : " + (sdrInfo.getPartialAddSDRSupport() != false ? "yes" : "no"));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Reserve sdr repository supported    : " + (sdrInfo.getReserveSupported() != false ? "yes" : "no"));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "sdr Repository Alloc info supported : " + (sdrInfo.getAllocInfoSupported() != false ? "yes" : "no"));
                this.commandResults.add(sdrInfo);
                break;
            }
            case GET_SDR_SENSOR_RECORDS: {
                ipmiResp = this.ipmiReceiver.sendIPMIRawCommand(handle, ChassisPowerIpmiOptions.STATUS, null, this.getCommandName(), this.commandID);
                if (this.isIPMISendMessagesFail(ipmiResp)) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
                if (!ipmiResp.castConcreteJSON(ChassisResponseData.class).getPowerOn().booleanValue()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Target node power is off.");
                    this.commandResults.add(ipmiResp);
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("%-16s | ", "Sensor Names :")).append(String.format("%-18s | ", "Sensor Reading :")).append(String.format("%-16s | ", "Sensor status :")).append(String.format("%-20s | ", "Lower Non Critical :")).append(String.format("%-20s | ", "Upper Non Critical :")).append(String.format("%-16s | ", "Lower Critical :")).append(String.format("%-16s | ", "Upper Critical :")).append(String.format("%-23s | ", "Lower Non Recoverable :")).append(String.format("%-23s | ", "Upper Non Recoverable :"));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, stringBuilder.toString());
                stringBuilder.setLength(0);
                ipmiResp = this.ipmiReceiver.sendIPMIRawCommand(handle, SDRIpmiOptions.GET_SDR_RESERVEID, this.commandArgs, this.getCommandName(), this.commandID);
                if (this.isIPMISendMessagesFail(ipmiResp)) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
                ((Builder)this.commandArgs).setSdrRecordPayload(ipmiResp.castConcreteJSON(SdrRecordPayloadData.class));
                while (((Builder)this.commandArgs).sdrRecordPayload.getRecordId() < 65535) {
                    SdrSensorReadingData readingData;
                    SensorRecord sdrRecord;
                    SdrSensorRecordsRawData sdrSensorRecordsData = null;
                    try {
                        ipmiResp = this.ipmiReceiver.sendIPMIRawCommandWithIpmie(handle, SDRIpmiOptions.GET_SDR_SENSOR_RECORDS, this.commandArgs, this.getCommandName(), this.commandID);
                        if (this.isIPMISendMessagesFail(ipmiResp)) {
                            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                            return false;
                        }
                        sdrSensorRecordsData = ipmiResp.castConcreteJSON(SdrSensorRecordsRawData.class);
                        if (sdrSensorRecordsData.getNextRecordId() == ((Builder)this.commandArgs).sdrRecordPayload.getRecordId()) {
                            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Invalid next record ID : it is same with previous record");
                            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                            return false;
                        }
                        ((Builder)this.commandArgs).sdrRecordPayload.setRecordId(sdrSensorRecordsData.getNextRecordId());
                        ((Builder)this.commandArgs).sdrRecordPayload.setOffset(0);
                        ((Builder)this.commandArgs).sdrRecordPayload.setBytesToRead(255);
                    }
                    catch (IPMIException ipmie) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI exception: " + (Object)((Object)ipmie.getCompletionCode()));
                        switch (ipmie.getCompletionCode()) {
                            case CannotRespond: 
                            case UnspecifiedError: {
                                int restSize;
                                ((Builder)this.commandArgs).sdrRecordPayload.setBytesToRead(8);
                                ipmiResp = this.ipmiReceiver.sendIPMIRawCommand(handle, SDRIpmiOptions.GET_SDR_SENSOR_RECORDS, this.commandArgs, this.getCommandName(), this.commandID);
                                if (this.isIPMISendMessagesFail(ipmiResp)) {
                                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                                    return false;
                                }
                                sdrSensorRecordsData = ipmiResp.castConcreteJSON(SdrSensorRecordsRawData.class);
                                int recordSize = TypeConverter.byteToInt(sdrSensorRecordsData.getSensorRecordData()[4]) + 5;
                                byte[] resultTemplate = new byte[recordSize];
                                System.arraycopy(sdrSensorRecordsData.getSensorRecordData(), 0, resultTemplate, 0, sdrSensorRecordsData.getSensorRecordData().length);
                                for (int readSize = 8; readSize < recordSize; readSize += restSize) {
                                    restSize = recordSize - readSize < 16 ? recordSize - readSize : 16;
                                    ((Builder)this.commandArgs).sdrRecordPayload.setOffset(readSize);
                                    ((Builder)this.commandArgs).sdrRecordPayload.setBytesToRead(restSize);
                                    ipmiResp = this.ipmiReceiver.sendIPMIRawCommand(handle, SDRIpmiOptions.GET_SDR_SENSOR_RECORDS, this.commandArgs, this.getCommandName(), this.commandID);
                                    if (this.isIPMISendMessagesFail(ipmiResp)) {
                                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                                        return false;
                                    }
                                    System.arraycopy(ipmiResp.castConcreteJSON(SdrSensorRecordsRawData.class).getSensorRecordData(), 0, resultTemplate, 8, 16);
                                }
                                sdrSensorRecordsData.setSensorRecordData(resultTemplate);
                                if (sdrSensorRecordsData.getNextRecordId() != ((Builder)this.commandArgs).sdrRecordPayload.getRecordId()) {
                                    ((Builder)this.commandArgs).sdrRecordPayload.setRecordId(sdrSensorRecordsData.getNextRecordId());
                                    ((Builder)this.commandArgs).sdrRecordPayload.setOffset(0);
                                    ((Builder)this.commandArgs).sdrRecordPayload.setBytesToRead(255);
                                    break;
                                }
                                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Invalid next record ID : it is same with previous record");
                                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                                return false;
                            }
                            default: {
                                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + ipmie.getMessage());
                                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                                return false;
                            }
                        }
                    }
                    if ((sdrRecord = SensorRecord.populateSensorRecord(sdrSensorRecordsData.getSensorRecordData())) == null) continue;
                    if (sdrRecord instanceof FullSensorRecord) {
                        FullSensorRecord fsr = sdrRecord.castConcreteJSON(FullSensorRecord.class);
                        ((Builder)this.commandArgs).setSensorNumber(fsr.getSensorNumber());
                        ipmiResp = this.ipmiReceiver.sendIPMIRawCommand(handle, SDRIpmiOptions.GET_SDR_SENSOR_READING, this.commandArgs, this.getCommandName(), this.commandID);
                        stringBuilder.append(String.format("%-16s | ", fsr.getName()));
                        if (this.isIPMISendMessagesFail(ipmiResp)) {
                            fsr.setSensorState(SensorState.Invalid);
                            stringBuilder.append(String.format("%-18s | ", "No Reading"));
                        } else {
                            readingData = ipmiResp.castConcreteJSON(SdrSensorReadingData.class);
                            readingData.getDoubleSensorReading(fsr);
                            fsr.setSensorState(readingData.getSensorState());
                            stringBuilder.append(String.format("%-18s | ", this.sdrReadingFormat.format(fsr.getSensorReading()) + " " + (Object)((Object)fsr.getSensorBaseUnit())));
                        }
                        ipmiResp = this.ipmiReceiver.sendIPMIRawCommand(handle, SDRIpmiOptions.GET_SDR_SENSOR_THRESHOLD, this.commandArgs, this.getCommandName(), this.commandID);
                        stringBuilder.append(String.format("%-16s | ", fsr.getName()));
                        if (!this.isIPMISendMessagesFail(ipmiResp)) {
                            SdrSensorThresholdReadingData thresholdData = ipmiResp.castConcreteJSON(SdrSensorThresholdReadingData.class);
                            fsr.thresholdRevision(thresholdData);
                        }
                        stringBuilder.append(String.format("%-16s | ", new Object[]{fsr.getSensorState()})).append(String.format("%-20s | ", fsr.isLowerNonCriticalThresholdReadable() != false ? this.sdrReadingFormat.format(fsr.getLowerNonCriticalThreshold()) + " " + (Object)((Object)fsr.getSensorBaseUnit()) : "N/A")).append(String.format("%-20s | ", fsr.isUpperNonCriticalThresholdReadable() != false ? this.sdrReadingFormat.format(fsr.getUpperNonCriticalThreshold()) + " " + (Object)((Object)fsr.getSensorBaseUnit()) : "N/A")).append(String.format("%-16s | ", fsr.isLowerCriticalThresholdReadable() != false ? this.sdrReadingFormat.format(fsr.getLowerCriticalThreshold()) + " " + (Object)((Object)fsr.getSensorBaseUnit()) : "N/A")).append(String.format("%-16s | ", fsr.isUpperCriticalThresholdReadable() != false ? this.sdrReadingFormat.format(fsr.getUpperCriticalThreshold()) + " " + (Object)((Object)fsr.getSensorBaseUnit()) : "N/A")).append(String.format("%-23s | ", fsr.isLowerNonRecoverableThresholdReadable() != false ? this.sdrReadingFormat.format(fsr.getLowerNonRecoverableThreshold()) + " " + (Object)((Object)fsr.getSensorBaseUnit()) : "N/A")).append(String.format("%-23s | ", fsr.isUpperNonRecoverableThresholdReadable() != false ? this.sdrReadingFormat.format(fsr.getUpperNonRecoverableThreshold()) + " " + (Object)((Object)fsr.getSensorBaseUnit()) : "N/A"));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, stringBuilder.toString());
                        stringBuilder.setLength(0);
                        this.commandResults.add(fsr);
                    }
                    if (!(sdrRecord instanceof CompactSensorRecord)) continue;
                    CompactSensorRecord csr = sdrRecord.castConcreteJSON(CompactSensorRecord.class);
                    ((Builder)this.commandArgs).setSensorNumber(csr.getSensorNumber());
                    ipmiResp = this.ipmiReceiver.sendIPMIRawCommand(handle, SDRIpmiOptions.GET_SDR_SENSOR_READING, this.commandArgs, this.getCommandName(), this.commandID);
                    if (csr.getName().contains("ME")) {
                        stringBuilder.append(String.format("%-16s | ", csr.getName() + (csr.getName().length() < 8 ? "\t" : "") + "\t| "));
                    } else {
                        stringBuilder.append(String.format("%-16s | ", csr.getName()));
                    }
                    if (this.isIPMISendMessagesFail(ipmiResp)) {
                        csr.setSensorState(SensorState.Invalid);
                        stringBuilder.append(String.format("%-18s | ", "No Reading")).append((Object)csr.getSensorState());
                    } else {
                        readingData = ipmiResp.castConcreteJSON(SdrSensorReadingData.class);
                        csr.setSensorState(readingData.getSensorState());
                        if (csr.getName().contains("ME")) {
                            byte timeoutStatus = (byte)(TypeConverter.doubleToBytes(readingData.getPlainSensorReading())[7] & 1);
                            byte busyStatus = (byte)(TypeConverter.doubleToBytes(readingData.getPlainSensorReading())[7] & 2);
                            if (timeoutStatus == 1) {
                                stringBuilder.append(String.format("%-18s | ", "Timeout (" + readingData.getPlainSensorReading() + ")")).append((Object)csr.getSensorState());
                            } else if (busyStatus == 1) {
                                stringBuilder.append(String.format("%-18s | ", "Node Busy (" + readingData.getPlainSensorReading() + ")")).append((Object)csr.getSensorState());
                            } else {
                                stringBuilder.append(String.format("%-18s | ", "Normal (" + readingData.getPlainSensorReading() + ")")).append((Object)csr.getSensorState());
                            }
                        } else {
                            stringBuilder.append(String.format("%-18s | ", "Presence detected")).append((Object)csr.getSensorState());
                        }
                    }
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, stringBuilder.toString());
                    stringBuilder.setLength(0);
                    this.commandResults.add(csr);
                }
                break;
            }
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get sdr complete.");
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private final boolean isIPMISendMessagesFail(AbstractJSONPOJO resp) {
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                this.commandResults.add(temp);
                return true;
            }
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.commandResults.add(temp);
            return false;
        }
        return false;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private SDRIpmiOptions option = SDRIpmiOptions.UNKNOWN;
        protected SdrRecordPayloadData sdrRecordPayload;
        protected Byte sensorNumber;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length != 1) {
                    return false;
                }
                this.setOption(SDRIpmiOptions.parse(this.args[0]));
            }
            return this.option != SDRIpmiOptions.UNKNOWN;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SDRCommand build() {
            return new SDRCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setOption(SDRIpmiOptions option) {
            this.option = option;
            return this.getThis();
        }

        protected Builder setSdrRecordPayload(SdrRecordPayloadData sdrRecordPayload) {
            this.sdrRecordPayload = sdrRecordPayload;
            return this.getThis();
        }

        protected Builder setSensorNumber(Byte sensorNumber) {
            this.sensorNumber = sensorNumber;
            return this.getThis();
        }
    }
}

