/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SEL;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SEL.SELEntryJSONData;
import Gbt.utility.SEL.SELIPMIOptions;
import Gbt.utility.SEL.SELInfoJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.sel.ReserveSelResponseData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class SELCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "sel";
    private static final int MAX_REPO_RECORD_ID = 65535;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected SELCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.ipmiReceiver != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        StringBuilder resultMesg = new StringBuilder();
        AbstractJSONPOJO data = null;
        block0 : switch (((Builder)this.commandArgs).selipmiOptions) {
            case Info: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start get SEL Info.");
                data = this.ipmiReceiver.sendIPMIRawCommand(handle, SELIPMIOptions.Info, this.commandArgs, COMMAND_NAME, this.commandID);
                if (data instanceof NullJSONData) {
                    NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.commandResults.add(temp);
                    if (!temp.isError()) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                if (!(data instanceof SELInfoJSONData)) break;
                SELInfoJSONData selinfo = data.castConcreteJSON(SELInfoJSONData.class);
                this.commandResults.add(selinfo);
                resultMesg.append("Version                 : ").append(selinfo.getSELVersion()).append("\n").append("Entries                 : ").append(selinfo.getEntriesCount()).append("\n").append("Free Space (bytes)      : ").append(selinfo.getFreeSpace()).append("\n").append("Percent Used            : ").append(selinfo.getPercentsUsage()).append("\n").append("Last Add Time           : ").append(selinfo.getAdditionTimestamp()).append("\n").append("Last Del Time           : ").append(selinfo.getEraseTimestamp()).append("\n").append("Overflow                : ").append(selinfo.isOverflow()).append("\n").append("Delete SEL Support      : ").append(selinfo.isDeleteSELSupport()).append("\n").append("Partial Add SEL Support : ").append(selinfo.isPartialAddSELSupport()).append("\n").append("Reserve Supported       : ").append(selinfo.isReserveSupported()).append("\n").append("Alloc Info Supported    : ").append(selinfo.isAllocInfoSupported()).append("\n");
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, resultMesg.toString());
                resultMesg.setLength(0);
                break;
            }
            case List: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start get SEL list.");
                ReserveSelResponseData reserveData = this.ipmiReceiver.getSELReserveID(handle, COMMAND_NAME, this.commandID);
                ((Builder)this.commandArgs).reserveID = reserveData.getRawReservationId();
                while (((Builder)this.commandArgs).recordID < 65535) {
                    data = this.ipmiReceiver.sendIPMIRawCommand(handle, SELIPMIOptions.List, this.commandArgs, COMMAND_NAME, this.commandID);
                    if (data instanceof NullJSONData) {
                        NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
                        this.commandResults.add(temp);
                        if (temp.isError()) {
                            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                            return false;
                        }
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                        break block0;
                    }
                    if (!(data instanceof SELEntryJSONData)) continue;
                    if (((Builder)this.commandArgs).recordID == 0) {
                        resultMesg.append(String.format("%-3s | ", "ID:")).append(String.format("%-12s | ", "Record Type:")).append(String.format("%-20s | ", "Time:")).append(String.format("%-24s | ", "Sensor Type:")).append(String.format("%-12s | ", "Sensor Num:")).append(String.format("%-12s | ", "Event Dir:")).append(String.format("%-32s | ", "Event Type:")).append(String.format("%-8s | ", "Reading:")).append("Additional Description");
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, resultMesg.toString());
                        resultMesg.setLength(0);
                    }
                    SELEntryJSONData selList = data.castConcreteJSON(SELEntryJSONData.class);
                    this.commandResults.add(selList);
                    resultMesg.append(String.format("%-3s | ", selList.getRecordId())).append(String.format("%-12s | ", new Object[]{selList.getRecordType()})).append(String.format("%-20s | ", DATE_FORMAT.format(selList.getTimestamp()))).append(String.format("%-24s | ", new Object[]{selList.getSensorType()})).append(String.format("%-12s | ", GbtCommonConverters.bytesToHex(selList.getSensorNumber()))).append(String.format("%-12s | ", new Object[]{selList.getEventDirection()})).append(String.format("%-32s | ", new Object[]{selList.getEventType()})).append(String.format("%-8s | ", GbtCommonConverters.bytesToHex(selList.getTriggeredReading()))).append(GbtCommonConverters.bytesToHexWithSpace(selList.getAdditionalDescription()));
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, resultMesg.toString());
                    ((Builder)this.commandArgs).setSELRecordID(selList.getNextRecordId().intValue());
                    resultMesg.setLength(0);
                }
                break;
            }
            case Clear: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start clear SEL.");
                ReserveSelResponseData reserveID = this.ipmiReceiver.getSELReserveID(handle, COMMAND_NAME, this.commandID);
                ((Builder)this.commandArgs).reserveID = reserveID.getRawReservationId();
                data = this.ipmiReceiver.sendIPMIRawCommand(handle, SELIPMIOptions.Clear, this.commandArgs, COMMAND_NAME, this.commandID);
                if (!(data instanceof NullJSONData)) break;
                NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.commandResults.add(temp);
                if (!temp.isError()) break;
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            case TimeGet: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start get SEL time.");
                data = this.ipmiReceiver.sendIPMIRawCommand(handle, SELIPMIOptions.TimeGet, this.commandArgs, COMMAND_NAME, this.commandID);
                if (data instanceof NullJSONData) {
                    NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.commandResults.add(temp);
                    if (!temp.isError()) break;
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                SELInfoJSONData selinfo = data.castConcreteJSON(SELInfoJSONData.class);
                this.commandResults.add(selinfo);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, selinfo.getSELCurrentTime());
                break;
            }
            case TimeSet: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start set SEL time.");
                data = this.ipmiReceiver.sendIPMIRawCommand(handle, SELIPMIOptions.TimeSet, this.commandArgs, COMMAND_NAME, this.commandID);
                if (!(data instanceof NullJSONData)) break;
                NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
                this.commandResults.add(temp);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SEL command complete.");
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final <T extends AbstractJSONPOJO> List<T> parserSELJSONDataList(List<AbstractJSONPOJO> selDataList, Class<T> clazz, boolean clear) {
        if (selDataList == null) {
            return null;
        }
        if (selDataList.isEmpty()) {
            return null;
        }
        ArrayList<T> output = new ArrayList<T>();
        for (AbstractJSONPOJO aSelDataList : selDataList) {
            if (aSelDataList.getClass() != clazz) continue;
            output.add(clazz.cast(aSelDataList));
        }
        if (clear) {
            selDataList.clear();
        }
        return output;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private SELIPMIOptions selipmiOptions = SELIPMIOptions.Unknown;
        protected int recordID = 0;
        protected byte[] reserveID;
        protected Date selDate;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 1) {
                    return false;
                }
                block6 : switch (this.args[0]) {
                    case "info": {
                        if (this.args.length != 1) {
                            return false;
                        }
                        this.selipmiOptions = SELIPMIOptions.Info;
                        break;
                    }
                    case "get": {
                        if (this.args.length != 1) {
                            return false;
                        }
                        this.selipmiOptions = SELIPMIOptions.List;
                        break;
                    }
                    case "clear": {
                        if (this.args.length != 1) {
                            return false;
                        }
                        this.selipmiOptions = SELIPMIOptions.Clear;
                        break;
                    }
                    case "time": {
                        if (this.args.length < 2) {
                            return false;
                        }
                        switch (this.args[1]) {
                            case "get": {
                                this.selipmiOptions = SELIPMIOptions.TimeGet;
                                break block6;
                            }
                            case "set": {
                                if (this.args.length != 3) {
                                    return false;
                                }
                                this.selDate = GbtCommonConverters.stringToJavaDate(this.args[2]);
                                this.selipmiOptions = SELIPMIOptions.TimeSet;
                                break block6;
                            }
                        }
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return this.selipmiOptions != SELIPMIOptions.TimeSet || this.selDate != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SELCommand build() {
            return new SELCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.recordID = 0;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setSELOption(SELIPMIOptions selipmiOptions) {
            this.selipmiOptions = selipmiOptions;
            return this.getThis();
        }

        public Builder setSELRecordID(int recordID) {
            this.recordID = recordID;
            return this.getThis();
        }

        public Builder setSELDate(Date date) {
            this.selDate = date;
            return this.getThis();
        }
    }
}

