/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import com.fasterxml.jackson.annotation.JsonValue;

public enum PhysicalMemoryArrayLocations {
    Other(1, "Other"),
    Unknown(2, "Unknown"),
    SystemBoardorMotherboard(3, "System board or motherboard"),
    ISAAddonCard(4, "ISA add-on card"),
    EISAAddonCard(5, "EISA add-on card"),
    PCIAddonCard(6, "PCI add-on card"),
    MCAAddonCard(7, "MCA add-on card"),
    PCMCIAAddonCard(8, "PCMCIA add-on card"),
    ProprietaryAddonCard(9, "Proprietary add-on card"),
    NuBus(10, "NuBus"),
    PC98C20AddonCard(-96, "PC-98/C20 add-on card"),
    PC98C24AddonCard(-95, "PC-98/C24 add-on card"),
    PC98EAddonCard(-94, "PC-98/E add-on card"),
    PC98LocalBusAddonCard(-93, "PC-98/Local bus add-on card");

    private static final byte CODE_1 = 1;
    private static final byte CODE_2 = 2;
    private static final byte CODE_3 = 3;
    private static final byte CODE_4 = 4;
    private static final byte CODE_5 = 5;
    private static final byte CODE_6 = 6;
    private static final byte CODE_7 = 7;
    private static final byte CODE_8 = 8;
    private static final byte CODE_9 = 9;
    private static final byte CODE_A = 10;
    private static final byte CODE_A0 = -96;
    private static final byte CODE_A1 = -95;
    private static final byte CODE_A2 = -94;
    private static final byte CODE_A3 = -93;
    private static final String ITEM_1 = "Other";
    private static final String ITEM_2 = "Unknown";
    private static final String ITEM_3 = "System board or motherboard";
    private static final String ITEM_4 = "ISA add-on card";
    private static final String ITEM_5 = "EISA add-on card";
    private static final String ITEM_6 = "PCI add-on card";
    private static final String ITEM_7 = "MCA add-on card";
    private static final String ITEM_8 = "PCMCIA add-on card";
    private static final String ITEM_9 = "Proprietary add-on card";
    private static final String ITEM_A = "NuBus";
    private static final String ITEM_A0 = "PC-98/C20 add-on card";
    private static final String ITEM_A1 = "PC-98/C24 add-on card";
    private static final String ITEM_A2 = "PC-98/E add-on card";
    private static final String ITEM_A3 = "PC-98/Local bus add-on card";
    private final byte code;
    private final String item;

    private PhysicalMemoryArrayLocations(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    public byte getCode() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final PhysicalMemoryArrayLocations parseLocation(byte rawLoc) {
        switch (rawLoc) {
            case 1: {
                return Other;
            }
            case 2: {
                return Unknown;
            }
            case 3: {
                return SystemBoardorMotherboard;
            }
            case 4: {
                return ISAAddonCard;
            }
            case 5: {
                return EISAAddonCard;
            }
            case 6: {
                return PCIAddonCard;
            }
            case 7: {
                return MCAAddonCard;
            }
            case 8: {
                return PCMCIAAddonCard;
            }
            case 9: {
                return ProprietaryAddonCard;
            }
            case 10: {
                return NuBus;
            }
            case -96: {
                return PC98C20AddonCard;
            }
            case -95: {
                return PC98C24AddonCard;
            }
            case -94: {
                return PC98EAddonCard;
            }
            case -93: {
                return PC98LocalBusAddonCard;
            }
        }
        return null;
    }
}

