/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SmbiosType131
extends SmbiosTypeBase {
    private String deviceID;
    private String vendorID;
    private String productName;
    private String macAddr;
    private String ipv4Addr;
    private String ipv6Addr;
    private String firmwareVer;
    private Byte linkStatus;
    private String slotNumber;
    private String portNumber;
    private String ipv4Gateway;
    private String ipv4Mask;
    private String ipv6Gateway;
    private String ipv6Mask;
    private Byte linkSpeed;
    private String onBoardIndex;

    public SmbiosType131(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        switch (this.length) {
            case 84: {
                this.deviceID = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(2));
                this.vendorID = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(2));
                byte gg = this.nextBYTE();
                if (gg != 0) {
                    this.productName = this.nextString();
                }
                this.macAddr = GbtCommonConverters.bytesToMacAddress(this.nextBYTES(6));
                this.ipv4Addr = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(4));
                this.ipv6Addr = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(16));
                gg = this.nextBYTE();
                if (gg != 0) {
                    this.firmwareVer = this.nextString();
                }
                this.linkStatus = this.nextBYTE();
                this.slotNumber = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(2));
                this.portNumber = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(2));
                this.ipv4Gateway = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(4));
                this.ipv4Mask = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(4));
                this.ipv6Gateway = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(16));
                this.ipv6Mask = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(16));
                this.linkSpeed = this.nextBYTE();
                this.onBoardIndex = GbtCommonConverters.bytesToHexReverse(this.nextBYTES(2));
                break;
            }
            case 64: {
                this.productName = "Intel ME structure";
                break;
            }
            default: {
                this.productName = "Unknown structure";
            }
        }
    }

    @JsonProperty(value="DeviceID")
    public String getDeviceID() {
        return this.deviceID;
    }

    @JsonProperty(value="VendorID")
    public String getVendorID() {
        return this.vendorID;
    }

    @JsonProperty(value="ProductName")
    public String getProductName() {
        return this.productName;
    }

    @JsonProperty(value="MacAddr")
    public String getMacAddr() {
        return this.macAddr;
    }

    @JsonProperty(value="Ipv4Addr")
    public String getIpv4Addr() {
        return this.ipv4Addr;
    }

    @JsonProperty(value="Ipv6Addr")
    public String getIpv6Addr() {
        return this.ipv6Addr;
    }

    @JsonProperty(value="FirmwareVer")
    public String getFirmwareVer() {
        return this.firmwareVer;
    }

    @JsonProperty(value="LinkStatus")
    public Byte getLinkStatus() {
        return this.linkStatus;
    }

    @JsonProperty(value="SlotNumber")
    public String getSlotNumber() {
        return this.slotNumber;
    }

    @JsonProperty(value="PortNumber")
    public String getPortNumber() {
        return this.portNumber;
    }

    @JsonProperty(value="Ipv4Gateway")
    public String getIpv4Gateway() {
        return this.ipv4Gateway;
    }

    @JsonProperty(value="Ipv4Mask")
    public String getIpv4Mask() {
        return this.ipv4Mask;
    }

    @JsonProperty(value="Ipv6Gateway")
    public String getIpv6Gateway() {
        return this.ipv6Gateway;
    }

    @JsonProperty(value="Ipv6Mask")
    public String getIpv6Mask() {
        return this.ipv6Mask;
    }

    @JsonProperty(value="LinkSpeed")
    public Byte getLinkSpeed() {
        return this.linkSpeed;
    }

    @JsonProperty(value="OnBoardIndex")
    public String getOnBoardIndex() {
        return this.onBoardIndex;
    }
}

