/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.SMBIOS.PhysicalMemoryArrayErrs;
import Gbt.utility.SMBIOS.PhysicalMemoryArrayLocations;
import Gbt.utility.SMBIOS.PhysicalMemoryArrayUses;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SmbiosType16
extends SmbiosTypeBase {
    private PhysicalMemoryArrayLocations location;
    private PhysicalMemoryArrayUses use;
    private PhysicalMemoryArrayErrs memoryErrorCorrection;
    private String maximumCapacity;
    private String memoryErrorInformationHandle;
    private String numberofMemoryDevices;
    private String extendedMaximumCapacity;

    public SmbiosType16(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        byte locationRaw = this.nextBYTE();
        byte useRaw = this.nextBYTE();
        byte memoryErrorCorrectionRaw = this.nextBYTE();
        byte[] maximumCapacityRaw = this.nextBYTES(4);
        byte[] memoryErrorInformationHandleRaw = this.nextBYTES(2);
        byte[] numberofMemoryDevicesRaw = this.nextBYTES(2);
        byte[] extendedMaximumCapacityRaw = this.nextBYTES(8);
        this.location = PhysicalMemoryArrayLocations.parseLocation(locationRaw);
        this.use = PhysicalMemoryArrayUses.parseUse(useRaw);
        this.memoryErrorCorrection = PhysicalMemoryArrayErrs.parseErrCorrection(memoryErrorCorrectionRaw);
        this.maximumCapacity = this.getByteString(maximumCapacityRaw);
        this.memoryErrorInformationHandle = this.getByteString(memoryErrorInformationHandleRaw);
        this.numberofMemoryDevices = this.getByteString(numberofMemoryDevicesRaw);
        this.extendedMaximumCapacity = this.getByteString(extendedMaximumCapacityRaw);
    }

    @JsonProperty(value="Location")
    public PhysicalMemoryArrayLocations getLocation() {
        return this.location;
    }

    @JsonProperty(value="Use")
    public PhysicalMemoryArrayUses getUse() {
        return this.use;
    }

    @JsonProperty(value="MemoryErrorCorrection")
    public PhysicalMemoryArrayErrs getMemoryErrorCorrection() {
        return this.memoryErrorCorrection;
    }

    @JsonProperty(value="MaximumCapacity")
    public String getMaximumCapacity() {
        return this.maximumCapacity;
    }

    @JsonProperty(value="MemoryErrorInformationHandle")
    public String getMemoryErrorInformationHandle() {
        return this.memoryErrorInformationHandle;
    }

    @JsonProperty(value="NumberofMemoryDevices")
    public String getNumberofMemoryDevices() {
        return this.numberofMemoryDevices;
    }

    @JsonProperty(value="ExtendedMaximumCapacity")
    public String getExtendedMaximumCapacity() {
        return this.extendedMaximumCapacity;
    }
}

