/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.SMBIOS.BaseBoardTypes;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SmbiosType2
extends SmbiosTypeBase {
    private String manufacturer;
    private String productName;
    private String version;
    private String serialNumber;
    private String assetTag;
    private Byte featureFlags;
    private String chassisLocation;
    private BaseBoardTypes boardType;

    public SmbiosType2(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        this.skipBYTES(4);
        this.manufacturer = this.nextString();
        this.productName = this.nextString();
        this.version = this.nextString();
        this.serialNumber = this.nextString();
        this.assetTag = this.nextString();
        this.featureFlags = this.nextBYTE();
        this.chassisLocation = this.nextString();
        this.skipBYTES(2);
        this.boardType = BaseBoardTypes.parse(this.nextBYTE());
    }

    @JsonProperty(value="Manufacturer")
    public String getManufacturer() {
        return this.manufacturer;
    }

    @JsonProperty(value="ProductName")
    public String getProductName() {
        return this.productName;
    }

    @JsonProperty(value="Version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="SerialNumber")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="AssetTag")
    public String getAssetTag() {
        return this.assetTag;
    }

    @JsonProperty(value="FeatureFlags")
    public Byte getFeatureFlags() {
        return this.featureFlags;
    }

    @JsonProperty(value="ChassisLocation")
    public String getChassisLocation() {
        return this.chassisLocation;
    }

    @JsonProperty(value="BoardType")
    public BaseBoardTypes getBoardType() {
        return this.boardType;
    }
}

