/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.SKU;

import Gbt.core.commands.CommandTask;
import Gbt.core.engines.DefaultTaskManager;
import Gbt.core.engines.EngineThreadPoolFactory;
import Gbt.core.engines.EngineThreadPoolTypes;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.ipmi.GbtIPMIConnector;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.Update.PreUpdateCommand;
import Gbt.utility.Update.SKU.SKUMasterWriteReadCommand;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.menu.ParserArgument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;

public final class SKU {
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "password";

    private SKU() {
    }

    public static void main(String[] args) {
        String commandName;
        System.out.println("******************************");
        System.out.println("*   GIGABYTE(TM) SKU v0.13   *");
        System.out.println("******************************");
        ParserArgument parserArg = new ParserArgument(args);
        if (!parserArg.checkArgs()) {
            SKU.printMenu();
            System.exit(1);
        }
        if (!parserArg.parserOptions(commandName = parserArg.getCommandName())) {
            parserArg.printOptionHelp("java -jar SKU.jar <options> update sku <FW package>");
            SKU.printMenu();
            System.exit(1);
        }
        if (commandName.equalsIgnoreCase("update")) {
            if (!SKU.updateExecutes(parserArg.getBMCIPaddresses(), parserArg.getBMCUsername(), parserArg.getBMCPassword(), parserArg.getRestArgument())) {
                GbtIPMIConnector.disconnect();
                GbtIPMICommandReceiver.getInstance().closeReceivers();
                System.exit(1);
            }
        } else if (commandName.equalsIgnoreCase("master")) {
            if (!SKU.masterWriteReadExecutes(parserArg.getBMCIPaddresses(), parserArg.getBMCUsername(), parserArg.getBMCPassword(), parserArg.getRestArgument())) {
                GbtIPMIConnector.disconnect();
                GbtIPMICommandReceiver.getInstance().closeReceivers();
                System.exit(1);
            }
        } else {
            SKU.printMenu();
            System.exit(1);
        }
        GbtIPMIConnector.disconnect();
        GbtIPMICommandReceiver.getInstance().closeReceivers();
        System.exit(0);
    }

    private static final boolean updateExecutes(String[] bmcIPAddresses, String bmcUsername, String bmcpPassword, String[] restArgs) {
        CommandTaskRecords records;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("preupdate")).setThreadNumber(bmcIPAddresses.length)).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String bmcIPAddress : bmcIPAddresses) {
            PreUpdateCommand preUpdateCommand = ((PreUpdateCommand.Builder)new PreUpdateCommand.Builder().setBMCIP(bmcIPAddress).setBMCUsername(bmcUsername).setBMCPassword(bmcpPassword).setCommandLineArgs(restArgs)).build();
            if (!preUpdateCommand.checkAll()) {
                SKU.printMenu();
                try {
                    taskManager.close();
                    taskManager = null;
                    factory = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            taskManager.addEngineTask(new CommandTask(preUpdateCommand));
        }
        if (!taskManager.executeTasks()) {
            try {
                taskManager.close();
                taskManager = null;
                factory = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
        ArrayList<MainUpdateCommand> updateCommands = new ArrayList<MainUpdateCommand>();
        boolean waitAns = false;
        int success = 0;
        for (String string : taskManager.getAllResults().keySet()) {
            records = ((CommandTaskRecords)taskManager.getAllResults().get(string)).castSubRecords(CommandTaskRecords.class);
            if (!records.getStates().isPass()) continue;
            ++success;
            AbstractJSONPOJO fwInfo = null;
            BMCInfoJSONData bmcInfo = null;
            for (AbstractJSONPOJO result : records.getCommand(PreUpdateCommand.class).getCommandResults()) {
                if (result instanceof BMCInfoJSONData) {
                    bmcInfo = result.castConcreteJSON(BMCInfoJSONData.class);
                    continue;
                }
                fwInfo = result;
            }
            if (fwInfo == null) {
                System.out.println("SKU FW info is null!");
                System.exit(1);
            }
            if (bmcInfo == null) {
                System.out.println("BMC info is null!");
                System.exit(1);
            }
            if (!records.getCommand(PreUpdateCommand.class).isContinue()) {
                waitAns = true;
            }
            updateCommands.add(((MainUpdateCommand.Builder)new MainUpdateCommand.Builder().setCommandLineArgs(restArgs)).setPreUpdateFWInfo(fwInfo).setBmcInfoJSONData(bmcInfo).setBMCUsername(bmcUsername).setBMCPassword(bmcpPassword).build());
        }
        System.out.println("SKU check total success nodes : " + success + "\t fail nodes : " + (bmcIPAddresses.length - success));
        try {
            taskManager.close();
            taskManager = null;
            factory = null;
        }
        catch (Exception e) {
            return false;
        }
        if (success == 0) {
            return false;
        }
        if (waitAns) {
            Iterator<String> scanner = new Scanner(System.in);
            System.out.println("\n** Do you want to continue update the success nodes of preupdate (Y/N) ? **");
            String string = ((Scanner)scanner).nextLine();
            if (string.toUpperCase().equals("N")) {
                ((Scanner)scanner).close();
                return true;
            }
            ((Scanner)scanner).close();
        }
        factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("update")).setThreadNumber(updateCommands.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        taskManager = new DefaultTaskManager(factory);
        for (MainUpdateCommand mainUpdateCommand : updateCommands) {
            if (!mainUpdateCommand.checkAll()) {
                SKU.printMenu();
                try {
                    taskManager.close();
                    taskManager = null;
                    factory = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            taskManager.addEngineTask(new CommandTask(mainUpdateCommand));
        }
        if (!taskManager.executeTasks()) {
            try {
                taskManager.close();
                taskManager = null;
                factory = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
        success = 0;
        for (String string : taskManager.getAllResults().keySet()) {
            records = ((CommandTaskRecords)taskManager.getAllResults().get(string)).castSubRecords(CommandTaskRecords.class);
            if (!records.getStates().isPass()) continue;
            ++success;
        }
        System.out.println("SKU update total success nodes : " + success + "\t fail nodes : " + (updateCommands.size() - success));
        try {
            taskManager.close();
            taskManager = null;
            factory = null;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final boolean masterWriteReadExecutes(String[] bmcIPAddresses, String bmcUsername, String bmcpPassword, String[] restArgs) {
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("sku")).setThreadNumber(bmcIPAddresses.length)).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String bmcIPAddress : bmcIPAddresses) {
            SKUMasterWriteReadCommand command = ((SKUMasterWriteReadCommand.Builder)new SKUMasterWriteReadCommand.Builder().setBMCIP(bmcIPAddress).setBMCUsername(bmcUsername).setBMCPassword(bmcpPassword).setCommandLineArgs(restArgs)).build();
            if (!command.checkAll()) {
                SKU.printMenu();
                try {
                    taskManager.close();
                    taskManager = null;
                    factory = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (!taskManager.executeTasks()) {
            try {
                taskManager.close();
                taskManager = null;
                factory = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (!records.getStates().isPass()) continue;
            ++success;
        }
        System.out.println("SKU check total success nodes : " + success + "\t fail nodes : " + (bmcIPAddresses.length - success));
        try {
            taskManager.close();
            taskManager = null;
            factory = null;
        }
        catch (Exception e) {
            return false;
        }
        return success != 0;
    }

    private static final void printMenu() {
        System.out.println("SKU Utility\tUsage hints:");
        System.out.println("\tjava -jar SKU.jar -H 10.1,27.101 -U admin -P password update sku /home/SKU.BIN");
        System.out.println("\tjava -jar SKU.jar -S rmcp,10.1,27.1,10.1.27.100 -U admin -P password update sku /home/SKU.BIN");
        System.out.println("\t");
        System.out.println("\tjava -jar SKU.jar -H 10.1,27.101 -U admin -P password master sku.xml CSN=1234567 BSN=1234567 PSN=1234567 PN=AABBAABB");
    }
}

