/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update;

import com.fasterxml.jackson.annotation.JsonValue;

public enum UpdateType {
    UNKNOWN((byte)0, null, "Unknown"),
    BMC((byte)0, null, "BMC"),
    BIOS((byte)2, 4, "BIOS"),
    CPLDBPB((byte)4, null, "BPB_CPLD"),
    CPLDMB((byte)5, null, "MB_CPLD"),
    CPLDSCM((byte)0, null, "MB_SCM"),
    PSU((byte)6, null, "PSU"),
    SKU((byte)3, null, "SKU"),
    CMC((byte)0, null, "CMC"),
    SCP(null, 8, "SCP"),
    FPGA(null, null, "FPGA"),
    EROT(null, null, "EROT"),
    VBIOS(null, null, "VBIOS");

    private static final byte UPDATE_BMC_CODE = 0;
    private static final byte UPDATE_BIOS_CODE = 2;
    private static final byte UPDATE_CPLD_BPB_CODE = 4;
    private static final byte UPDATE_CPLD_MB_CODE = 5;
    private static final byte UPDATE_CPLD_SCM_CODE = 0;
    private static final byte UPDATE_PSU_CODE = 6;
    private static final byte UPDATE_SKU_CODE = 3;
    private static final byte UPDATE_CMC_CODE = 0;
    private static final int UPDATE_HPM_BIOS_CODE = 4;
    private static final int UPDATE_HPM_SCP_CODE = 8;
    private static final String UNKNOWN_ITEM = "Unknown";
    private static final String UPDATE_BMC_ITEM = "BMC";
    private static final String UPDATE_BIOS_ITEM = "BIOS";
    private static final String UPDATE_CPLD_BPB_ITEM = "BPB_CPLD";
    private static final String UPDATE_CPLD_MB_ITEM = "MB_CPLD";
    private static final String UPDATE_CPLD_SCM_ITEM = "MB_SCM";
    private static final String UPDATE_PSU_ITEM = "PSU";
    private static final String UPDATE_SKU_ITEM = "SKU";
    private static final String UPDATE_CMC_ITEM = "CMC";
    private static final String UPDATE_SCP_ITEM = "SCP";
    private static final String UPDATE_FPGA_ITEM = "FPGA";
    private static final String UPDATE_EROT_ITEM = "EROT";
    private static final String UPDATE_VBIOS_ITEM = "VBIOS";
    private final Byte code;
    private final Integer hpmCode;
    private final String item;

    private UpdateType(Byte code, Integer hpmCode, String item) {
        this.code = code;
        this.hpmCode = hpmCode;
        this.item = item;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public Byte getTypeCode() {
        return this.code;
    }

    public Integer getHpmCode() {
        return this.hpmCode;
    }

    public boolean isBMC() {
        return this == BMC;
    }

    public boolean isBIOS() {
        return this == BIOS;
    }

    public boolean isCPLD() {
        return this == CPLDBPB || this == CPLDMB;
    }

    public boolean isPSU() {
        return this == PSU;
    }

    public boolean isSKU() {
        return this == SKU;
    }

    public boolean isCMC() {
        return this == CMC;
    }

    public boolean isFPGA() {
        return this == FPGA;
    }

    public static final UpdateType parse(String typeName) {
        switch (typeName.toUpperCase()) {
            case "BMC": {
                return BMC;
            }
            case "BIOS": {
                return BIOS;
            }
            case "BPB_CPLD": {
                return CPLDBPB;
            }
            case "MB_CPLD": {
                return CPLDMB;
            }
            case "PSU": {
                return PSU;
            }
            case "SKU": {
                return SKU;
            }
            case "CMC": {
                return CMC;
            }
            case "SCP": {
                return SCP;
            }
            case "FPGA": {
                return FPGA;
            }
            case "EROT": {
                return EROT;
            }
            case "VBIOS": {
                return VBIOS;
            }
        }
        return UNKNOWN;
    }

    public static final UpdateType parse(String typeName, String subTypeName) {
        switch (typeName.toUpperCase()) {
            case "BMC": {
                return BMC;
            }
            case "BIOS": {
                return BIOS;
            }
            case "BPB_CPLD": {
                return CPLDBPB;
            }
            case "MB_CPLD": {
                return CPLDMB;
            }
            case "MB_SCM": {
                return CPLDSCM;
            }
            case "CPLD": {
                if (subTypeName == null) {
                    return UNKNOWN;
                }
                switch (subTypeName.toUpperCase()) {
                    case "BPB": {
                        return CPLDBPB;
                    }
                    case "MB": {
                        return CPLDMB;
                    }
                    case "SCM": {
                        return CPLDSCM;
                    }
                }
                return UNKNOWN;
            }
            case "PSU": {
                return PSU;
            }
            case "SKU": {
                return SKU;
            }
            case "CMC": {
                return CMC;
            }
            case "SCP": {
                return SCP;
            }
            case "FPGA": {
                return FPGA;
            }
            case "EROT": {
                return EROT;
            }
            case "VBIOS": {
                return VBIOS;
            }
        }
        return UNKNOWN;
    }
}

