/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmclanconfig;

import com.fasterxml.jackson.annotation.JsonValue;

public enum BMCLanConfigIPSource {
    Unspecified("Unspecified", 0),
    StaticAddress("Static Address", 1),
    DHCPAddress("DHCP Address", 2),
    BIOSSystemSoftware("Load by BIOS or System Software", 3),
    OtherAddress("Load by other address assignment protocol", 4);

    private static final String UNSPECIFIED_ITEM = "Unspecified";
    private static final String STATIC_ADDRESS_ITEM = "Static Address";
    private static final String DHCP_ADDRESS_ITEM = "DHCP Address";
    private static final String BIOS_SYSTEM_SOFTWARE_ITEM = "Load by BIOS or System Software";
    private static final String OTHER_ADDRESS_ITEM = "Load by other address assignment protocol";
    private static final byte UNSPECIFIED_BYTE = 0;
    private static final byte STATIC_ADDRESS_BYTE = 1;
    private static final byte DHCP_ADDRESS_BYTE = 2;
    private static final byte BIOS_SYSTEM_SOFTWARE_BYTE = 3;
    private static final byte OTHER_ADDRESS_BYTE = 4;
    private final String item;
    private final byte matchByte;

    private BMCLanConfigIPSource(String item, byte matchByte) {
        this.item = item;
        this.matchByte = matchByte;
    }

    public String getItem() {
        return this.item;
    }

    public byte getMatchByte() {
        return this.matchByte;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final BMCLanConfigIPSource parseByByte(byte matchByte) {
        switch (matchByte) {
            case 0: {
                return Unspecified;
            }
            case 1: {
                return StaticAddress;
            }
            case 2: {
                return DHCPAddress;
            }
            case 3: {
                return BIOSSystemSoftware;
            }
            case 4: {
                return OtherAddress;
            }
        }
        return Unspecified;
    }

    public static final BMCLanConfigIPSource parseByStrings(String rawStrings) {
        if (rawStrings == null) {
            return Unspecified;
        }
        switch (rawStrings.toLowerCase()) {
            case "unspecified": {
                return Unspecified;
            }
            case "static": {
                return StaticAddress;
            }
            case "dhcp": {
                return DHCPAddress;
            }
            case "bios": {
                return BIOSSystemSoftware;
            }
            case "other": {
                return OtherAddress;
            }
        }
        return Unspecified;
    }
}

