/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.firmwareBackup;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.firmwareBackup.BIOSActiveStatus;
import Gbt.utility.firmwareBackup.BMCActiveStatus;
import Gbt.utility.firmwareBackup.ImageActiveStatusResult;
import Gbt.utility.firmwareBackup.ImageChecksumResult;
import Gbt.utility.imageChecksum.ImageChecksumCommand;

public enum ImageChecksumIpmiOptions implements GbtIPMIOptions<ImageChecksumCommand.Builder>
{
    GET_CHECKSUM_BIOS0(0, "BIOS0 image checksum", 1),
    GET_CHECKSUM_BIOS1(1, "BIOS1 image checksum", 2),
    GET_CHECKSUM_BMC0(2, "BMC0 image checksum", 17),
    GET_CHECKSUM_BMC1(3, "BMC1 image checksum", 18),
    GET_IMAGE_ACTIVE(4, "Image activate status", 80);

    private static final String GET_CHECKSUM_BIOS0_ITEM = "BIOS0 image checksum";
    private static final String GET_CHECKSUM_BIOS1_ITEM = "BIOS1 image checksum";
    private static final String GET_CHECKSUM_BMC0_ITEM = "BMC0 image checksum";
    private static final String GET_CHECKSUM_BMC1_ITEM = "BMC1 image checksum";
    private static final String GET_IMAGE_ACTIVE_ITEM = "Image activate status";
    private static final byte NetFn = 46;
    private final int optionCode;
    private final String item;
    private static final byte cmd = 33;
    private byte operateByte;

    private ImageChecksumIpmiOptions(int optionCode, String item, byte operateByte) {
        this.optionCode = optionCode;
        this.item = item;
        this.operateByte = operateByte;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return 33;
    }

    @Override
    public byte[] rebuildRequestData(ImageChecksumCommand.Builder commandArgs) {
        return new byte[]{10, 60, 0, -124, this.operateByte};
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        switch (this) {
            case GET_CHECKSUM_BMC0: 
            case GET_CHECKSUM_BMC1: 
            case GET_CHECKSUM_BIOS0: 
            case GET_CHECKSUM_BIOS1: {
                ImageChecksumResult result = new ImageChecksumResult();
                byte[] resp = gbtResponseData.getAllResponseData();
                if (resp.length >= 7) {
                    byte[] checksum = new byte[]{resp[3], resp[4], resp[5], resp[6]};
                    result.setCheckusm(checksum);
                    result.setOwner(this.item);
                }
                return result;
            }
            case GET_IMAGE_ACTIVE: {
                ImageActiveStatusResult activeStatus = new ImageActiveStatusResult();
                byte[] resp = gbtResponseData.getAllResponseData();
                if (resp.length >= 5) {
                    byte bmcStatus = resp[3];
                    byte biosStatus = resp[4];
                    activeStatus.setBmcActiveStatus(BMCActiveStatus.parse(bmcStatus).getActiveStatus());
                    activeStatus.setBiosAcvtiveStatus(BIOSActiveStatus.parse(biosStatus).getActiveStatus());
                }
                return activeStatus;
            }
        }
        return null;
    }
}

