/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.networkconfig;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.networkconfig.BMCNetworkConfigCommand;
import Gbt.utility.networkconfig.BMCNetworkHostnameData;

public enum BMCNetworkConfigIPMIOptions implements GbtIPMIOptions<BMCNetworkConfigCommand.Builder>
{
    SET_GENERAL(0, "Set general configurations", 80),
    GET_HOSTNAME(1, "Get host name", 81);

    private static final String SET_GENERAL_ITEM = "Set general configurations";
    private static final String GET_HOSTNAME_ITEM = "Get host name";
    private static final byte NET_FN = 46;
    private final int optionCode;
    private final String item;
    private final byte commandCode;

    private BMCNetworkConfigIPMIOptions(int optionCode, String item, byte commandCode) {
        this.optionCode = optionCode;
        this.item = item;
        this.commandCode = commandCode;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return this.commandCode;
    }

    @Override
    public byte[] rebuildRequestData(BMCNetworkConfigCommand.Builder commandArgs) {
        switch (this) {
            case SET_GENERAL: {
                byte[] requestData = new byte[135];
                requestData[0] = 10;
                requestData[1] = 60;
                requestData[2] = 0;
                requestData[3] = 1;
                System.arraycopy(commandArgs.hostName.getBytes(), 0, requestData, 4, commandArgs.hostName.getBytes().length);
                System.arraycopy(commandArgs.domainName.getBytes(), 0, requestData, 68, commandArgs.domainName.getBytes().length);
                System.arraycopy(new byte[]{commandArgs.networkMode.getCode()}, 0, requestData, 132, 1);
                System.arraycopy(new byte[]{commandArgs.dnsStates.getCode()}, 0, requestData, 133, 1);
                System.arraycopy(new byte[]{commandArgs.dynamicDNSStates.getCode()}, 0, requestData, 134, 1);
                return requestData;
            }
            case GET_HOSTNAME: {
                return new byte[]{10, 60, 0, 1, 1};
            }
        }
        return new byte[0];
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        switch (this) {
            case SET_GENERAL: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case GET_HOSTNAME: {
                byte[] rawHostname = new byte[64];
                System.arraycopy(gbtResponseData.getAllResponseData(), 3, rawHostname, 0, rawHostname.length);
                BMCNetworkHostnameData data = new BMCNetworkHostnameData();
                data.setHostname(GbtCommonConverters.asciiBytesToString(rawHostname));
                return data;
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown IPMI option.");
    }
}

