/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum AccountServiceApiOptions implements RedfishApiOptions
{
    UNKNOWN("unknown", "/redfish/v1/AccountService"),
    GET("get", "/redfish/v1/AccountService/Accounts"),
    LIST("list", "/redfish/v1/AccountService/Accounts"),
    ADD("add", "/redfish/v1/AccountService/Accounts"),
    MODIFY("modify", "/redfish/v1/AccountService/Accounts"),
    DELETE("delete", "/redfish/v1/AccountService/Accounts"),
    INFO("info", "/redfish/v1/AccountService"),
    CONFIG("config", "/redfish/v1/AccountService"),
    PAMINFO("paminfo", "/redfish/v1/AccountService/Configurations"),
    PAMCONFIG("pamconfig", "/redfish/v1/AccountService/Configurations");

    private static final String ACCOUNTSERVICE_URI = "/redfish/v1/AccountService";
    private static final String ACCOUNTS_URI = "/redfish/v1/AccountService/Accounts";
    private static final String PAM_CONFIG_URI = "/redfish/v1/AccountService/Configurations";
    private static final String UNKNOWN_ITEM = "unknown";
    private static final String GET_ITEM = "get";
    private static final String LIST_ITEM = "list";
    private static final String ADD_ITEM = "add";
    private static final String MODIFY_ITEM = "modify";
    private static final String DELETE_ITEM = "delete";
    private static final String INFO_ITEM = "info";
    private static final String CONFIG_ITEM = "config";
    private static final String PAMINFO_ITEM = "paminfo";
    private static final String PAMCONFIG_ITEM = "pamconfig";
    private final String optionName;
    private final String mainUri;

    private AccountServiceApiOptions(String optionName, String mainUri) {
        this.optionName = optionName;
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return this.optionName;
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            case GET: {
                return "Account ID is not assiend.";
            }
            case ADD: {
                return "Account upload data is not assiend or invalid.";
            }
            case MODIFY: {
                return "Account ID is not assiend for modify.";
            }
            case DELETE: {
                return "Account ID is not assiend for delete.";
            }
            case CONFIG: {
                return "Account service configuration data is not assiend or invalid.";
            }
            case PAMINFO: {
                return "Account service PAM configuration data is not present.";
            }
            case PAMCONFIG: {
                return "Account service PAM configuration data is not assiend or invalid.";
            }
        }
        return "Unsupport option of account service API.";
    }

    public static final AccountServiceApiOptions parse(String rawOptionName) {
        switch (rawOptionName.toLowerCase()) {
            case "get": {
                return GET;
            }
            case "list": {
                return LIST;
            }
            case "add": {
                return ADD;
            }
            case "modify": {
                return MODIFY;
            }
            case "delete": {
                return DELETE;
            }
            case "info": {
                return INFO;
            }
            case "config": {
                return CONFIG;
            }
            case "paminfo": {
                return PAMINFO;
            }
            case "pamconfig": {
                return PAMCONFIG;
            }
        }
        return UNKNOWN;
    }
}

