/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum NetworkProtocolApiOptions implements RedfishApiOptions
{
    UNKNOWN("/NetworkProtocol"),
    GET("/NetworkProtocol"),
    MODIFY("/NetworkProtocol");

    private static final String MAIN_URI = "/NetworkProtocol";
    private final String mainUri;

    private NetworkProtocolApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            case MODIFY: {
                return "Upload json data of network protocol is empty.";
            }
        }
        return "Unsupport option of network protocol service API.";
    }

    public static final NetworkProtocolApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return NetworkProtocolApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

