/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum SystemsApiOptions implements RedfishApiOptions
{
    UNKNOWN("/redfish/v1/Systems"),
    INFO("/redfish/v1/Systems"),
    BOOT("/redfish/v1/Systems/<id>/SD"),
    RESET("/redfish/v1/Systems/<id>/Actions/ComputerSystem.Reset"),
    IDENTIFY("/redfish/v1/Systems");

    private static final String SYSTEM_ROOT_URI = "/redfish/v1/Systems";
    private static final String SYSTEM_BOOT_URI = "/redfish/v1/Systems/<id>/SD";
    private static final String SYSTEM_RESET_URI = "/redfish/v1/Systems/<id>/Actions/ComputerSystem.Reset";
    private final String mainUri;

    private SystemsApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            default: 
        }
        return "Unsupport option of the Redfish systems service API.";
    }

    public static final SystemsApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return SystemsApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

