/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.common.chassis.ChassisResetAction;
import Gbt.utility.redfish.models.common.chassis.ChassisResource;
import Gbt.utility.redfish.models.common.identifier.IndicatorLED;
import Gbt.utility.redfish.options.ChassisApiOptions;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class ChassisApi
extends RedfishApiService<Payload> {
    protected ChassisApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.CHASSIS.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(ChassisApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setChassisId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
            case IDENTIFY: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.Chassis);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setChassisId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.Chassis);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case RESET: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setChassisId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case IDENTIFY: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.Chassis);
                }
                if (((Payload)this.servicePayload).getIndicatorLED() != IndicatorLED.Unknown) {
                    ChassisResource chassisResource = new ChassisResource();
                    chassisResource.setIndicatorLED(((Payload)this.servicePayload).getIndicatorLED());
                    return this.uploadDataValidation(RedfishResourceTypes.Chassis, chassisResource);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case RESET: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                }
                if (((Payload)this.servicePayload).getResetAction() != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.Ignore, ((Payload)this.servicePayload).getResetAction());
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((Payload)this.servicePayload).getChassisId() == null) {
            ((Payload)this.servicePayload).setChassisId("Self");
        }
        switch ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).getChassisId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case IDENTIFY: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri() + "/" + ((Payload)this.servicePayload).getChassisId());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setHeaders("If-Match", etag)).setServiceId(((Payload)this.servicePayload).getChassisId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case RESET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((Payload)this.servicePayload).getChassisId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ChassisApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, ChassisApiOptions> {
        private String chassisId;
        private IndicatorLED indicatorLED;
        private ChassisResetAction resetAction;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(ChassisApiOptions.UNKNOWN);
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(ChassisApiOptions.UNKNOWN);
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public ChassisApi build() {
            return new ChassisApi(this);
        }

        public String getChassisId() {
            return this.chassisId;
        }

        public Payload setChassisId(String chassisId) {
            this.chassisId = chassisId;
            return this.getThis();
        }

        public IndicatorLED getIndicatorLED() {
            return this.indicatorLED;
        }

        public Payload setIndicatorLED(IndicatorLED indicatorLED) {
            this.indicatorLED = indicatorLED;
            return this.getThis();
        }

        public ChassisResetAction getResetAction() {
            return this.resetAction;
        }

        public Payload setResetAction(ChassisResetAction resetAction) {
            this.resetAction = resetAction;
            return this.getThis();
        }
    }
}

