/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.options.EventServiceApiOptions;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class EventServiceApi
extends RedfishApiService<PayLoad> {
    protected EventServiceApi(PayLoad servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.EVENTSERVICE.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((PayLoad)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((PayLoad)this.servicePayload).setServiceOption(EventServiceApiOptions.parse(((PayLoad)this.servicePayload).getRestRawArgs()[0]));
        switch ((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case LIST: {
                return true;
            }
            case MODIFY: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Upload subscription data is empty.");
                    return false;
                }
                ((PayLoad)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((PayLoad)this.servicePayload).getRestRawArgs()[1]));
                return this.uploadFileValidation(RedfishResourceTypes.EventService);
            }
            case SUBMIT: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Upload subscription data is empty.");
                    return false;
                }
                ((PayLoad)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((PayLoad)this.servicePayload).getRestRawArgs()[1]));
                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
            }
            case ADD: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Upload subscription data is empty.");
                    return false;
                }
                ((PayLoad)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((PayLoad)this.servicePayload).getRestRawArgs()[1]));
                return this.uploadFileValidation(RedfishResourceTypes.EventDestination);
            }
            case GET: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length == 2) {
                    ((PayLoad)this.servicePayload).setSubscriptionId(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                    return true;
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Subscription ID is empty.");
                return false;
            }
            case DELETE: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length == 2) {
                    ((PayLoad)this.servicePayload).setSubscriptionId(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                    return true;
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Subscription ID is empty.");
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case LIST: {
                return true;
            }
            case MODIFY: {
                if (((PayLoad)this.servicePayload).getUploadJsonFile() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Upload subscription data is empty.");
                    return false;
                }
                return this.uploadFileValidation(RedfishResourceTypes.EventService);
            }
            case SUBMIT: {
                if (((PayLoad)this.servicePayload).getUploadJsonFile() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Upload subscription data is empty.");
                    return false;
                }
                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
            }
            case ADD: {
                if (((PayLoad)this.servicePayload).getUploadJsonFile() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Upload subscription data is empty.");
                    return false;
                }
                return this.uploadFileValidation(RedfishResourceTypes.EventDestination);
            }
            case GET: {
                if (((PayLoad)this.servicePayload).getSubscriptionId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Subscription ID is empty.");
                    return false;
                }
                return true;
            }
            case DELETE: {
                if (((PayLoad)this.servicePayload).getSubscriptionId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Subscription ID is empty.");
                    return false;
                }
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((PayLoad)this.servicePayload).getUsername(), ((PayLoad)this.servicePayload).getPassword(), ((PayLoad)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        switch ((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case INFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case LIST: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    if (desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Event Destinations : ");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(desResp.getMembersOdataId()));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case MODIFY: {
                try {
                    String etag = this.getETag(((PayLoad)this.servicePayload).getProtocolHeader(), client, ((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHeaders("If-Match", etag)).setHttpMethods(RESTHttpMethods.PATCH)).setServiceURI(((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case SUBMIT: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case GET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((PayLoad)this.servicePayload).getSubscriptionId()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case ADD: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case DELETE: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.DELETE)).setServiceURI(((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((PayLoad)this.servicePayload).getSubscriptionId()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    if (desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Delete event subscription (" + ((PayLoad)this.servicePayload).getSubscriptionId() + ") fail.");
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Delete event subscription (" + ((PayLoad)this.servicePayload).getSubscriptionId() + ") success.");
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((EventServiceApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    public static final class PayLoad
    extends RedfishApiPayload<PayLoad, EventServiceApiOptions> {
        private String subscriptionId;

        public PayLoad(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(EventServiceApiOptions.UNKNOWN);
        }

        public PayLoad(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(EventServiceApiOptions.UNKNOWN);
        }

        @Override
        protected PayLoad getThis() {
            return this;
        }

        public EventServiceApi build() {
            return new EventServiceApi(this);
        }

        public String getSubscriptionId() {
            return this.subscriptionId;
        }

        public PayLoad setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this.getThis();
        }
    }
}

