/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.options.RootServiceApiOptions;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class RootServiceApi
extends RedfishApiService<Paylaod> {
    protected RootServiceApi(Paylaod servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.ROOT.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        return true;
    }

    @Override
    protected boolean checkPayLoad() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Paylaod)this.servicePayload).getUsername(), ((Paylaod)this.servicePayload).getPassword(), ((Paylaod)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Paylaod)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        try {
            RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Paylaod)this.servicePayload).getIpAddress())).setProtocolHeader(((Paylaod)this.servicePayload).getProtocolHeader())).setPort(((Paylaod)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((RootServiceApiOptions)((Paylaod)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
            Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
            RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
            this.responseData.add(desResp);
            if (desResp.isRedfishErrorResponse()) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                boolean bl = false;
                return bl;
            }
            Map<String, String> resources = desResp.getAllNextOdataId();
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Paylaod)this.servicePayload).getIpAddress() + "] All Redfish services in root :");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(resources));
            boolean bl = true;
            return bl;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
            if (re.getUnexpectedBody() != null) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            client.close();
        }
    }

    public static final class Paylaod
    extends RedfishApiPayload<Paylaod, RootServiceApiOptions> {
        public Paylaod(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(RootServiceApiOptions.SHOW);
        }

        public Paylaod(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(RootServiceApiOptions.SHOW);
        }

        @Override
        protected Paylaod getThis() {
            return this;
        }

        public RootServiceApi build() {
            return new RootServiceApi(this);
        }
    }
}

