/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestBackupConfig;
import Gbt.utility.rest.models.AMIRestSessionData;
import Gbt.utility.rest.requests.SessionRequest;
import java.io.File;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class BackupService
extends RESTServices {
    public static final String SERVICE_NAME = "backup";
    private static final SimpleDateFormat STD_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String BACKUP_CFG_URI = "/api/maintenance/backup_config";
    private static final String DOWNLOAD_URI = "/api/maintenance/download_config";
    private static final String RESTORE_URI = "/api/maintenance/upload_restore";
    private static final String UPLOAD_KEY = "config";
    private AMIRestBackupConfig backupConfig;
    private File restoreBmcConfigFile;
    private Client clientForLongTimeResp;

    public BackupService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "get": {
                return true;
            }
            case "set": {
                try {
                    this.backupConfig = (AMIRestBackupConfig)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), restServicesOptions.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "dump": {
                return true;
            }
            case "fulldump": {
                return true;
            }
            case "restore": {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "get": {
                return true;
            }
            case "set": {
                return true;
            }
            case "dump": {
                return true;
            }
            case "fulldump": {
                return true;
            }
            case "restore": {
                this.restoreBmcConfigFile = uploadFiles.get(0);
                if (this.restoreBmcConfigFile == null) {
                    return false;
                }
                if (!this.restoreBmcConfigFile.exists()) {
                    return false;
                }
                return this.restoreBmcConfigFile.isFile();
            }
        }
        return false;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        switch (restServicesOptions.getOptionName()) {
            case "get": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(BACKUP_CFG_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.backupConfig = this.clientReceiver.deserialize(response, new GenericType<AMIRestBackupConfig>(){});
                    this.jsonResults.add(this.backupConfig);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get backup configuration success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.backupConfig.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get backup configuration fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get backup configuration fail."));
                    return false;
                }
            }
            case "set": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(BACKUP_CFG_URI).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(this.backupConfig)).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.backupConfig = this.clientReceiver.deserialize(response, new GenericType<AMIRestBackupConfig>(){});
                    this.jsonResults.add(this.backupConfig);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set backup configuration success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.backupConfig.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set backup configuration fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set backup configuration fail."));
                    return false;
                }
            }
            case "dump": {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "Start download BMC config file.");
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DOWNLOAD_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
                    File backupFile = this.clientReceiver.downloadFile(response, new File(this.getPath() + ipAddress + "_bmcConfig.bak"));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Download BMC config file complete.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Download path : " + backupFile.getAbsolutePath());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Download BMC config file fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Download BMC config file fail."));
                    return false;
                }
            }
            case "fulldump": {
                Response response;
                this.backupConfig = new AMIRestBackupConfig();
                BigInteger enable = new BigInteger("1");
                this.backupConfig.setId(enable);
                this.backupConfig.setKvm(enable);
                this.backupConfig.setNetwork(enable);
                this.backupConfig.setIpmi(enable);
                this.backupConfig.setNtp(enable);
                this.backupConfig.setAuthentication(enable);
                this.backupConfig.setSyslog(enable);
                this.backupConfig.setSnmp(enable);
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(BACKUP_CFG_URI).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(this.backupConfig)).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
                    this.backupConfig = this.clientReceiver.deserialize(response, new GenericType<AMIRestBackupConfig>(){});
                    this.jsonResults.add(this.backupConfig);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set full download configuration success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.backupConfig.toString());
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set full download configuration fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set full download configuration fail."));
                    return false;
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start download BMC config file.");
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DOWNLOAD_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
                    File backupFile = this.clientReceiver.downloadFile(response, new File(this.getPath() + ipAddress + "_bmcConfig_full.bak"));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Download BMC config file success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Download path : " + backupFile.getAbsolutePath());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Download BMC config file fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Download BMC config file fail."));
                    return false;
                }
            }
            case "restore": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(RESTORE_URI).setCookies(this.sessionData)).setContentType("multipart/form-data")).setFormData(UPLOAD_KEY, this.restoreBmcConfigFile)).build();
                try {
                    this.clientReceiver.syncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Restore BMC Config file success.");
                    this.jsonResults.add(new NullJSONData().setError(false).setMessages("Restore Config file success."));
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Restore BMC Config file fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Restore Config file fail."));
                    return false;
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openSession(String ipAddress, String username, String password, boolean debug) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        this.username = username;
        this.password = password;
        this.client = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, debug);
        this.clientForLongTimeResp = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, 80000, 80000, debug);
        if (this.client == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        if (this.clientForLongTimeResp == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        SessionRequest request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/x-www-form-urlencoded")).setFormData("username", username)).setFormData("password", password)).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Open session success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
    }

    private final String getPath() {
        return "results/" + STD_FORMAT.format(new Date()) + "/" + this.logDirPath + "/";
    }
}

