/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.menu.GbtUtility;
import Gbt.utility.rest.requests.SMBIOSRequest;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.Response;

public final class SMBIOSService
extends RESTServices {
    public static final String SERVICE_NAME = "smbios";

    public SMBIOSService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        File downloadFile = new File(GbtUtility.getResultsRootPath() + "/" + this.logDirPath + "/" + logName + ".bin");
        SMBIOSRequest request = ((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)new SMBIOSRequest.Builder().setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setCookies(this.sessionData)).setDownloadFileNmae(downloadFile).build();
        try {
            Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.jsonResults.addAll(this.clientReceiver.downloadSmbios(response, downloadFile));
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonListsPrettyPrintString());
            return true;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get SMBIOS info fail.");
            this.restExceptionMessages(re, ipAddress, logName);
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get SMBIOS info fail."));
            return false;
        }
    }
}

