/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.core.vmedia.data.KvmSessionToken;
import Gbt.core.vmedia.data.VmediaAdviserConfig;
import Gbt.core.vmedia.data.VmediaInstanceConfig;
import Gbt.core.vmedia.redirection.IusbRedirectionManager;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.Response;

public final class VmediaService
extends RESTServices {
    public static final String SERVICE_NAME = "vmedia";
    private static final int VMEDIA_PORT = 443;
    private static final String VMEDIA_INS_URI = "/api/settings/media/instance";
    private static final String VMEDIA_ADVISER_URI = "/api/settings/media/adviser";
    private static final String VMEDIA_KVM_TOKEN_URI = "/api/settings/kvm/token";
    private List<File> mountImageFiles;
    private volatile IusbRedirectionManager iusbRedirSession;

    public VmediaService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
        if (this.bmcPort == 0) {
            this.bmcPort = 443;
        }
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        this.mountImageFiles = uploadFiles;
        return !this.mountImageFiles.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        int i;
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        Response response = null;
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(VMEDIA_INS_URI).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setCookies(this.sessionData)).build();
        VmediaInstanceConfig vmediaInstanceConfig = null;
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            vmediaInstanceConfig = this.clientReceiver.deserialize(response, VmediaInstanceConfig.class);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, vmediaInstanceConfig.toString());
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get virtual media config success.");
            this.jsonResults.add(vmediaInstanceConfig);
        }
        catch (RESTException re) {
            this.restExceptionMessages(re, ipAddress, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get virtual media config fail.");
            boolean bl = false;
            return bl;
        }
        finally {
            response.close();
        }
        if (this.mountImageFiles.size() > vmediaInstanceConfig.getCdromNumber()) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] ISO image is too many.");
            return false;
        }
        request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(VMEDIA_ADVISER_URI).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setCookies(this.sessionData)).build();
        VmediaAdviserConfig vmediaAdviserConfig = null;
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            vmediaAdviserConfig = this.clientReceiver.deserialize(response, VmediaAdviserConfig.class);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, vmediaAdviserConfig.toString());
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get virtual media adviser config success.");
            this.jsonResults.add(vmediaAdviserConfig);
        }
        catch (RESTException re) {
            this.restExceptionMessages(re, ipAddress, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get virtual media adviser config fail.");
            boolean bl = false;
            return bl;
        }
        finally {
            response.close();
        }
        request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(VMEDIA_KVM_TOKEN_URI).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setCookies(this.sessionData)).build();
        KvmSessionToken kvmSessionToken = null;
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            kvmSessionToken = this.clientReceiver.deserialize(response, KvmSessionToken.class);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, kvmSessionToken.toString());
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get kvm session token success.");
            this.jsonResults.add(kvmSessionToken);
        }
        catch (RESTException re) {
            this.restExceptionMessages(re, ipAddress, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get kvm session token fail.");
            boolean bl = false;
            return bl;
        }
        finally {
            response.close();
        }
        this.iusbRedirSession = new IusbRedirectionManager(vmediaInstanceConfig);
        boolean mountAllOk = true;
        for (i = 0; i < this.mountImageFiles.size(); ++i) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start mount : " + this.mountImageFiles.get(i).getAbsolutePath());
            if (!(mountAllOk &= this.iusbRedirSession.StartISORedir(this.client, kvmSessionToken, ipAddress, this.mountImageFiles.get(i), 443, i))) break;
        }
        if (!mountAllOk) {
            for (i = 0; i < vmediaInstanceConfig.getCdromNumber(); ++i) {
                this.iusbRedirSession.StopISORedir(i, 0);
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Unmount : " + this.mountImageFiles.get(i).getAbsolutePath());
            }
            return false;
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] All media has already to play.");
        return true;
    }

    public void unmountIsoImages(String ipAddress) {
        for (int i = 0; i < this.mountImageFiles.size(); ++i) {
            this.iusbRedirSession.StopISORedir(i, 0);
        }
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Unmount virtual vmedia OK.");
    }
}

