/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.useraccounts;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.useraccounts.BMCAccessPrivJSONData;
import Gbt.utility.useraccounts.UserAccountCommand;
import Gbt.utility.useraccounts.UserAccountJSONData;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import java.nio.charset.StandardCharsets;

public enum UserAccountIPMIOption implements GbtIPMIOptions<UserAccountCommand.Builder>
{
    SetUserNameCommand(0, "Set user name", 69),
    SetUserPasswordCommand(1, "Set user password", 71),
    SetUserEnableCommand(2, "Set user enable/disable", 71),
    SetUserLANAccessPrivilegeCommand(3, "Set user LAN access privilege", 67),
    SetUserSerialAccessPrivilegeCommand(4, "Set user serial access privilege", 67),
    SetUserSOLEnableCommand(5, "Set user SOL enable/disable", 76),
    GetUserNameCommand(6, "Get user name", 70),
    GetUserLANAccessPrivilegeCommand(7, "Get user LAN access privilege", 68),
    GetUserSerialAccessPrivilegeCommand(8, "Get user serial access privilege", 68),
    GetUserSOLStatusCommand(9, "Get user SOL status", 77);

    private static final int SetUserNameCode = 0;
    private static final int SetUserPasswordCode = 1;
    private static final int SetUserEnableCode = 2;
    private static final int SetUserLANAccessPrivilegeCode = 3;
    private static final int SetUserSerialAccessPrivilegeCode = 4;
    private static final int SetUserSOLEnableCode = 5;
    private static final int GetUserNameCode = 6;
    private static final int GetUserLANAccessPrivilegeCode = 7;
    private static final int GetUserSerialAccessPrivilegeCode = 8;
    private static final int GetUserSOLStatusCode = 9;
    private static final String SetUserNameItem = "Set user name";
    private static final String SetUserPasswordItem = "Set user password";
    private static final String SetUserEnableItem = "Set user enable/disable";
    private static final String SetUserLANAccessPrivilegeItem = "Set user LAN access privilege";
    private static final String SetUserSerialAccessPrivilegeItem = "Set user serial access privilege";
    private static final String SetUserSOLEnableItem = "Set user SOL enable/disable";
    private static final String GetUserNameItem = "Get user name";
    private static final String GetUserLANAccessPrivilegeItem = "Get user LAN access privilege";
    private static final String GetUserSerialAccessPrivilegeItem = "Get user serial access privilege";
    private static final String GetUserSOLStatusItem = "Get user SOL status";
    private final int code;
    private final String item;
    private static final byte NET_FN = 6;
    private final byte cmd;

    private UserAccountIPMIOption(int code, String item, byte cmd) {
        this.code = code;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.code;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 6;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(UserAccountCommand.Builder commandArgs) {
        byte[] requestData = null;
        switch (this) {
            case SetUserNameCommand: {
                byte[] usernameBytes = this.parseAccountDataToBytes(commandArgs.accountUsername);
                requestData = new byte[usernameBytes.length + 1];
                requestData[0] = commandArgs.accountID;
                System.arraycopy(usernameBytes, 0, requestData, 1, usernameBytes.length);
                return requestData;
            }
            case SetUserPasswordCommand: {
                byte[] passwordBytes = this.parseAccountDataToBytes(commandArgs.accountPassword);
                requestData = new byte[passwordBytes.length + 2];
                requestData[0] = commandArgs.accountID;
                requestData[1] = 2;
                System.arraycopy(passwordBytes, 0, requestData, 2, passwordBytes.length);
                return requestData;
            }
            case SetUserEnableCommand: {
                return new byte[]{commandArgs.accountID, (byte)(commandArgs.enableUser != false ? 1 : 0)};
            }
            case SetUserLANAccessPrivilegeCommand: {
                return new byte[]{-79, commandArgs.accountID, commandArgs.privLevel.getCode()};
            }
            case SetUserSerialAccessPrivilegeCommand: {
                return new byte[]{-78, commandArgs.accountID, commandArgs.privLevel.getCode()};
            }
            case SetUserSOLEnableCommand: {
                return new byte[]{1, commandArgs.enableSol != false ? commandArgs.accountID : (byte)(commandArgs.accountID | 0x40), 2, 0, 0, 0};
            }
            case GetUserNameCommand: {
                return new byte[]{commandArgs.accountID};
            }
            case GetUserLANAccessPrivilegeCommand: {
                return new byte[]{1, commandArgs.accountID};
            }
            case GetUserSerialAccessPrivilegeCommand: {
                return new byte[]{2, commandArgs.accountID};
            }
            case GetUserSOLStatusCommand: {
                return new byte[]{1, commandArgs.accountID};
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        switch (this) {
            case SetUserNameCommand: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case SetUserPasswordCommand: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case SetUserEnableCommand: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case SetUserLANAccessPrivilegeCommand: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case SetUserSerialAccessPrivilegeCommand: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case SetUserSOLEnableCommand: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " command complete.");
            }
            case GetUserNameCommand: {
                if (gbtResponseData.getAllResponseData().length == 16) {
                    return new UserAccountJSONData().setUsername(GbtCommonConverters.asciiBytesToString(gbtResponseData.getAllResponseData()));
                }
                return new NullJSONData().setError(true).setMessages(this.getItem() + " Invalid response data !!");
            }
            case GetUserLANAccessPrivilegeCommand: {
                if (gbtResponseData.getAllResponseData().length == 4) {
                    BMCAccessPrivJSONData lanInfo = new BMCAccessPrivJSONData();
                    String resp = GbtCommonConverters.bytesToHex(gbtResponseData.getAllResponseData());
                    int state = Integer.parseInt(resp.substring(2, 3), 16);
                    for (int i = 0; i < 2; ++i) {
                        int key = state & 4 << i;
                        if (key == 4) {
                            lanInfo.setEnable(true);
                        }
                        if (key != 8) continue;
                        lanInfo.setEnable(false);
                    }
                    int access = Integer.parseInt(resp.substring(6, 7), 16);
                    block47: for (int i = 0; i < 3; ++i) {
                        int key = access & 1 << i;
                        switch (key) {
                            case 1: {
                                lanInfo.setIPMIAvailable(true);
                                continue block47;
                            }
                            case 2: {
                                lanInfo.setLinkAvailable(true);
                                continue block47;
                            }
                            case 4: {
                                lanInfo.setCallbackAvailable(false);
                                continue block47;
                            }
                            default: {
                                switch (i) {
                                    case 0: {
                                        lanInfo.setIPMIAvailable(false);
                                        continue block47;
                                    }
                                    case 1: {
                                        lanInfo.setLinkAvailable(false);
                                        continue block47;
                                    }
                                    case 2: {
                                        lanInfo.setCallbackAvailable(true);
                                    }
                                }
                            }
                        }
                    }
                    int priv = Integer.parseInt(resp.substring(7), 16);
                    switch (priv) {
                        case 1: {
                            lanInfo.setPrivilege(PrivilegeLevel.Callback);
                            break;
                        }
                        case 2: {
                            lanInfo.setPrivilege(PrivilegeLevel.User);
                            break;
                        }
                        case 3: {
                            lanInfo.setPrivilege(PrivilegeLevel.Operator);
                            break;
                        }
                        case 4: {
                            lanInfo.setPrivilege(PrivilegeLevel.Administrator);
                            break;
                        }
                        case 5: {
                            lanInfo.setPrivilege(PrivilegeLevel.OEM);
                            break;
                        }
                        default: {
                            lanInfo.setPrivilege(PrivilegeLevel.NoAccess);
                        }
                    }
                    return lanInfo;
                }
                return new NullJSONData().setError(true).setMessages(this.getItem() + " Invalid response data !!");
            }
            case GetUserSerialAccessPrivilegeCommand: {
                if (gbtResponseData.getAllResponseData() != null && gbtResponseData.getAllResponseData().length == 4) {
                    BMCAccessPrivJSONData serialInfo = new BMCAccessPrivJSONData();
                    String resp = GbtCommonConverters.bytesToHex(gbtResponseData.getAllResponseData());
                    int state = Integer.parseInt(resp.substring(2, 3), 16);
                    for (int i = 0; i < 2; ++i) {
                        int key = state & 4 << i;
                        if (key == 4) {
                            serialInfo.setEnable(true);
                        }
                        if (key != 8) continue;
                        serialInfo.setEnable(false);
                    }
                    int access = Integer.parseInt(resp.substring(6, 7), 16);
                    block49: for (int i = 0; i < 3; ++i) {
                        int key = access & 1 << i;
                        switch (key) {
                            case 1: {
                                serialInfo.setIPMIAvailable(true);
                                continue block49;
                            }
                            case 2: {
                                serialInfo.setLinkAvailable(true);
                                continue block49;
                            }
                            case 4: {
                                serialInfo.setCallbackAvailable(false);
                                continue block49;
                            }
                            default: {
                                switch (i) {
                                    case 0: {
                                        serialInfo.setIPMIAvailable(false);
                                        continue block49;
                                    }
                                    case 1: {
                                        serialInfo.setLinkAvailable(false);
                                        continue block49;
                                    }
                                    case 2: {
                                        serialInfo.setCallbackAvailable(true);
                                    }
                                }
                            }
                        }
                    }
                    int priv = Integer.parseInt(resp.substring(7), 16);
                    switch (priv) {
                        case 1: {
                            serialInfo.setPrivilege(PrivilegeLevel.Callback);
                            break;
                        }
                        case 2: {
                            serialInfo.setPrivilege(PrivilegeLevel.User);
                            break;
                        }
                        case 3: {
                            serialInfo.setPrivilege(PrivilegeLevel.Operator);
                            break;
                        }
                        case 4: {
                            serialInfo.setPrivilege(PrivilegeLevel.Administrator);
                            break;
                        }
                        case 5: {
                            serialInfo.setPrivilege(PrivilegeLevel.OEM);
                            break;
                        }
                        default: {
                            serialInfo.setPrivilege(PrivilegeLevel.NoAccess);
                        }
                    }
                    return serialInfo;
                }
                return new NullJSONData().setError(true).setMessages(this.getItem() + " Invalid response data !!");
            }
            case GetUserSOLStatusCommand: {
                if (gbtResponseData.getAllResponseData() != null && gbtResponseData.getAllResponseData().length == 4) {
                    if (gbtResponseData.getAllResponseData()[0] == 2) {
                        return new UserAccountJSONData().setSOLStatus(Boolean.TRUE);
                    }
                    return new UserAccountJSONData().setSOLStatus(Boolean.FALSE);
                }
                return new NullJSONData().setError(true).setMessages(this.getItem() + " Invalid response data !!");
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown user account option.");
    }

    private final byte[] parseAccountDataToBytes(String inputString) {
        byte[] temp = inputString.getBytes(StandardCharsets.US_ASCII);
        byte[] output = new byte[16];
        if (temp.length > 16) {
            System.arraycopy(temp, 0, output, 0, output.length);
        } else {
            System.arraycopy(temp, 0, output, 0, temp.length);
        }
        return output;
    }

    public static final UserAccountIPMIOption parseInt(int value) {
        switch (value) {
            case 0: {
                return SetUserNameCommand;
            }
            case 1: {
                return SetUserPasswordCommand;
            }
            case 2: {
                return SetUserEnableCommand;
            }
            case 3: {
                return SetUserLANAccessPrivilegeCommand;
            }
            case 4: {
                return SetUserSerialAccessPrivilegeCommand;
            }
            case 5: {
                return SetUserSOLEnableCommand;
            }
            case 6: {
                return GetUserNameCommand;
            }
            case 7: {
                return GetUserLANAccessPrivilegeCommand;
            }
            case 8: {
                return GetUserSerialAccessPrivilegeCommand;
            }
            case 9: {
                return GetUserSOLStatusCommand;
            }
        }
        throw new IllegalArgumentException("Invalid code value.");
    }
}

