/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.api.sol;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.async.InboundSolMessageListener;
import com.veraxsystems.vxipmi.api.sol.SOLException;
import com.veraxsystems.vxipmi.api.sol.SolEventListener;
import com.veraxsystems.vxipmi.api.sync.IpmiConnector;
import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.payload.ActivateSolPayload;
import com.veraxsystems.vxipmi.coding.commands.payload.ActivateSolPayloadResponseData;
import com.veraxsystems.vxipmi.coding.commands.payload.DeactivatePayload;
import com.veraxsystems.vxipmi.coding.commands.payload.GetPayloadActivationStatus;
import com.veraxsystems.vxipmi.coding.commands.payload.GetPayloadActivationStatusResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.SetSessionPrivilegeLevel;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.sol.SolAckState;
import com.veraxsystems.vxipmi.coding.payload.sol.SolOperation;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.coding.sol.SolCoder;
import com.veraxsystems.vxipmi.coding.sol.SolResponseData;
import com.veraxsystems.vxipmi.common.TypeConverter;
import com.veraxsystems.vxipmi.connection.Session;
import com.veraxsystems.vxipmi.connection.SessionException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class SerialOverLan
implements Closeable {
    private final IpmiConnector connector;
    private final Session session;
    private final InboundSolMessageListener inboundMessageListener;
    private final List<SolEventListener> eventListeners;
    private boolean isSessionInternal;
    private int payloadInstance;
    private int maxPayloadSize;
    private boolean closed;

    public SerialOverLan(IpmiConnector connector, Session session) throws SOLException {
        this.connector = connector;
        int solPayloadPort = this.activatePayload(session.getConnectionHandle());
        this.session = this.resolveSession(session.getConnectionHandle(), session, solPayloadPort);
        this.eventListeners = new LinkedList<SolEventListener>();
        this.inboundMessageListener = new InboundSolMessageListener(connector, this.session.getConnectionHandle(), this.eventListeners);
        this.connector.registerIncomingMessageListener(this.inboundMessageListener);
        this.closed = false;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean writeByte(byte singleByte) {
        return this.writeBytes(new byte[]{singleByte});
    }

    public boolean writeBytes(byte[] buffer) {
        boolean result = true;
        int maxBufferSize = this.maxPayloadSize - 4;
        byte[] remainingBytes = buffer;
        int currentIndex = 0;
        while (remainingBytes.length - currentIndex > maxBufferSize) {
            byte[] bufferChunk = Arrays.copyOfRange(remainingBytes, currentIndex, maxBufferSize);
            currentIndex += maxBufferSize;
            if (result &= this.sendMessage(bufferChunk)) continue;
            return false;
        }
        if (remainingBytes.length - currentIndex > 0) {
            remainingBytes = Arrays.copyOfRange(remainingBytes, currentIndex, remainingBytes.length);
            result &= this.sendMessage(remainingBytes);
        }
        return result;
    }

    public boolean writeInt(int singleInt) {
        return this.writeBytes(new byte[]{TypeConverter.intToByte(singleInt)});
    }

    public boolean writeIntArray(int[] buffer) {
        byte[] byteBuffer = new byte[buffer.length];
        for (int i = 0; i < buffer.length; ++i) {
            byteBuffer[i] = TypeConverter.intToByte(buffer[i]);
        }
        return this.writeBytes(byteBuffer);
    }

    public boolean writeString(String string) {
        return this.writeBytes(string.getBytes());
    }

    public boolean writeString(String string, Charset charset) {
        return this.writeBytes(string.getBytes(charset));
    }

    public byte[] readBytes() {
        return this.readBytes(this.inboundMessageListener.getAvailableBytesCount());
    }

    public byte[] readBytes(int byteCount) {
        return this.inboundMessageListener.readBytes(byteCount);
    }

    public byte[] readBytes(int byteCount, int timeout) {
        this.waitForData(byteCount, timeout);
        return this.readBytes(byteCount);
    }

    public int[] readIntArray() {
        return this.readIntArray(this.inboundMessageListener.getAvailableBytesCount());
    }

    public int[] readIntArray(int byteCount) {
        byte[] bytesArray = this.readBytes(byteCount);
        int[] intArray = new int[bytesArray.length];
        for (int i = 0; i < bytesArray.length; ++i) {
            intArray[i] = TypeConverter.byteToInt(bytesArray[i]);
        }
        return intArray;
    }

    public int[] readIntArray(int byteCount, int timeout) {
        this.waitForData(byteCount, timeout);
        return this.readIntArray(byteCount);
    }

    public String readString() {
        return this.readString(this.inboundMessageListener.getAvailableBytesCount());
    }

    public String readString(int byteCount) {
        return new String(this.readBytes(byteCount));
    }

    public String readString(int byteCount, int timeout) {
        this.waitForData(byteCount, timeout);
        return this.readString(byteCount);
    }

    public String readString(Charset charset) {
        return this.readString(charset, this.inboundMessageListener.getAvailableBytesCount());
    }

    public String readString(Charset charset, int byteCount) {
        return new String(this.readBytes(byteCount), charset);
    }

    public String readString(Charset charset, int byteCount, int timeout) {
        this.waitForData(byteCount, timeout);
        return this.readString(charset, byteCount);
    }

    public boolean invokeOperations(SolOperation ... operations) {
        HashSet<SolOperation> operationSet = new HashSet<SolOperation>();
        Collections.addAll(operationSet, operations);
        SolCoder payloadCoder = new SolCoder(operationSet, this.session.getConnectionHandle().getCipherSuite());
        SolResponseData responseData = this.sendPayload(payloadCoder);
        this.notifyResponseListeners(new byte[0], operationSet, responseData);
        return responseData != null && responseData.getAcknowledgeState() == SolAckState.ACK;
    }

    public void registerEventListener(SolEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void unregisterEventListener(SolEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                ConnectionHandle connectionHandle = this.session.getConnectionHandle();
                DeactivatePayload deactivatePayload = new DeactivatePayload(connectionHandle.getCipherSuite(), PayloadType.Sol, this.payloadInstance);
                this.sendPayload(deactivatePayload);
                if (this.isSessionInternal) {
                    this.connector.closeSession(connectionHandle);
                    this.connector.closeConnection(connectionHandle);
                }
                this.closed = true;
            }
            catch (Exception e) {
                throw new IOException("Error while closing Serial over LAN instance", e);
            }
        }
    }

    private Session resolveSession(ConnectionHandle connectionHandle, Session session, int solPayloadPort) throws SOLException {
        if (solPayloadPort != connectionHandle.getRemotePort()) {
            Session alternativeSession = this.connector.getExistingSessionForCriteria(connectionHandle.getRemoteAddress(), solPayloadPort, connectionHandle.getUser());
            if (alternativeSession == null) {
                try {
                    alternativeSession = SerialOverLan.establishSession(this.connector, connectionHandle.getRemoteAddress().getHostAddress(), solPayloadPort, connectionHandle.getUser(), connectionHandle.getPassword());
                }
                catch (SessionException se) {
                    throw new SOLException(se.getMessage(), se);
                }
                this.isSessionInternal = true;
            } else {
                this.isSessionInternal = false;
            }
            this.activatePayload(alternativeSession.getConnectionHandle());
            return alternativeSession;
        }
        this.isSessionInternal = false;
        return session;
    }

    private int activatePayload(ConnectionHandle connectionHandle) throws SOLException {
        try {
            this.payloadInstance = this.getFirstAvailablePayloadInstance(connectionHandle);
            ActivateSolPayload activatePayload = new ActivateSolPayload(connectionHandle.getCipherSuite(), this.payloadInstance);
            ActivateSolPayloadResponseData activatePayloadResponseData = this.getActivatePayloadResponse(connectionHandle, activatePayload);
            this.maxPayloadSize = activatePayloadResponseData.getInboundPayloadSize();
            return activatePayloadResponseData.getPayloadUdpPortNumber();
        }
        catch (Exception e) {
            throw new SOLException("Cannot activate SOL payload due to exception during activation process", e);
        }
    }

    private ActivateSolPayloadResponseData getActivatePayloadResponse(ConnectionHandle connectionHandle, ActivateSolPayload activatePayload) throws Exception {
        try {
            return (ActivateSolPayloadResponseData)this.connector.sendMessage(connectionHandle, activatePayload);
        }
        catch (IPMIException ipmie) {
            if (ipmie.getCompletionCode() == CompletionCode.InsufficentPrivilege) {
                this.raiseSessionPrivileges(connectionHandle);
                return (ActivateSolPayloadResponseData)this.connector.sendMessage(connectionHandle, activatePayload);
            }
            throw ipmie;
        }
    }

    private int getFirstAvailablePayloadInstance(ConnectionHandle connectionHandle) throws Exception {
        GetPayloadActivationStatus getPayloadActivationStatus = new GetPayloadActivationStatus(connectionHandle.getCipherSuite(), PayloadType.Sol);
        GetPayloadActivationStatusResponseData getActivationResponseData = (GetPayloadActivationStatusResponseData)this.connector.sendMessage(connectionHandle, getPayloadActivationStatus);
        if (getActivationResponseData.getInstanceCapacity() <= 0 || getActivationResponseData.getAvailableInstances().isEmpty()) {
            throw new SOLException("Cannot activate SOL payload, as there are no available payload instances.");
        }
        return TypeConverter.byteToInt(getActivationResponseData.getAvailableInstances().get(0));
    }

    private void raiseSessionPrivileges(ConnectionHandle connectionHandle) throws Exception {
        SetSessionPrivilegeLevel setSessionPrivilegeLevel = new SetSessionPrivilegeLevel(IpmiVersion.V20, connectionHandle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator);
        this.connector.sendMessage(connectionHandle, setSessionPrivilegeLevel);
    }

    private void waitForData(int wantedByteCount, int timeout) {
        long startTime = System.currentTimeMillis();
        while (this.isTooFewBytesAvailable(wantedByteCount) && this.timeoutNotHit(timeout, startTime)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    private boolean isTooFewBytesAvailable(int wantedByteCount) {
        return this.inboundMessageListener.getAvailableBytesCount() < wantedByteCount;
    }

    private boolean timeoutNotHit(int timeout, long startTime) {
        return System.currentTimeMillis() - startTime < (long)timeout;
    }

    private boolean sendMessage(byte[] characterData) {
        SolCoder payloadCoder = new SolCoder(characterData, this.session.getConnectionHandle().getCipherSuite());
        SolResponseData responseData = this.sendPayload(payloadCoder);
        this.notifyResponseListeners(characterData, new HashSet<SolOperation>(), responseData);
        byte[] remainingCharacterData = characterData;
        while (this.isNackForMessagePart(responseData, remainingCharacterData.length)) {
            remainingCharacterData = Arrays.copyOfRange(remainingCharacterData, (int)responseData.getAcceptedCharactersNumber(), remainingCharacterData.length);
            SolCoder partialPayloadCoder = new SolCoder(remainingCharacterData, this.session.getConnectionHandle().getCipherSuite());
            responseData = this.sendPayload(partialPayloadCoder);
            this.notifyResponseListeners(remainingCharacterData, new HashSet<SolOperation>(), responseData);
        }
        return responseData != null && responseData.getAcknowledgeState() == SolAckState.ACK;
    }

    private void notifyResponseListeners(byte[] characterData, Set<SolOperation> solOperations, SolResponseData responseData) {
        if (responseData != null && responseData.getStatuses() != null) {
            for (SolEventListener listener : this.eventListeners) {
                listener.processResponseEvent(responseData.getStatuses(), characterData, solOperations);
            }
        }
    }

    private SolResponseData sendPayload(PayloadCoder payloadCoder) {
        ConnectionHandle connectionHandle = this.session.getConnectionHandle();
        try {
            SolResponseData responseData = (SolResponseData)this.connector.sendMessage(connectionHandle, payloadCoder);
            for (int actualRetries = 0; this.isNackForWholeMessage(responseData) && actualRetries < this.connector.getRetries(); ++actualRetries) {
                responseData = (SolResponseData)this.connector.retryMessage(connectionHandle, responseData.getRequestSequenceNumber(), PayloadType.Sol);
            }
            return responseData;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isNackForWholeMessage(SolResponseData responseData) {
        return responseData != null && responseData.getAcknowledgeState() == SolAckState.NACK && responseData.getAcceptedCharactersNumber() == 0;
    }

    private boolean isNackForMessagePart(SolResponseData responseData, int previousMessageDataLength) {
        return responseData != null && responseData.getAcknowledgeState() == SolAckState.NACK && responseData.getAcceptedCharactersNumber() > 0 && responseData.getAcceptedCharactersNumber() < previousMessageDataLength;
    }

    public static Session establishSession(IpmiConnector connector, String remoteHost, int remotePort, String user, String password) throws SessionException {
        ConnectionHandle handle = null;
        try {
            handle = connector.createConnection(InetAddress.getByName(remoteHost), remotePort);
            List<CipherSuite> availableCipherSuites = connector.getAvailableCipherSuites(handle);
            connector.getChannelAuthenticationCapabilities(handle, availableCipherSuites, PrivilegeLevel.Administrator);
            return connector.openSession(handle, user, password, null);
        }
        catch (Exception e) {
            SerialOverLan.closeConnection(connector, handle);
            throw new SessionException("Cannot create new session due to exception", e);
        }
    }

    private static void closeConnection(IpmiConnector connector, ConnectionHandle handle) {
        try {
            if (connector != null && handle != null) {
                connector.closeSession(handle);
                connector.closeConnection(handle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

