/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.payload;

import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.payload.ActivatePayload;
import com.veraxsystems.vxipmi.coding.commands.payload.ActivatePayloadResponseData;
import com.veraxsystems.vxipmi.coding.commands.payload.ActivateSolPayloadResponseData;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;

public class ActivateSolPayload
extends ActivatePayload {
    public ActivateSolPayload(CipherSuite cipherSuite, int payloadInstance) {
        super(IpmiVersion.V20, cipherSuite, AuthenticationType.RMCPPlus, payloadInstance);
    }

    @Override
    public PayloadType getPayloadType() {
        return PayloadType.Sol;
    }

    @Override
    protected byte[] prepareAuxilaryRequestData() {
        boolean isEncryptionEnabled;
        byte[] result = new byte[4];
        boolean isAuthenticationEnabled = this.getCipherSuite().getAuthenticationAlgorithm().getCode() != 0;
        boolean bl = isEncryptionEnabled = this.getCipherSuite().getConfidentialityAlgorithm().getCode() != 0;
        if (isEncryptionEnabled) {
            result[0] = TypeConverter.setBitOnPosition(7, result[0]);
        }
        if (isAuthenticationEnabled) {
            result[0] = TypeConverter.setBitOnPosition(6, result[0]);
        }
        result[0] = TypeConverter.setBitOnPosition(2, result[0]);
        return result;
    }

    @Override
    protected ActivatePayloadResponseData createEmptyResponse() {
        return new ActivateSolPayloadResponseData();
    }
}

