/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.payload;

import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.util.LinkedList;
import java.util.List;

public class GetPayloadActivationStatusResponseData
implements ResponseData {
    private byte instanceCapacity;
    private List<Byte> availableInstances;

    public byte getInstanceCapacity() {
        return this.instanceCapacity;
    }

    public void setInstanceCapacity(byte instanceCapacity) {
        this.instanceCapacity = instanceCapacity;
    }

    public List<Byte> getAvailableInstances() {
        LinkedList<Byte> actuallyAvailableInstances = new LinkedList<Byte>();
        for (Byte instanceId : this.availableInstances) {
            if (instanceId > this.instanceCapacity) continue;
            actuallyAvailableInstances.add(instanceId);
        }
        return actuallyAvailableInstances;
    }

    public void setAvailableInstances(byte[] availableInstancesData) {
        this.availableInstances = this.getAvailableInstancesFromBytes(availableInstancesData);
    }

    private List<Byte> getAvailableInstancesFromBytes(byte[] availableInstancesData) {
        LinkedList<Byte> result = new LinkedList<Byte>();
        List<Byte> instancesFromFirstByte = this.checkForAvailableInstancesInByte(availableInstancesData[0], 0);
        List<Byte> instancesFromSecondByte = this.checkForAvailableInstancesInByte(availableInstancesData[1], 8);
        result.addAll(instancesFromFirstByte);
        result.addAll(instancesFromSecondByte);
        return result;
    }

    private List<Byte> checkForAvailableInstancesInByte(byte availableInstancesByte, int instanceIdOffset) {
        LinkedList<Byte> result = new LinkedList<Byte>();
        for (int i = 0; i < 8; ++i) {
            if (TypeConverter.isBitSetOnPosition(i, availableInstancesByte)) continue;
            result.add((byte)(i + 1 + instanceIdOffset));
        }
        return result;
    }

    public String toString() {
        return "GetPayloadActivationStatusResponseData{instanceCapacity=" + this.getInstanceCapacity() + ", availableInstances=" + this.getAvailableInstances() + '}';
    }
}

