/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.security;

import com.veraxsystems.vxipmi.coding.security.AuthenticationAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AuthenticationRakpHmacSha1
extends AuthenticationAlgorithm {
    private static final String ALGORITHM_NAME = "HmacSHA1";
    private Mac mac;
    private final ReentrantLock lock = new ReentrantLock();

    public AuthenticationRakpHmacSha1() throws NoSuchAlgorithmException {
        this.mac = Mac.getInstance(ALGORITHM_NAME);
    }

    @Override
    public byte getCode() {
        return 1;
    }

    @Override
    public boolean checkKeyExchangeAuthenticationCode(byte[] data, byte[] key, String password) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] check = this.getKeyExchangeAuthenticationCode(data, password);
        return Arrays.equals(check, key);
    }

    @Override
    public byte[] getKeyExchangeAuthenticationCode(byte[] data, String password) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] key = password.getBytes();
        SecretKeySpec sKey = new SecretKeySpec(key, ALGORITHM_NAME);
        byte[] result = new byte[this.getKeyLength()];
        this.lock.lock();
        this.mac.init(sKey);
        System.arraycopy(this.mac.doFinal(data), 0, result, 0, this.getKeyLength());
        this.lock.unlock();
        return result;
    }

    @Override
    public boolean doIntegrityCheck(byte[] data, byte[] reference, byte[] sik) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec sKey = new SecretKeySpec(sik, ALGORITHM_NAME);
        byte[] result = new byte[this.getIntegrityCheckBaseLength()];
        this.lock.lock();
        this.mac.init(sKey);
        System.arraycopy(this.mac.doFinal(data), 0, result, 0, this.getIntegrityCheckBaseLength());
        this.lock.unlock();
        return Arrays.equals(result, reference);
    }

    @Override
    public int getKeyLength() {
        return 20;
    }

    @Override
    public int getIntegrityCheckBaseLength() {
        return 12;
    }
}

