/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.util.time;

import java.io.Serializable;
import java.util.Date;

public class DateRange
implements Serializable {
    protected Date start;
    protected Date end;

    public DateRange() {
    }

    public DateRange(Date start) {
        this.start = start;
    }

    public DateRange(Date start, Date end) {
        this.start = start;
        this.end = end;
    }

    public DateRange(String startUnixtime, String endUnixtime) throws NumberFormatException {
        if (startUnixtime != null) {
            this.start = new Date(Long.valueOf(startUnixtime));
        }
        if (endUnixtime != null) {
            this.end = new Date(Long.valueOf(endUnixtime));
        }
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isStartAfter(Date date) {
        return this.getStart() != null && this.getStart().getTime() > date.getTime();
    }

    public Date getOneDayBeforeStart() {
        if (this.getStart() == null) {
            throw new IllegalStateException("Can't get day before start date because start date is null");
        }
        return new Date(this.getStart().getTime() - 86400000L);
    }

    public static int getCurrentYear() {
        return new Date().getYear();
    }

    public static int getCurrentMonth() {
        return new Date().getMonth();
    }

    public static int getCurrentDayOfMonth() {
        return new Date().getDate();
    }

    public boolean hasStartOrEnd() {
        return this.getStart() != null || this.getEnd() != null;
    }

    public static int getDaysInMonth(Date date) {
        int month = date.getMonth();
        int year = date.getYear() + 1900;
        boolean isLeapYear = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] daysInMonth = new int[]{31, isLeapYear ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        return daysInMonth[month];
    }

    public static DateRange getMonthOf(Date date) {
        return new DateRange(new Date(date.getYear(), date.getMonth(), 1), new Date(date.getYear(), date.getMonth(), DateRange.getDaysInMonth(date)));
    }

    public boolean isInRange(Date date) {
        return this.getStart() != null && this.getStart().getTime() < date.getTime() && (this.getEnd() == null || this.getEnd().getTime() > date.getTime());
    }

    public boolean isValid() {
        return this.getStart() != null && (this.getEnd() == null || this.getStart().getTime() <= this.getEnd().getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRange dateRange = (DateRange)o;
        if (this.end != null ? !this.end.equals(dateRange.end) : dateRange.end != null) {
            return false;
        }
        return !(this.start != null ? !this.start.equals(dateRange.start) : dateRange.start != null);
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        return result;
    }

    public static DateRange valueOf(String s) {
        if (!s.contains("dr=")) {
            return null;
        }
        String dr = s.substring(s.indexOf("dr=") + 3);
        String[] split = (dr = dr.substring(0, dr.indexOf(";"))).split(",");
        if (split.length != 2) {
            return null;
        }
        try {
            return new DateRange(!split[0].equals("0") ? new Date(Long.valueOf(split[0])) : null, !split[1].equals("0") ? new Date(Long.valueOf(split[1])) : null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dr=");
        sb.append(this.getStart() != null ? Long.valueOf(this.getStart().getTime()) : "0");
        sb.append(",");
        sb.append(this.getEnd() != null ? Long.valueOf(this.getEnd().getTime()) : "0");
        sb.append(";");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Preset {
        ALL(new DateRange(null)),
        YEAR_TO_DATE(new DateRange(new Date(DateRange.getCurrentYear(), 0, 1))),
        MONTH_TO_DATE(new DateRange(new Date(DateRange.getCurrentYear(), DateRange.getCurrentMonth(), 1))),
        LAST_MONTH(DateRange.getMonthOf(new Date(DateRange.getCurrentYear(), DateRange.getCurrentMonth() - 1, 1))),
        LAST_YEAR(new DateRange(new Date(DateRange.getCurrentYear() - 1, 0, 1), new Date(DateRange.getCurrentYear() - 1, 11, 31)));

        DateRange dateRange;

        private Preset(DateRange dateRange) {
            this.dateRange = dateRange;
        }

        public DateRange getDateRange() {
            return this.dateRange;
        }
    }
}

