/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.iusb.protocol.RedirPacket;
import com.ami.kvm.imageredir.IUSBHeader;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class IUSBSCSI
extends RedirPacket {
    public byte Lba;
    public int instanceNum;
    public int connectionStatus = -1;
    public int dataLen;
    public int opcode;
    public ByteBuffer data;
    public String m_otherIP;
    private boolean preBuffered;
    public static final int IUSB_SCSI_PKT_SIZE = 62;
    public static final int IUSB_SCSI_PKT_SIZE_WITHOUT_HEADER = 30;
    public static final int IUSB_SCSI_OPCODE_INDEX = 41;
    public static final int OPCODE_EJECT = 27;
    public static final int OPCODE_KILL_REDIR = 246;
    public static final int MEDIA_SESSION_DISCONNECT = 247;
    public static final int IUSB_SCSI_OPCODE_KEEP_ALIVE = 243;
    public static final int DEVICE_INFO = 248;
    public static final int IUSB_SCSI_OPCODE_GET_NOTIF_STAT = 74;
    public static final int IUSB_SCSI_OPCODE_GET_NOTIF_STAT_PKT_SIZE = 37;

    public IUSBSCSI(IUSBHeader iUSBHeader) {
        this.header = iUSBHeader;
        this.instanceNum = iUSBHeader.getInstance();
        this.dataLen = (int)iUSBHeader.getDataPktLen();
    }

    public IUSBSCSI(ByteBuffer byteBuffer, boolean bl) throws RedirProtocolException {
        this.preBuffered = bl;
        this.header = new IUSBHeader();
        this.header.read(byteBuffer);
        ((IUSBHeader)this.header).setDataPktLen(byteBuffer.limit() - this.header.headerLen);
        this.dataLen = (int)((IUSBHeader)this.header).getDataPktLen();
        this.data = byteBuffer.slice();
    }

    @Override
    public void writePacket(ByteBuffer byteBuffer) {
        ((IUSBHeader)this.header).setDirection(128);
        this.header.write(byteBuffer);
        if (this.preBuffered) {
            byteBuffer.limit(this.dataLen + 32);
            byteBuffer.position(byteBuffer.limit());
        } else {
            byteBuffer.put(this.data);
        }
    }

    @Override
    public void readData(ByteBuffer byteBuffer) throws BufferUnderflowException {
        byte[] byArray = new byte[39];
        this.data = ByteBuffer.allocate(this.dataLen);
        if (byteBuffer.remaining() < this.dataLen) {
            throw new BufferUnderflowException();
        }
        this.data.put(byteBuffer);
        this.Lba = this.data.get(13);
        this.opcode = this.data.get(9) & 0xFF;
        if (this.opcode == 241 && this.dataLen > 30) {
            this.connectionStatus = this.data.get(30);
            try {
                this.data.position(31);
                this.data.get(byArray);
                this.m_otherIP = new String(byArray).trim();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                System.err.println(bufferUnderflowException.getMessage());
                this.m_otherIP = new String("");
                throw new BufferUnderflowException();
            }
        } else {
            this.connectionStatus = -1;
        }
    }

    public static void sendCommandToMediaServer(PacketMaster packetMaster, ByteBuffer byteBuffer, byte[] byArray, int n) throws RedirectionException, IOException {
        int n2;
        int n3 = n2 = 30;
        byteBuffer.clear();
        if (byArray != null && byArray.length >= 0) {
            if (byArray.length > byteBuffer.capacity() - 32) {
                Debug.out.println("Passed buffer length is greater than allocated bytebuffer capacity");
                return;
            }
            n3 += byArray.length;
            byteBuffer.limit(62 + byArray.length);
        } else {
            byteBuffer.limit(62);
        }
        if (packetMaster == null || byteBuffer == null) {
            Debug.out.println("Error sending packet. PacketMaster/packetWriteBuffer is null!!!");
            return;
        }
        IUSBHeader iUSBHeader = new IUSBHeader(n3);
        iUSBHeader.write(byteBuffer);
        byteBuffer.position(41);
        byteBuffer.put((byte)(n & 0xFF));
        if (byArray != null) {
            byteBuffer.position(62);
            byteBuffer.put(byArray);
        }
        byteBuffer.position(0);
        IUSBSCSI iUSBSCSI = new IUSBSCSI(byteBuffer, true);
        packetMaster.sendPacket(iUSBSCSI);
    }

    public static int getClientType() {
        if (JViewer.isVMApp()) {
            return 4;
        }
        return 2;
    }

    public static void SendMediaInfo(PacketMaster packetMaster, ByteBuffer byteBuffer, String string) throws RedirectionException, IOException {
        int n = -1;
        if (string == null) {
            throw new RedirectionException(LocaleStrings.getString("6_9_IUSBREDIR") + LocaleStrings.getString("6_6_IUSBREDIR"));
        }
        if (string.length() == 0 || string.length() > 256) {
            throw new RedirectionException(LocaleStrings.getString("6_9_IUSBREDIR") + LocaleStrings.getString("6_6_IUSBREDIR"));
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (string.lastIndexOf(92) != -1) {
                string = string.substring(string.lastIndexOf(92) + 1, string.length());
            }
        } else if (System.getProperty("os.name").startsWith("Linux") && string.lastIndexOf(47) != -1) {
            string = string.substring(string.lastIndexOf(47) + 1, string.length());
        }
        string = string.concat("\u0000");
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(260);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        n = IUSBSCSI.getClientType();
        byteBuffer2.putInt(n);
        byteBuffer2.put(string.getBytes());
        byteBuffer2.position(0);
        byte[] byArray = new byte[byteBuffer2.remaining()];
        byteBuffer2.get(byArray);
        IUSBSCSI.sendCommandToMediaServer(packetMaster, byteBuffer, byArray, 248);
    }
}

